<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE xsl:stylesheet
  PUBLIC "-//NetBSD/DTD NetBSD XSLT 1.0 DTD//EN"
	 "http://www.NetBSD.org/XML/htdocs/share/xml/xslt10-netbsd.dtd">

<!-- $NetBSD: portpage.xsl,v 1.34 2025/07/24 18:09:59 martin Exp $ -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:html="http://www.w3.org/1999/xhtml"
		exclude-result-prefixes="html"
		version="1.0">

<!-- XSL magic to create a ports/<port>/ - index page -->

<xsl:template match="portpage">
  <xsl:variable name="port" select="ancestor::webpage/@portpage"/>
  <xsl:call-template name="porthead">
    <xsl:with-param name="port" select="$port"/>
    <xsl:with-param name="logo" select="./@logo"/>
    <xsl:with-param name="logoh" select="./@logoheight"/>
    <xsl:with-param name="logow" select="./@logowidth"/>
    <xsl:with-param name="currel" select="./@currel"/>
  </xsl:call-template>
  <table width="100%" border="0" cellspacing="0" cellpadding="2">
    <tr>
      <td>
        <xsl:apply-templates select="*[name() != 'portinfo']"/>
      </td>
      <td valign="top" width="200">
        <xsl:apply-templates select="portinfo"/>
      </td>
    </tr>
  </table>
</xsl:template>

<xsl:template name="porthead">
  <xsl:param name="port"/>
  <xsl:param name="logo"/>
  <xsl:param name="logoh"/>
  <xsl:param name="logow"/>
  <table border="0" width="98%" summary="Port Header and Logo">
    <tr>
      <td align="left" valign="middle"
          style="vertical-align: middle;">
        <h1>NetBSD/<xsl:value-of select="$port"/></h1>
      </td>
      <td align="right" valign="middle"
          style="vertical-align: middle;">
        <xsl:if test="@logo">
	<img>
	  <xsl:attribute name="src">
	    <xsl:value-of select="concat($reltopdir,'/images/ports/')"/>
	    <xsl:value-of select="$port"/>
	    <xsl:text>/</xsl:text>
	    <xsl:value-of select="$logo"/>
	  </xsl:attribute>
	  <xsl:attribute name="height">
	    <xsl:value-of select="$logoh"/>
	  </xsl:attribute>
	  <xsl:attribute name="width">
	    <xsl:value-of select="$logow"/>
	  </xsl:attribute>
          <xsl:attribute name="alt">
            <xsl:value-of select="$port"/>
	    <xsl:text>-logo</xsl:text>
          </xsl:attribute>
	</img> 
        </xsl:if>
      </td>
    </tr>
  </table>
</xsl:template>

<xsl:template match="portabout">
  <xsl:variable name="port" select="ancestor::webpage/@portpage"/>
  <h2><xsl:text>About NetBSD/</xsl:text><xsl:value-of select="$port"/></h2>
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="portsection">
  <xsl:variable name="title" select="./@title"/>
  <h2><xsl:value-of select="$title"/></h2>
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="portnews">
  <xsl:variable name="port" select="ancestor::webpage/@portpage"/>
  <h2><xsl:text>NetBSD/</xsl:text><xsl:value-of select="$port"
  /><xsl:text> News</xsl:text></h2>
  <xsl:for-each select="child::portnewsitem">
    <dl>
      <dt>
        <b>
          <xsl:value-of select="./@date"/>
          <xsl:text>:</xsl:text>
        </b>
        &nbsp;
        <xsl:value-of select="./@title"/>
      </dt>
      <dd>
        <xsl:apply-templates/>
      </dd>
    </dl>
  </xsl:for-each>
  <xsl:if test="child::portnewsarchive">
    <p><a href="news.html">
	<xsl:text>Archive of NetBSD/</xsl:text>
	<xsl:value-of select="$port"/>
	<xsl:text> news items</xsl:text>
    </a></p>
  </xsl:if>
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="portinfo">
  <xsl:variable name="port" select="ancestor::webpage/@portpage"/>
  <xsl:variable name="currel">
    <xsl:choose>
      <xsl:when test="@currel = @currel"><xsl:value-of select="@currel" /></xsl:when>
      <xsl:otherwise><xsl:value-of select="'&release.latest;'"/></xsl:otherwise>

    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="currel.major" select="substring-before($currel, '.')"/>
  <xsl:variable name="currel.minor" select="substring-after($currel, '.')"/>
  <xsl:variable name="currel.previous.major" select="&release.previous.major;"/>
  <xsl:variable name="currel.next.major" select="&release.next.major;"/>

  <div class="portinfo">
    <xsl:if test="child::portinfoitem">
      <h2><xsl:text>NetBSD/</xsl:text><xsl:value-of select="$port"
      /><xsl:text> Information</xsl:text></h2>

      <ul>
        <xsl:for-each select="child::portinfoitem">
          <li><xsl:apply-templates/></li>
        </xsl:for-each>
      </ul>
    </xsl:if>

    <xsl:if test="child::portml">
      <h2>Mailing Lists</h2>

      <ul>
        <xsl:for-each select="child::portml">
          <xsl:variable name="ml" select="./@name"/>
          <li><font face="helvetica, arial" size="-1">
            <xsl:text>The </xsl:text>
            <a>
              <xsl:attribute name="href">
                <xsl:text>../../mailinglists/#port-</xsl:text>
                <xsl:value-of select="$ml"/>
              </xsl:attribute>
              <xsl:text>NetBSD/</xsl:text>
              <xsl:value-of select="$ml"/>
              <xsl:text> mailing list</xsl:text>
            </a>
            <xsl:text>, covering </xsl:text>
            <xsl:value-of select="./text()"/>
            <xsl:text>:</xsl:text>
            <br/>
            <xsl:text>[</xsl:text>
            &nbsp;
            <a>
              <xsl:attribute name="href">
                <xsl:text>//www.NetBSD.org/cgi-bin/subscribe_list.pl?list=port-</xsl:text>
                <xsl:value-of select="$ml"/>
              </xsl:attribute>
              <xsl:text>subscribe</xsl:text>
            </a>
            &nbsp;
            <xsl:text>|</xsl:text>
            &nbsp;
            <a>
              <xsl:attribute name="href">
                <xsl:text>//mail-index.NetBSD.org/port-</xsl:text>
                <xsl:value-of select="$ml"/>
                <xsl:text>/</xsl:text>
              </xsl:attribute>
              <xsl:text>archive</xsl:text>
            </a>
            &nbsp;
            <xsl:text>]</xsl:text>
            <br/>
            &nbsp;
          </font></li>
        </xsl:for-each>
      </ul>
    </xsl:if>

    <xsl:if test="child::portcurrentitem">
      <h2>Current Releases</h2>

      <ul>
        <xsl:for-each select="child::portcurrentitem">
          <li><font face="helvetica, arial" size="-1">
          <xsl:if test="@type='ftp'">
            <a>
              <xsl:attribute name="href">
                <xsl:value-of select="concat('ftp://ftp.NetBSD.org/pub/NetBSD/NetBSD-', $currel, '/', $port, '/')" />
              </xsl:attribute>
              <xsl:value-of select="concat('NetBSD/', $port, ' ', $currel, ' via FTP')"/>
            </a>
          </xsl:if>
          <xsl:if test="@type='installnotes'">
            <a>
              <xsl:attribute name="href">
                <xsl:value-of select="concat('ftp://ftp.NetBSD.org/pub/NetBSD/NetBSD-', $currel, '/', $port, '/INSTALL.html')" />
              </xsl:attribute>
              <xsl:value-of select="concat('NetBSD/', $port, ' ', $currel, ' Install Notes')"/>
            </a>
          </xsl:if>
          <xsl:if test="@type='ra'">
            <a>
              <xsl:attribute name="href">
		<xsl:value-of select="concat('../../releases/formal-', $currel.major, '/NetBSD-', $currel, '.html')" />
              </xsl:attribute>
              <xsl:value-of select="concat('NetBSD ', $currel, ' release announcement')" />
            </a>
          </xsl:if>
          <xsl:if test="@type='port-changes'">
            <a>
              <xsl:attribute name="href">
		<xsl:value-of select="concat('../../changes/changes-', $currel.major, '.0.html#port-', $port)" />
              </xsl:attribute>
	      <xsl:value-of select="concat('NetBSD/', $port, ' changes to ', $currel.major, '.0')" />
            </a>
          </xsl:if>
          <xsl:if test="@type='netbsd-changes'">
            <a>
              <xsl:attribute name="href">
		<xsl:value-of select="concat('ftp://ftp.NetBSD.org/pub/NetBSD/NetBSD-', $currel.major, '.0/CHANGES')"/>
              </xsl:attribute>
	      <xsl:value-of select="concat('changes from NetBSD ', $currel.previous.major, '.0 to NetBSD ', $currel.major, '.0')" />
            </a>
          </xsl:if>
          <xsl:if test="@type='packages'">
            <xsl:text>NetBSD/</xsl:text>
            <xsl:value-of select="$port"/>
            <xsl:text> </xsl:text>
            <xsl:value-of select="@packages-for"/>
            <xsl:text> </xsl:text>
            <a>
              <xsl:attribute name="href">
                <xsl:text>ftp://ftp.NetBSD.org/pub/pkgsrc/packages/NetBSD/</xsl:text>
                <xsl:value-of select="$port"/>
                <xsl:text>/</xsl:text>
                <xsl:value-of select="@packages-for"/>
                <xsl:text>/</xsl:text>
              </xsl:attribute>
              <xsl:text>pre-built binary packages</xsl:text>
            </a>
            <xsl:text> via the NetBSD </xsl:text>
            <a>
              <xsl:attribute name="href">
                <xsl:text>../../docs/software/packages.html</xsl:text>
              </xsl:attribute>
              <xsl:text>Packages Collection</xsl:text>
            </a>
          </xsl:if>
          <xsl:if test="@type='mirrors'">
            <a href="../../mirrors/">
              <xsl:text>NetBSD FTP Mirror sites</xsl:text>
            </a>
          </xsl:if>
          <xsl:if test="@type='cdroms'">
            <a href="../../sites/cdroms.html">
              <xsl:text>NetBSD on CD-ROM</xsl:text>
            </a>
          </xsl:if>
          <xsl:if test="not(@type)">
            <xsl:apply-templates/>
          </xsl:if>
          </font></li>
        </xsl:for-each>
      </ul>
    </xsl:if>

    <xsl:if test="child::portfutureitem">
      <h2>Future Releases</h2>

      <ul>
        <xsl:for-each select="child::portfutureitem">
          <xsl:variable name="type" select="./@type"/>
          <li><font face="helvetica, arial" size="-1">
            <xsl:if test="@type='changes'">
            <a>
              <xsl:attribute name="href">
                <xsl:value-of select="concat('../../changes/changes-', $currel.next.major, '.0.html#port-', $port)" />
              </xsl:attribute>
              <xsl:value-of select="concat('NetBSD/', $port, ' changes from ', $currel.major, '.0 to ', $currel.next.major, '.0')" />
            </a>
            </xsl:if>
            <xsl:if test="@type='snapshots'">
            <a>
              <xsl:attribute name="href">
                <xsl:value-of select="concat('&url.snap.http;', '/HEAD/')" />
              </xsl:attribute>
              <xsl:text>binary snapshots</xsl:text>
            </a>
            <xsl:text> of </xsl:text>
            <a href="../../releases/release-map.html">
              <xsl:text>NetBSD-current</xsl:text>
            </a>
            <xsl:text> by </xsl:text>
            <a>
              <xsl:attribute name="href">
                <xsl:text>//releng.NetBSD.org/cgi-bin/builds.cgi</xsl:text>
              </xsl:attribute>
              <xsl:text>daily snapshot builds</xsl:text>
            </a>
            </xsl:if>
          </font></li>
        </xsl:for-each>
      </ul>
    </xsl:if>

    <h2>Related Links</h2>

    <ul>
      <xsl:for-each select="child::portlinkitem">
        <li><font face="helvetica, arial" size="-1"><xsl:apply-templates/></font></li>
      </xsl:for-each>
      <li><font face="helvetica, arial" size="-1">
        <a>
          <xsl:attribute name="href">
            <xsl:text>mailto:port-</xsl:text>
            <xsl:value-of select="$port"/>
            <xsl:text>-maintainer@NetBSD.org</xsl:text>
          </xsl:attribute>
          <xsl:text>Mail the NetBSD/</xsl:text>
          <xsl:value-of select="$port"/>
          <xsl:text> port maintainer</xsl:text>
        </a>
        </font>
      </li>
    </ul>
  </div>
</xsl:template>

<!-- handled by iteration; ignore but match -->
<xsl:template match="portlinkitem|portnewsitem|portinfoitem|portfutureitem|portnewsarchive|portml">
</xsl:template>

</xsl:stylesheet>

