<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE xsl:stylesheet
  PUBLIC "-//NetBSD//DTD NetBSD XSLT 1.0 DTD//EN"
         "http://www.NetBSD.org/XML/htdocs/share/xml/xslt10-netbsd.dtd">

<!-- $NetBSD: events.xsl,v 1.2 2025/07/24 18:09:59 martin Exp $ -->

<!--

This file scans the given XML files for future events entries and prints links
to them.

The string parameter $eventsdir must be given and point to the directory
where the events file are located.

-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		version="1.0">

  <xsl:output encoding="ascii"/>
  <xsl:template match="webpage">
    <xsl:variable name="tmp_docid" select="substring-after(@id, 'gallery-')"/>
    <xsl:variable name="docid">
      <xsl:if test="$tmp_docid != 'index'">
	<xsl:value-of select="concat($tmp_docid, '.html')"/>
      </xsl:if>
      <xsl:if test="$tmp_docid = 'index'">
	<xsl:value-of select="''"/>
      </xsl:if>
    </xsl:variable>
    <xsl:for-each select="sect1/sect2">
      <xsl:variable name="tmp_id">
	<xsl:value-of select="@id"/>
      </xsl:variable>
      <xsl:if test="$tmp_id = 'future'">
	<xsl:for-each select="sect3">
	  <xsl:variable name="tmp_title" select="substring-after(title, '- ')"/>
	  <xsl:variable name="date" select="substring-before(title, ' -')"/>
	  <a>
	    <xsl:attribute name="href">
	      <xsl:value-of select="concat($eventsdir, '/', $docid, '#', @id)"/>
	    </xsl:attribute>
	    <xsl:value-of select="$tmp_title"/>
	  </a>
	  <br />
	  <xsl:value-of select="$date"/>
	  <xsl:text>&#10;</xsl:text>
	</xsl:for-each>
      </xsl:if>
    </xsl:for-each>
  </xsl:template>
</xsl:stylesheet>
