# $NetBSD: doc.docbook.xsl.mk,v 1.25 2025/08/08 19:41:35 andvar Exp $

# This file is included by doc.docbook.mk and is not intended to be
# included directly.

SX_BIN?=	${PREFIX}/bin/osx
SX_OPTS?=	${CATALOGS:S,^,-c ,} -f ${SXERR} -i xml.includes -xsdata-as-pis -xlower -xempty -b ${SX_ENCODING}
SX?=		env ${SX_ENV} ${SX_BIN} ${SX_OPTS} ${SX_FLAGS} ${XML_DECL}
SXERR?=		.sxerr
SX_ENV?=	SP_CHARSET_FIXED=YES \
		SP_ENCODING=${SP_ENCODING} \
		SGML_CATALOG_FILES=

XSLTPROC_BIN?=	${PREFIX}/bin/xsltproc
XSLTPROC_FLAGS?=
XSLTPROC_OPTS?=
XSLTPROC_OPTS+=	${XSLTPROC_FLAGS}

NSGMLS_BIN?=	${PREFIX}/bin/onsgmls
NSGMLS_OPTS?=	-s -wall ${CATALOGS:S,^,-c ,} ${NSGMLS_FLAGS} ${XML_DECL}
NSGMLS_ENV?=	SP_CHARSET_FIXED=YES \
		SP_ENCODING=${SP_ENCODING} \
		SGML_CATALOG_FILES=
NSGMLS?=	env ${NSGMLS_ENV} ${NSGMLS_BIN} ${NSGMLS_OPTS}

XML_CATALOG_FILES?=	${PREFIX}/share/xml/catalog

XSLTPROC?=	env ${XSLTPROC_ENV} ${XSLTPROC_BIN} ${XSLTPROC_ARGS} ${XSLTPROC_OPTS}

XSLT_MASTER_SINGLE?=	${WEB_PREFIX}/share/xsl/netbsd-docbook-html.xsl
XSLT_LOCAL_SINGLE?=	${.CURDIR}/share/default-html.xsl

XSLT_MASTER_SPLIT?=	${WEB_PREFIX}/share/xsl/netbsd-docbook-html-chunk.xsl
XSLT_LOCAL_SPLIT?=	${.CURDIR}/share/default-html-chunk.xsl

XSLTPROC_ENV+=	SGML_CATALOG_FILES=
XSLTPROC_ENV+=	XML_CATALOG_FILES="${XML_CATALOG_FILES}"
XSLTPROC_ARGS+=	--xinclude
.if !empty(XML_CATALOG_FILES)
XSLTPROC_ARGS+=	--nonet --catalogs
.endif

# DocBook XSLT params for each formats ........................................

# for common
XSL_DBX_WITH_MANIFEST?=					${MANIFEST}
XSL_DBX_WITH_GENERATE_SECTION_TOC_LEVEL?=		0
XSL_DBX_WITH_TOC_SECTION_DEPTH?=			1
XSL_DBX_WITH_TOC_MAX_DEPTH?=				8
XSL_DBX_WITH_SECTION_AUTOLABEL?=			1
XSL_DBX_WITH_SECTION_LABEL_INCLUDES_COMPONENT_LABEL?=	1

XSL_DBX_WITH_NETBSD_URL_IMAGE_BSDDAEMON?=	${WEB_PREFIX_RELATIVE}/images/BSD-daemon.jpg
XSL_DBX_WITH_NETBSD_URL_DISLAIMER?=		${WEB_PREFIX_RELATIVE}/about/disclaimer.html

.if !defined(XSL_DBX_COMMON_PARAMS) || empty(XSL_DBX_COMMON_PARAMS)
XSL_DBX_COMMON_PARAMS+=	XSL_DBX_WITH_MANIFEST
XSL_DBX_COMMON_PARAMS+=	XSL_DBX_WITH_TOC_SECTION_DEPTH
XSL_DBX_COMMON_PARAMS+=	XSL_DBX_WITH_TOC_MAX_DEPTH
XSL_DBX_COMMON_PARAMS+=	XSL_DBX_WITH_GENERATE_SECTION_TOC_LEVEL
XSL_DBX_COMMON_PARAMS+=	XSL_DBX_WITH_SECTION_AUTOLABEL
XSL_DBX_COMMON_PARAMS+=	XSL_DBX_WITH_SECTION_LABEL_INCLUDES_COMPONENT_LABEL
XSL_DBX_COMMON_PARAMS+=	XSL_DBX_WITH_NETBSD_URL_IMAGE_BSDDAEMON
XSL_DBX_COMMON_PARAMS+=	XSL_DBX_WITH_NETBSD_URL_DISCLAIMER
.endif

XSL_DBX_WITH_HTML_STYLESHEET?=		/global.css
XSL_DBX_WITH_USE_ID_AS_FILENAME?=	1
XSL_DBX_WITH_CITEREFENTRY_LINK?=	1

.if !defined(XSL_DBX_HTML_COMMON_PARAMS) || empty(XSL_DBX_HTML_COMMON_PARAMS)
XSL_DBX_HTML_COMMON_PARAMS+=	${XSL_DBX_COMMON_PARAMS}
XSL_DBX_HTML_COMMON_PARAMS+=	XSL_DBX_WITH_HTML_STYLESHEET
XSL_DBX_HTML_COMMON_PARAMS+=	XSL_DBX_WITH_USE_ID_AS_FILENAME
XSL_DBX_HTML_COMMON_PARAMS+=	XSL_DBX_WITH_CITEREFENTRY_LINK
.endif

# for html
XSL_DBX_WITH_CALLOUT_GRAPHICS_PATH?=	./imagelib/callouts/

.if !defined(XSL_DBX_HTML_SINGLE_PARAMS) || empty(XSL_DBX_HTML_SINGLE_PARAMS)
XSL_DBX_HTML_SINGLE_PARAMS+=	${XSL_DBX_HTML_COMMON_PARAMS}
XSL_DBX_HTML_SINGLE_PARAMS+=	XSL_DBX_WITH_CALLOUT_GRAPHICS_PATH
.endif

# for html-split
XSL_DBX_WITH_ROOT_FILENAME?=		index
XSL_DBX_WITH_HTML_EXT?=			.html
XSL_DBX_WITH_CHUNK_FIRST_SECTIONS?=	0
XSL_DBX_WITH_CHUNK_SECTION_DEPTH?=	0
XSL_DBX_WITH_GENERATE_MANIFEST?=	1

.if !defined(XSL_DBX_HTML_SPLIT_PARAMS) || empty(XSL_DBX_HTML_SPLIT_PARAMS)
XSL_DBX_HTML_SPLIT_PARAMS+=	${XSL_DBX_HTML_COMMON_PARAMS}
XSL_DBX_HTML_SPLIT_PARAMS+=	XSL_DBX_WITH_ROOT_FILENAME
XSL_DBX_HTML_SPLIT_PARAMS+=	XSL_DBX_WITH_HTML_EXT
XSL_DBX_HTML_SPLIT_PARAMS+=	XSL_DBX_WITH_CHUNK_FIRST_SECTIONS
XSL_DBX_HTML_SPLIT_PARAMS+=	XSL_DBX_WITH_CHUNK_SECTION_DEPTH
XSL_DBX_HTML_SPLIT_PARAMS+=	XSL_DBX_WITH_GENERATE_MANIFEST
.endif

# translate params to xlstproc's options

.for P in XSL_DBX_HTML_SPLIT_PARAMS XSL_DBX_HTML_SINGLE_PARAMS
.  for V in ${$P}
${P:S/PARAMS/OPTS/}+=	--param ${V:S/^XSL_DBX_WITH_//:S/_/./g:tl} "'${$V}'"
.  endfor
.  if defined(XSL_DBX_WITH_GENERATE_TOC)
${P:S/PARAMS/OPTS/}+=	--param "generate.toc" "'${XSL_DBX_WITH_GENERATE_TOC}'"
.  endif
.endfor

# targets .....................................................................

.if ${FORMATS:Mhtml} || ${FORMATS:Mascii}
CLEANFILES+=	${DOC}.html
CLEANFILES+=	default.xml
.endif
.if ${FORMATS:Mhtml-split}
CLEANFILES+=	${HTML_INDEX}
CLEANFILES+=	default-chunk.xml
.endif
.if ${FORMATS:Mascii}
CLEANFILES+=	${DOC}.txt
.endif
.if ${FORMATS:Mepub}
CLEANFILES+=	${DOC}.epub
.endif

default.xml: ${SRCS}
	echo '<?xml version="1.0" encoding="${XML_ENCODING}" ?>' > $@
	echo '<!DOCTYPE book SYSTEM "${DBX_XML_DTD}" [' >> $@
	echo '<!ENTITY % sgml.includes "IGNORE">' >> $@
	echo '<!ENTITY % xml.includes "IGNORE">' >> $@
	echo ']>' >> $@
	-${SX} ${DOC}.xml | tail -n +2 >> $@

# XXX: does not work yet
lint: ${DOC}.xml
	${NSGMLS} $?

${DOC}.html: ${XSLT_MASTER_SINGLE} ${XSLT_LOCAL_SINGLE} default.xml
	${XSLTPROC} ${XSL_DBX_HTML_SINGLE_OPTS} -o $@ \
		${XSLT_LOCAL_SINGLE} default.xml
.if !defined(NO_TIDY)
	-${TIDY} $@
.endif

${DOC}.epub: ${XSLT_MASTER_SINGLE} ${XSLT_LOCAL_SINGLE} default.xml
	${RUBY} ${XSL_PREFIX}/docbook/epub/bin/dbtoepub -o $@ \
		${XSLT_LOCAL_SINGLE} default.xml

default-chunk.xml: ${SRCS}
	echo '<?xml version="1.0" encoding="${XML_ENCODING}" ?>' > $@
	echo '<!DOCTYPE book SYSTEM "${DBX_XML_DTD}" [' >> $@
	echo '<!ENTITY % sgml.includes "IGNORE">' >> $@
	echo '<!ENTITY % xml.includes "IGNORE">' >> $@
	echo ']>' >> $@
	-${SX} ${DOC}.xml | tail -n +2 >> $@

${HTML_INDEX}: ${XSLT_MASTER_SPLIT} ${XSLT_LOCAL_SPLIT} default-chunk.xml
	${XSLTPROC} ${XSL_DBX_HTML_SPLIT_OPTS} \
		${XSLT_LOCAL_SPLIT} default-chunk.xml
.if !defined(NO_TIDY)
	-${TIDY} `cat ${MANIFEST}`
.endif

# w3m doesn't render &#8220 or &#8221 properly, so just replace them
# with normal double quotes.
${DOC}.txt: ${DOC}.html
.if exists(/usr/share/locale/en_US.UTF-8)
	LC_CTYPE=C.UTF-8 ${SED} -e 's/&#822[01];/"/g' $? > ${DOC}.tmp.html
	${W3M} -I UTF-8 -O UTF-8 ${DOC}.tmp.html | LC_CTYPE=C.UTF-8 ${SED} -e 's/[^[:print:]]/ /g' > $@
.else
	printf "Please add support to set a UTF-8 locale for your system"; exit 1
.endif
