# Welsh (cy) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                         | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | ------------------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987fed                                                 | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5ed                                                     | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987fed                                                 | 1986-12-28T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5ed                                                     | 0004-12-26T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1af                                                     | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2ail                                                    | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | Ch1                                                     | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | Ch2                                                     | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | Chwarter 1af                                            | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2ail chwarter                                           | 2019-04-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                                       | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                       | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1af                                                     | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2ail                                                    | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | Ch1                                                     | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | Ch2                                                     | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | Chwarter 1af                                            | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2ail chwarter                                           | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-02-11T12:13:14.015Z | 2ail                                                    | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7fed                                                    | 2019-07-01T00:00:00.000Z |
|                                 | MMM          | 2019-02-11T12:13:14.015Z | Chwe                                                    | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | Gor                                                     | 2019-07-01T00:00:00.000Z |
|                                 | MMMM         | 2019-02-11T12:13:14.015Z | Chwefror                                                | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | Gorffennaf                                              | 2019-07-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-02-11T12:13:14.015Z | Ch                                                      | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | G                                                       | 2019-07-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-02-11T12:13:14.015Z | 2ail                                                    | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7fed                                                    | 2019-07-01T00:00:00.000Z |
|                                 | LLL          | 2019-02-11T12:13:14.015Z | Chwe                                                    | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | Gor                                                     | 2019-07-01T00:00:00.000Z |
|                                 | LLLL         | 2019-02-11T12:13:14.015Z | Chwefror                                                | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | Gorffennaf                                              | 2019-07-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-02-11T12:13:14.015Z | Ch                                                      | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | G                                                       | 2019-07-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1af                                                     | 2018-12-30T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 49ain                                                   | 2019-12-01T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1af                                                     | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48ain                                                   | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-11T12:13:14.015Z | 11eg                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28ain                                                   | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42ain                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365fed                                                  | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | Llun                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Gwe                                                     | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | Llun                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Gwe                                                     | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | Llun                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Gwe                                                     | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | dydd Llun                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | dydd Gwener                                             | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | Ll                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | G                                                       | 2019-02-15T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | Ll                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Gw                                                      | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1af                                                     | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5ed                                                     | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | Llun                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Gwe                                                     | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | dydd Llun                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | dydd Gwener                                             | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | Ll                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | G                                                       | 2019-02-15T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | Ll                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Gw                                                      | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 2ail                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 6ed                                                     | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | Llun                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Gwe                                                     | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | dydd Llun                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | dydd Gwener                                             | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | Ll                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | G                                                       | 2019-02-15T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | Ll                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Gw                                                      | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 2ail                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 6ed                                                     | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | Llun                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Gwe                                                     | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | dydd Llun                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | dydd Gwener                                             | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | Ll                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | G                                                       | 2019-02-15T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | Ll                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Gw                                                      | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | yb                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | yh                                                      | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | yh                                                      | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | yb                                                      | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | yb                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | yh                                                      | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | yh                                                      | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | yb                                                      | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | yb                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | yh                                                      | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | yh                                                      | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | yb                                                      | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | y.b.                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | y.h.                                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | y.h.                                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | y.b.                                                    | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | b                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | h                                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | h                                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | b                                                       | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | yb                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | yh                                                      | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | yh                                                      | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | yb                                                      | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | yb                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | yh                                                      | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | yh                                                      | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | yb                                                      | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | yb                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | yh                                                      | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | yh                                                      | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | yb                                                      | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | y.b.                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | y.h.                                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | y.h.                                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | y.b.                                                    | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | b                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | h                                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | h                                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | b                                                       | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | yn y bore                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | yn y prynhawn                                           | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | gyda'r nos                                              | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | yn y nos                                                | 2019-02-11T00:00:00.000Z |
|                                 | BB           | 2019-02-11T11:13:14.015Z | yn y bore                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | yn y prynhawn                                           | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | gyda'r nos                                              | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | yn y nos                                                | 2019-02-11T00:00:00.000Z |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | yn y bore                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | yn y prynhawn                                           | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | gyda'r nos                                              | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | yn y nos                                                | 2019-02-11T00:00:00.000Z |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | yn y bore                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | yn y prynhawn                                           | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | gyda'r nos                                              | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | yn y nos                                                | 2019-02-11T00:00:00.000Z |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | yn y bore                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | yn y prynhawn                                           | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | gyda'r nos                                              | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | yn y nos                                                | 2019-02-11T00:00:00.000Z |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11eg                                                    | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11eg                                                    | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11eg                                                    | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23ain                                                   | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11eg                                                    | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11eg                                                    | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11eg                                                    | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23ain                                                   | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1af                                                     | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55fed                                                   | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1af                                                     | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55fed                                                   | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-02-11T12:13:14.015Z | 11/02/1987                                              | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/05/1453                                              | 1453-05-29T00:00:00.000Z |
|                                 | PP           | 1987-02-11T12:13:14.015Z | 11 Chwe 1987                                            | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 Mai 1453                                             | 1453-05-29T00:00:00.000Z |
|                                 | PPP          | 1987-02-11T12:13:14.015Z | 11 Chwefror 1987                                        | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 Mai 1453                                             | 1453-05-29T00:00:00.000Z |
|                                 | PPPP         | 1987-02-11T12:13:14.015Z | dydd Mercher, 11 Chwefror 1987                          | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | dydd Sul, 29 Mai 1453                                   | 1453-05-29T00:00:00.000Z |
| Long localized time             | p            | 1987-02-11T12:13:14.015Z | 12:13 yh                                                | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59 yh                                                | 1453-05-29T23:59:00.000Z |
|                                 | pp           | 1987-02-11T12:13:14.015Z | 12:13:14 yh                                             | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59:59 yh                                             | 1453-05-29T23:59:59.000Z |
|                                 | ppp          | 1987-02-11T12:13:14.015Z | 12:13:14 yh GMT+0                                       | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59:59 yh GMT+0                                       | Errored                  |
|                                 | pppp         | 1987-02-11T12:13:14.015Z | 12:13:14 yh GMT+00:00                                   | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59:59 yh GMT+00:00                                   | Errored                  |
| Combination of date and time    | Pp           | 1987-02-11T12:13:14.015Z | 11/02/1987, 12:13 yh                                    | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/05/1453, 11:59 yh                                    | 1453-05-29T23:59:00.000Z |
|                                 | PPpp         | 1987-02-11T12:13:14.015Z | 11 Chwe 1987, 12:13:14 yh                               | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 Mai 1453, 11:59:59 yh                                | 1453-05-29T23:59:59.000Z |
|                                 | PPPppp       | 1987-02-11T12:13:14.015Z | 11 Chwefror 1987 am 12:13:14 yh GMT+0                   | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 Mai 1453 am 11:59:59 yh GMT+0                        | Errored                  |
|                                 | PPPPpppp     | 1987-02-11T12:13:14.015Z | dydd Mercher, 11 Chwefror 1987 am 12:13:14 yh GMT+00:00 | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | dydd Sul, 29 Mai 1453 am 11:59:59 yh GMT+00:00          | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result          | `includeSeconds: true` | `addSuffix: true`     |
| ------------------------ | --------------- | ---------------------- | --------------------- |
| 2006-01-01T00:00:00.000Z | tua 6 mlynedd   | tua 6 mlynedd          | mewn tua 6 mlynedd    |
| 2005-01-01T00:00:00.000Z | tua 5 mlynedd   | tua 5 mlynedd          | mewn tua 5 mlynedd    |
| 2004-01-01T00:00:00.000Z | tua 4 mlynedd   | tua 4 mlynedd          | mewn tua 4 mlynedd    |
| 2003-01-01T00:00:00.000Z | tua 3 mlynedd   | tua 3 mlynedd          | mewn tua 3 mlynedd    |
| 2002-01-01T00:00:00.000Z | tua 2 flynedd   | tua 2 flynedd          | mewn tua 2 flynedd    |
| 2001-06-01T00:00:00.000Z | dros 1 flwyddyn | dros 1 flwyddyn        | mewn dros 1 flwyddyn  |
| 2001-02-01T00:00:00.000Z | tua 1 flwyddyn  | tua 1 flwyddyn         | mewn tua 1 flwyddyn   |
| 2001-01-01T00:00:00.000Z | tua 1 flwyddyn  | tua 1 flwyddyn         | mewn tua 1 flwyddyn   |
| 2000-06-01T00:00:00.000Z | 5 mis           | 5 mis                  | mewn 5 mis            |
| 2000-03-01T00:00:00.000Z | 2 fis           | 2 fis                  | mewn 2 fis            |
| 2000-02-01T00:00:00.000Z | tua 1 mis       | tua 1 mis              | mewn tua 1 mis        |
| 2000-01-15T00:00:00.000Z | 14 diwrnod      | 14 diwrnod             | mewn 14 diwrnod       |
| 2000-01-02T00:00:00.000Z | 1 diwrnod       | 1 diwrnod              | mewn 1 diwrnod        |
| 2000-01-01T06:00:00.000Z | tua 6 awr       | tua 6 awr              | mewn tua 6 awr        |
| 2000-01-01T01:00:00.000Z | tua 1 awr       | tua 1 awr              | mewn tua 1 awr        |
| 2000-01-01T00:45:00.000Z | tua 1 awr       | tua 1 awr              | mewn tua 1 awr        |
| 2000-01-01T00:30:00.000Z | 30 munud        | 30 munud               | mewn 30 munud         |
| 2000-01-01T00:15:00.000Z | 15 munud        | 15 munud               | mewn 15 munud         |
| 2000-01-01T00:01:00.000Z | 1 munud         | 1 munud                | mewn 1 munud          |
| 2000-01-01T00:00:25.000Z | llai na munud   | hanner munud           | mewn llai na munud    |
| 2000-01-01T00:00:15.000Z | llai na munud   | llai na 20 eiliad      | mewn llai na munud    |
| 2000-01-01T00:00:05.000Z | llai na munud   | llai na 10 eiliad      | mewn llai na munud    |
| 2000-01-01T00:00:00.000Z | llai na munud   | llai na 5 eiliad       | llai na munud yn ôl   |
| 1999-12-31T23:59:55.000Z | llai na munud   | llai na 10 eiliad      | llai na munud yn ôl   |
| 1999-12-31T23:59:45.000Z | llai na munud   | llai na 20 eiliad      | llai na munud yn ôl   |
| 1999-12-31T23:59:35.000Z | llai na munud   | hanner munud           | llai na munud yn ôl   |
| 1999-12-31T23:59:00.000Z | 1 munud         | 1 munud                | 1 munud yn ôl         |
| 1999-12-31T23:45:00.000Z | 15 munud        | 15 munud               | 15 munud yn ôl        |
| 1999-12-31T23:30:00.000Z | 30 munud        | 30 munud               | 30 munud yn ôl        |
| 1999-12-31T23:15:00.000Z | tua 1 awr       | tua 1 awr              | tua 1 awr yn ôl       |
| 1999-12-31T23:00:00.000Z | tua 1 awr       | tua 1 awr              | tua 1 awr yn ôl       |
| 1999-12-31T18:00:00.000Z | tua 6 awr       | tua 6 awr              | tua 6 awr yn ôl       |
| 1999-12-30T00:00:00.000Z | 2 ddiwrnod      | 2 ddiwrnod             | 2 ddiwrnod yn ôl      |
| 1999-12-15T00:00:00.000Z | 17 diwrnod      | 17 diwrnod             | 17 diwrnod yn ôl      |
| 1999-12-01T00:00:00.000Z | tua 1 mis       | tua 1 mis              | tua 1 mis yn ôl       |
| 1999-11-01T00:00:00.000Z | 2 fis           | 2 fis                  | 2 fis yn ôl           |
| 1999-06-01T00:00:00.000Z | 7 mis           | 7 mis                  | 7 mis yn ôl           |
| 1999-01-01T00:00:00.000Z | tua 1 flwyddyn  | tua 1 flwyddyn         | tua 1 flwyddyn yn ôl  |
| 1998-12-01T00:00:00.000Z | tua 1 flwyddyn  | tua 1 flwyddyn         | tua 1 flwyddyn yn ôl  |
| 1998-06-01T00:00:00.000Z | dros 1 flwyddyn | dros 1 flwyddyn        | dros 1 flwyddyn yn ôl |
| 1998-01-01T00:00:00.000Z | tua 2 flynedd   | tua 2 flynedd          | tua 2 flynedd yn ôl   |
| 1997-01-01T00:00:00.000Z | tua 3 mlynedd   | tua 3 mlynedd          | tua 3 mlynedd yn ôl   |
| 1996-01-01T00:00:00.000Z | tua 4 mlynedd   | tua 4 mlynedd          | tua 4 mlynedd yn ôl   |
| 1995-01-01T00:00:00.000Z | tua 5 mlynedd   | tua 5 mlynedd          | tua 5 mlynedd yn ôl   |
| 1994-01-01T00:00:00.000Z | tua 6 mlynedd   | tua 6 mlynedd          | tua 6 mlynedd yn ôl   |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result     | `addSuffix: true` | With forced unit (i.e. `hour`) |
| ------------------------ | ---------- | ----------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 mlynedd  | mewn 6 mlynedd    | 52608 awr                      |
| 2005-01-01T00:00:00.000Z | 5 mlynedd  | mewn 5 mlynedd    | 43848 awr                      |
| 2004-01-01T00:00:00.000Z | 4 mlynedd  | mewn 4 mlynedd    | 35064 awr                      |
| 2003-01-01T00:00:00.000Z | 3 mlynedd  | mewn 3 mlynedd    | 26304 awr                      |
| 2002-01-01T00:00:00.000Z | 2 flynedd  | mewn 2 flynedd    | 17544 awr                      |
| 2001-06-01T00:00:00.000Z | 1 flwyddyn | mewn 1 flwyddyn   | 12408 awr                      |
| 2001-02-01T00:00:00.000Z | 1 flwyddyn | mewn 1 flwyddyn   | 9528 awr                       |
| 2001-01-01T00:00:00.000Z | 1 flwyddyn | mewn 1 flwyddyn   | 8784 awr                       |
| 2000-06-01T00:00:00.000Z | 5 mis      | mewn 5 mis        | 3648 awr                       |
| 2000-03-01T00:00:00.000Z | 2 fis      | mewn 2 fis        | 1440 awr                       |
| 2000-02-01T00:00:00.000Z | 1 mis      | mewn 1 mis        | 744 awr                        |
| 2000-01-15T00:00:00.000Z | 14 diwrnod | mewn 14 diwrnod   | 336 awr                        |
| 2000-01-02T00:00:00.000Z | 1 diwrnod  | mewn 1 diwrnod    | 24 awr                         |
| 2000-01-01T06:00:00.000Z | 6 awr      | mewn 6 awr        | 6 awr                          |
| 2000-01-01T01:00:00.000Z | 1 awr      | mewn 1 awr        | 1 awr                          |
| 2000-01-01T00:45:00.000Z | 45 munud   | mewn 45 munud     | 1 awr                          |
| 2000-01-01T00:30:00.000Z | 30 munud   | mewn 30 munud     | 1 awr                          |
| 2000-01-01T00:15:00.000Z | 15 munud   | mewn 15 munud     | 0 awr                          |
| 2000-01-01T00:01:00.000Z | 1 munud    | mewn 1 munud      | 0 awr                          |
| 2000-01-01T00:00:25.000Z | 25 eiliad  | mewn 25 eiliad    | 0 awr                          |
| 2000-01-01T00:00:15.000Z | 15 eiliad  | mewn 15 eiliad    | 0 awr                          |
| 2000-01-01T00:00:05.000Z | 5 eiliad   | mewn 5 eiliad     | 0 awr                          |
| 2000-01-01T00:00:00.000Z | 0 eiliad   | 0 eiliad yn ôl    | 0 awr                          |
| 1999-12-31T23:59:55.000Z | 5 eiliad   | 5 eiliad yn ôl    | 0 awr                          |
| 1999-12-31T23:59:45.000Z | 15 eiliad  | 15 eiliad yn ôl   | 0 awr                          |
| 1999-12-31T23:59:35.000Z | 25 eiliad  | 25 eiliad yn ôl   | 0 awr                          |
| 1999-12-31T23:59:00.000Z | 1 munud    | 1 munud yn ôl     | 0 awr                          |
| 1999-12-31T23:45:00.000Z | 15 munud   | 15 munud yn ôl    | 0 awr                          |
| 1999-12-31T23:30:00.000Z | 30 munud   | 30 munud yn ôl    | 1 awr                          |
| 1999-12-31T23:15:00.000Z | 45 munud   | 45 munud yn ôl    | 1 awr                          |
| 1999-12-31T23:00:00.000Z | 1 awr      | 1 awr yn ôl       | 1 awr                          |
| 1999-12-31T18:00:00.000Z | 6 awr      | 6 awr yn ôl       | 6 awr                          |
| 1999-12-30T00:00:00.000Z | 2 ddiwrnod | 2 ddiwrnod yn ôl  | 48 awr                         |
| 1999-12-15T00:00:00.000Z | 17 diwrnod | 17 diwrnod yn ôl  | 408 awr                        |
| 1999-12-01T00:00:00.000Z | 1 mis      | 1 mis yn ôl       | 744 awr                        |
| 1999-11-01T00:00:00.000Z | 2 fis      | 2 fis yn ôl       | 1464 awr                       |
| 1999-06-01T00:00:00.000Z | 7 mis      | 7 mis yn ôl       | 5136 awr                       |
| 1999-01-01T00:00:00.000Z | 1 flwyddyn | 1 flwyddyn yn ôl  | 8760 awr                       |
| 1998-12-01T00:00:00.000Z | 1 flwyddyn | 1 flwyddyn yn ôl  | 9504 awr                       |
| 1998-06-01T00:00:00.000Z | 2 flynedd  | 2 flynedd yn ôl   | 13896 awr                      |
| 1998-01-01T00:00:00.000Z | 2 flynedd  | 2 flynedd yn ôl   | 17520 awr                      |
| 1997-01-01T00:00:00.000Z | 3 mlynedd  | 3 mlynedd yn ôl   | 26280 awr                      |
| 1996-01-01T00:00:00.000Z | 4 mlynedd  | 4 mlynedd yn ôl   | 35064 awr                      |
| 1995-01-01T00:00:00.000Z | 5 mlynedd  | 5 mlynedd yn ôl   | 43824 awr                      |
| 1994-01-01T00:00:00.000Z | 6 mlynedd  | 6 mlynedd yn ôl   | 52584 awr                      |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                         |
| ------------------------ | ------------------------------ |
| 2000-01-10T00:00:00.000Z | 10/01/2000                     |
| 2000-01-05T00:00:00.000Z | dydd Mercher am 12:00 yb       |
| 2000-01-02T00:00:00.000Z | yfory am 12:00 yb              |
| 2000-01-01T00:00:00.000Z | heddiw am 12:00 yb             |
| 1999-12-31T00:00:00.000Z | ddoe am 12:00 yb               |
| 1999-12-27T00:00:00.000Z | dydd Llun diwethaf am 12:00 yb |
| 1999-12-21T00:00:00.000Z | 21/12/1999                     |
