/*
 This file is part of GNU Taler
 (C) 2025 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 * Imports.
 */
import { Logger } from "@gnu-taler/taler-util";
import { GlobalTestState } from "../harness/harness.js";
import { setupMeasuresTestEnvironment } from "../harness/tops.js";

export const logger = new Logger("test-tops-aml-measures.ts");

/**
 * Test that reproduces an exchange bug, where the exchange
 * gets confused by the same account doing the same challenger
 * authentication twice.
 */
export async function runTopsChallengerTwiceTest(t: GlobalTestState) {
  const {
    decideMeasure,
    decideReset,
    submitForm,
    expectInvestigate,
    expectNoInvestigate,
    fakeChallenger,
    challengerPostal,
  } = await setupMeasuresTestEnvironment(t);

  {
    await decideMeasure("postal-registration");
    await fakeChallenger(challengerPostal, {
      CONTACT_NAME: "Richard Stallman",
      ADDRESS_LINES: "Bundesgasse 1\n1234 Bern",
    });
  }

  await decideReset();

  {
    await decideMeasure("postal-registration");
    await fakeChallenger(challengerPostal, {
      CONTACT_NAME: "Richard Stallman",
      ADDRESS_LINES: "Bundesgasse 1\n1234 Bern",
    });
  }
}

runTopsChallengerTwiceTest.suites = ["wallet"];
