/*
   This file is part of TALER
 Copyright (C) 2025 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_delete_unit.h
 * @brief implementation of the delete_unit function for Postgres
 * @author Bohdan Potuzhnyi
 */
#ifndef PG_DELETE_UNIT_H
#define PG_DELETE_UNIT_H

#include "taler_merchantdb_plugin.h"

/**
 * Delete a measurement unit.
 *
 * @param cls closure
 * @param instance_id instance to delete unit from
 * @param unit_id symbolic identifier
 * @param[out] no_instance set to true if @a instance_id is unknown
 * @param[out] no_unit set to true if the unit does not exist
 * @param[out] builtin_conflict set to true if the unit cannot be deleted
 * @return database result code
 */
enum GNUNET_DB_QueryStatus
TMH_PG_delete_unit (void *cls,
                    const char *instance_id,
                    const char *unit_id,
                    bool *no_instance,
                    bool *no_unit,
                    bool *builtin_conflict);

#endif
