/*  swi_debug.c -- format and print the SWI data structure.
$Id$
*/

/*
   Copyright (C) 2004 Jim Lowe
   All Rights Reserved.
  
   COPYING TERMS AND CONDITIONS:
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <limits.h>
#include "ahs.h"
#include "swvarfs.h"
#include "swlib.h"
#include "swi_debug.h"
#include "swi.h"

static STROB * buf0 = NULL;
static STROB * buf1 = NULL;
static STROB * buf1a = NULL;
static STROB * buf2 = NULL;
static STROB * buf4 = NULL;
static STROB * buf6 = NULL;
static STROB * buf8 = NULL;
static STROB * buf9 = NULL;

char *
swi_script_list_dump_string_s(SWI_SCRIPTS * xx, char * prefix)
{
	int i = 0;
	STROB * buf;
	char * tmp_s;
	
	if (buf4 == (STROB*)NULL) buf4 = strob_open(100);
	buf = buf4;

	strob_sprintf(buf, 0, "%s%p (SWI_SCRIPTS*)\n", prefix,  (void*)xx);

	i = 0;
	while(i < SWI_MAX_OBJ && xx->swi_coM[i]) {
		strob_sprintf(buf, 1, "%s%p->swi_coM[%d] = %p\n",  prefix, (void*)xx, i, xx->swi_coM[i]);
		tmp_s = swi_xfile_script_dump_string_s(xx->swi_coM[i], prefix);
		strob_sprintf(buf, 1, "%s",  tmp_s);
		i++;
	}
	return strob_str(buf);
}

char *
swi_xfile_member_dump_string_s(SWI_FILE_MEMBER * xx, char * prefix)
{
	STROB * buf;
	char * datap;	
	char * newline;	
	if (buf1 == (STROB*)NULL) buf1 = strob_open(100);
	buf = buf1;

	strob_sprintf(buf, 0, "%s%p (SWI_FILE_MEMBER*)\n", prefix,  (void*)xx);
	strob_sprintf(buf, 1, "%s%p->pathnameM       = [%s]\n", prefix, (void*)xx,  xx->pathnameM);
	strob_sprintf(buf, 1, "%s%p->is_activeM      = [%d]\n", prefix, (void*)xx,  xx->is_activeM);
	strob_sprintf(buf, 1, "%s%p->lenM            = [%d]\n", prefix, (void*)xx,  xx->lenM);
	strob_sprintf(buf, 1, "%s%p->dataM T>>>>>> BEGIN DATA\n", prefix, (void*)xx);
	datap = xx->dataM;
	newline = datap;
	while(*datap) {
		if (*datap == '\n') {
			*datap = '\0';
			strob_sprintf(buf, 1, "%s%p->dataM D>%s\n", prefix, (void*)xx, newline);
			newline = datap + 1;
		}	
		datap++;
	}
	strob_sprintf(buf, 1, "%s%p->dataM T>>>>>> END DATA\n", prefix, (void*)xx);
	return strob_str(buf);
}

char *
swi_bundle_dump_string_s(SWI_BUNDLE * xx, char * prefix)
{
	STROB * buf;
	
	if (buf1a == (STROB*)NULL) buf1a = strob_open(100);
	buf = buf1a;
	/*
	char type_idM;	
	int is_activeM;		
	char * tagM;	
	time_t create_timeM;
	time_t mod_timeM;
	*/
	strob_sprintf(buf, 0, "%s%p (SWI_BUNDLE*)\n", prefix,  (void*)xx);
	return strob_str(buf);
}

char *
swi_xfile_script_dump_string_s(SWI_CONTROL_SCRIPT * xx, char * prefix)
{
	STROB * buf;
	char * tmps;
	
	if (buf2 == (STROB*)NULL) buf2 = strob_open(100);
	buf = buf2;

	strob_sprintf(buf, 0, "%s%p (SWI_CONTROL_SCRIPT*)\n", prefix,  (void*)xx);
	strob_sprintf(buf, 1, "%s%p->is_activeM  = [%d]\n", prefix, (void*)xx,  xx->is_activeM);
	strob_sprintf(buf, 1, "%s%p->tagM        = [%s]\n", prefix, (void*)xx,  xx->tagM);
	strob_sprintf(buf, 1, "%s%p->resultM     = [%d]\n", prefix, (void*)xx,  xx->resultM);
	strob_sprintf(buf, 1, "%s%p->afileM      = [%p]\n", prefix, (void*)xx,  xx->afileM);
	tmps = swi_xfile_member_dump_string_s(xx->afileM, prefix);
	strob_sprintf(buf, 1, "%s", tmps);
	return strob_str(buf);
}

char * 
swi_xfile_dump_string_s(SWI_XFILE * xx, char * prefix)
{
	int i = 0;
	STROB * tmp = strob_open(1);
	char * tmp_s;
	SWI_FILE_MEMBER * afile;
	STROB * buf;

	if (buf0 == (STROB*)(NULL)) buf0 = strob_open(100);
	buf = buf0;

	strob_sprintf(buf, 0, "%s%p (SWI_XFILE*)\n", prefix,  (void*)xx);
	strob_sprintf(buf, 1, "%s%p->is_selectedM    = [%d]\n", prefix, (void*)xx,  xx->is_selectedM);
	strob_sprintf(buf, 1, "%s%p->typeM           = [%d]\n", prefix, (void*)xx,  xx->typeM);
	strob_sprintf(buf, 1, "%s%p->package_pathM   = [%s]\n", prefix, (void*)xx,  xx->package_pathM);
	strob_sprintf(buf, 1, "%s%p->control_dirM    = [%s]\n", prefix, (void*)xx,  xx->control_dirM);
	strob_sprintf(buf, 1, "%s%p->tagM            = [%s]\n", prefix, (void*)xx,  xx->tagM);
	strob_sprintf(buf, 1, "%s%p->swi_scM         = [%p]\n", prefix, (void*)xx,  xx->swi_scM);
	strob_sprintf(buf, 1, "%s%p->headerM         = [%p]\n", prefix, (void*)xx,  xx->headerM);
	strob_sprintf(buf, 1, "%s%p->INFO_header_indexM   = [%d]\n", prefix, (void*)xx,  xx->INFO_header_indexM);
	strob_sprintf(buf, 1, "%s%p->INDEX_header_indexM   = [%d]\n", prefix, (void*)xx,  xx->INDEX_header_indexM);
	strob_sprintf(buf, 1, "%s%p->archive_filesM  = [%p]\n", prefix, (void*)xx,  xx->archive_filesM);
	strob_sprintf(buf, 1, "%s%p->swdef_fdM       = [%d]\n",  prefix, (void*)xx,  xx->swdef_fdM);
	strob_sprintf(buf, 1, "%s%p->did_parse_def_fileM = [%d]\n",  prefix, (void*)xx,  xx->did_parse_def_fileM);

	i = 0;
	while ((afile = (SWI_FILE_MEMBER *)cplob_val(xx->archive_filesM, i))) {
		strob_sprintf(tmp, 0, "[n =%-30d]", i);
		strob_sprintf(buf, 1, "%s%p->archive_filesM[%d] = %p\n",  prefix, (void*)xx, i, (void*)afile);
		tmp_s = swi_xfile_member_dump_string_s(afile, prefix);
		strob_sprintf(buf, 1, "%s",  tmp_s);
		i++;
	}
	
	if (xx->swi_scM) {
		strob_sprintf(buf, 1, "%s%p->swi_scM = %p\n",  prefix, (void*)xx, xx->swi_scM);
		tmp_s = swi_script_list_dump_string_s(xx->swi_scM,  prefix);
		strob_sprintf(buf, 1, "%s", tmp_s);
	}
	strob_close(tmp);
	return strob_str(buf);
}

char * 
swi_product_dump_string_s(SWI_PRODUCT * xx, char * prefix)
{
	/*
	* char * package_pathM;	
	* char * control_dirM;
	* char * tagM;		
	* SWI_SCRIPTS * swi_scM;	
	* SWI_XFILE * pfilesM;
	* SWI_XFILE * swi_coM[SWI_MAX_OBJ]; 
	*/
	int i = 0;
	STROB * buf;
	SWI_XFILE * xfile;
	char * tmp_s;
	
	if (buf6 == (STROB*)NULL) buf6 = strob_open(100);
	buf = buf6;

	strob_sprintf(buf, 0, "%s%p (SWI_PRODUCT*)\n", prefix,  (void*)xx);
	strob_sprintf(buf, 1, "%s%p->package_pathM   = [%s]\n", prefix, (void*)xx,  xx->package_pathM);
	strob_sprintf(buf, 1, "%s%p->control_dirM    = [%s]\n", prefix, (void*)xx,  xx->control_dirM);
	strob_sprintf(buf, 1, "%s%p->tagM            = [%s]\n", prefix, (void*)xx,  xx->tagM);
	strob_sprintf(buf, 1, "%s%p->pfilesM         = [%p]\n", prefix, (void*)xx,  (void*)(xx->pfilesM));
	
	strob_sprintf(buf, 1, "%s%p->pfilesM         = [%p] (BEGIN PFILES)\n",
						prefix, (void*)xx,  (void*)(xx->pfilesM));
	tmp_s = swi_xfile_dump_string_s(xx->pfilesM, prefix);
	strob_sprintf(buf, 1, "%s", tmp_s);
	strob_sprintf(buf, 1, "%s%p->pfilesM         = [%p] (END PFILES)\n",
						prefix, (void*)xx,  (void*)(xx->pfilesM));
	
	strob_sprintf(buf, 1, "%s%p->filesetsM  = [%p]\n",
					prefix, (void*)xx,  (void*)(xx->filesetsM));
	if (xx->filesetsM) {
		strob_sprintf(buf, 1, "%s", strar_dump_string_s(xx->filesetsM, prefix));
	}

	/*
	* dump the fileset object addresses.
	*/
	i = 0;	
	while(i < SWI_MAX_OBJ) {
		strob_sprintf(buf, 1, "%s%p->swi_coM[%d]      = [%p]\n",
				prefix, (void*)xx,  i, (void*)(xx->swi_coM[i]));
		i++;
	}

	/*
	* dump the filesets
	*/
	i = 0;
	while(i < SWI_MAX_OBJ && (xfile = xx->swi_coM[i])) {
		strob_sprintf(buf, 1, "%s%p->swi_coM[%d] = %p (BEGIN FILESET[%d])\n",
					prefix, (void*)xx, i, (void*)(xx->swi_coM[i]), i);
		tmp_s = swi_xfile_dump_string_s(xfile, prefix);
		strob_sprintf(buf, 1, "%s", tmp_s);
		strob_sprintf(buf, 1, "%s%p->swi_coM[%d] = %p (END FILESET[%d])\n",
					prefix, (void*)xx, i, (void*)(xx->swi_coM[i]), i);
		i++;
	}
	return strob_str(buf);
}

char * 
swi_package_dump_string_s(SWI_PACKAGE * xx, char * prefix)
{
	STROB * buf;
	SWI_PRODUCT * prod;
	int i;
	STROB * tmpprefix = strob_open(10);
	char * tmps;
	
	if (buf8 == (STROB*)NULL) buf8 = strob_open(100);
	buf = buf8;

	strob_sprintf(buf, 0, "%s%p (SWI_PACKAGE*)\n", prefix,  (void*)xx);
	strob_sprintf(buf, 1, "%s%p->swi_scM         = [%p]\n", prefix, (void*)xx,  xx->swi_scM);
	strob_sprintf(buf, 1, "%s%p->exlistM             = [%p]\n", prefix, (void*)xx,  xx->exlistM);
	strob_sprintf(buf, 1, "%s%p->dfilesM             = [%p]\n", prefix, (void*)xx,  xx->dfilesM);
	strob_sprintf(buf, 1, "%s%p->current_xfileM      = [%p]\n", prefix, (void*)xx,  xx->current_xfileM);
	strob_sprintf(buf, 1, "%s%p->prev_swpath_exM     = [%p]\n", prefix, (void*)xx,  xx->prev_swpath_exM);
	strob_sprintf(buf, 1, "%s%p->dfiles_attributeM   = [%s]\n", prefix, (void*)xx,  xx->dfiles_attributeM);
	strob_sprintf(buf, 1, "%s%p->pfiles_attributeM   = [%s]\n", prefix, (void*)xx,  xx->pfiles_attributeM);

	strob_sprintf(buf, 1, "%s%p->dfilesM             = [%p] (BEGIN DFILES)\n", prefix, (void*)xx,  xx->dfilesM);
	tmps = swi_xfile_dump_string_s(xx->dfilesM, prefix);
	strob_sprintf(buf, 1, "%s", tmps);
	strob_sprintf(buf, 1, "%s%p->dfilesM             = [%p] (END DFILES)\n", prefix, (void*)xx,  xx->dfilesM);

	strob_sprintf(buf, 1, "%s%p->catalog_start_offsetM = [%d]\n", prefix, (void*)xx,  xx->catalog_start_offsetM);
	strob_sprintf(buf, 1, "%s%p->catalog_end_offsetM = [%d]\n", prefix, (void*)xx,  xx->catalog_end_offsetM);
	strob_sprintf(buf, 1, "%s%p->catalog_lengthM = [%d]\n", prefix, (void*)xx,  xx->catalog_lengthM);
	strob_sprintf(buf, 1, "%s%p->target_pathM = [%s]\n", prefix, (void*)xx,  xx->target_pathM);
	strob_sprintf(buf, 1, "%s%p->target_hostM = [%s]\n", prefix, (void*)xx,  xx->target_hostM);
	strob_sprintf(buf, 1, "%s%p->catalog_entryM = [%s]\n", prefix, (void*)xx,  xx->catalog_entryM);
	strob_sprintf(buf, 1, "%s%p->installed_software_catalogM = [%s]\n",
					prefix, (void*)xx, xx->installed_software_catalogM);

	strob_sprintf(tmpprefix, 0, "%s", prefix);
	tmps = swi_script_list_dump_string_s(xx->swi_scM,  strob_str(tmpprefix));
	strob_sprintf(buf, 1, "%s", tmps);

	/*
	* dump the products
	*/
	i = 0;
	while(i < SWI_MAX_OBJ && (prod = xx->swi_coM[i])) {
		strob_sprintf(buf, 1, "%s%p->swi_coM[%d] = %p (BEGIN PRODUCT[%d])\n",
				 prefix, (void*)xx, i, (void*)(xx->swi_coM[i]), i);
		tmps = swi_product_dump_string_s(prod, prefix);
		strob_sprintf(buf, 1, "%s", tmps);
		strob_sprintf(buf, 1, "%s%p->swi_coM[%d] = %p (END PRODUCT[%d])\n",
				 prefix, (void*)xx, i, (void*)(xx->swi_coM[i]), i);
		i++;
	}
	strob_close(tmpprefix);
	return strob_str(buf);
}

char * 
swi_dump_string_s(SWI * xx, char * prefix)
{
	STROB * buf;
	char * tmp_s;
	if (buf9 == (STROB*)NULL) buf9 = strob_open(100);
	buf = buf9;
	strob_sprintf(buf, 0, "%s%p (SWI*)\n", prefix, (void*)xx);
	tmp_s = swi_package_dump_string_s(xx->swi_pkgM, prefix);
	strob_sprintf(buf, 0, "%s", tmp_s);
	return strob_str(buf);
}
