/* swi_base.c -- 

   Copyright (C) 2005 Jim Lowe
   All Rights Reserved.
  
   COPYING TERMS AND CONDITIONS:
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "swuser_config.h"
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "swpath.h"
#include "swheader.h"
#include "swheaderline.h"
#include "ugetopt_help.h"
#include "to_oct.h"
#include "tarhdr.h"
#include "atomicio.h"
#include "swi_common.h"
#include "swi_base.h"

void
swi_base_init(SWI_BASE * base, int type, SWHEADER * index, SWPATH_EX * current)
{
	int current_file_offset;
	char * tag;
	int ret;

	base->id_startM = SWI_BASE_ID_BEGIN;
	base->type_idM = type;
	base->is_activeM = 0;
	base->tagM = NULL;
	base->create_timeM = 0;
	base->mod_timeM = 0;
	base->global_indexM = index;
	base->id_endM = SWI_BASE_ID_END;
	if (index && current) {
		ret = swi_com_set_header_index(index, current, &(base->header_indexM));
		SWLIB_ASSERT(ret == 0);
		current_file_offset = swheader_get_current_offset(index);
		swheader_set_current_offset(index, base->header_indexM);
		tag = swheader_get_single_attribute_value(index, SW_A_tag);
		swheader_set_current_offset(index, current_file_offset);
		SWLIB_ASSERT(tag != NULL);
		base->tagM = strdup(tag);
	}
}

void
swi_base_assert(SWI_BASE * base)
{
	SWLIB_ASSERT(base->id_startM == SWI_BASE_ID_BEGIN);
	SWLIB_ASSERT(base->id_endM == SWI_BASE_ID_END);
}

void
swi_base_set_is_active(SWI_BASE * base, int n)
{
	base->is_activeM = n;
}

int
swi_base_update(void * vbase, void * user_)
{
	SWI_BASE * base = vbase;
	swi_base_assert(base);
	base->is_activeM = 1;
	if (base->create_timeM == 0) {
		time(&(base->create_timeM));
	}
	time(&(base->mod_timeM));
	return 0;
}

