/* simi.h

   originally written by Frederic Bois

   Copyright (c) 1993.  Don Maszle, Frederic Bois.  All rights reserved.

   -- Revisions -----
     Logfile:  SCCS/s.simi.h
    Revision:  1.7
        Date:  10 Jan 1997
     Modtime:  03:05:32
      Author:  @a
   -- SCCS  ---------

   Header file for simi.c
*/

#ifndef _SIMI_H_
#define _SIMI_H_

/* ----------------------------------------------------------------------------
   Inclusions
*/

#include "sim.h"
#include "strutil.h"


#define INIT_KERNELSD 1.0  /* Initial value of MH std dev divisor */

/* ----------------------------------------------------------------------------
   Prototypes
*/

BOOL CheckDistribParam(PLIST plist, HVAR hvar1, HVAR hvar2);
void DListToArray (PLIST plist, PINT pcDouble, PDOUBLE *ppDouble);
BOOL EndExperiment (PINPUTBUF pibIn, PANALYSIS panal);
BOOL EndLevel (PANALYSIS panal);
void FreeLevels (PANALYSIS panal);
int  FreeMCLists (PVOID pData, PVOID pUserInfo);
void FreeOneLevel (PLEVEL plevel);
BOOL GetData (PINPUTBUF pibIn, PSTR szLex, POUTSPEC pos);
BOOL GetGibbsSpec (PINPUTBUF pibIn, PEXPERIMENT pexp, int iKwCode);
BOOL GetIntegrate (PINPUTBUF pibIn, PINTSPEC pis);
PSTR GetKeyword (int iKWCode);
int  GetKeywordCode (PSTR szKeyword, PINT pfContext);
BOOL GetListOfData (PINPUTBUF pibIn, PDATAREC pda, PSTR szLex);
BOOL GetListOfTimes (PINPUTBUF pibIn, int nRecs, PPRINTREC *ppr, PSTR szLex);
int  GetMCVaryParam(PINPUTBUF pibIn, PSTR szLex,
                    PLIST plist, int n, PMCVAR pmcvar);
int  GetMCVarySpec (PINPUTBUF pibIn, PANALYSIS panal, PSTR szLex);
int  GetMonteCarloSpec (PINPUTBUF pibIn, PANALYSIS panal, PSTR szLex);
BOOL GetOutputFile (PINPUTBUF pibIn, PSTR szLex, POUTSPEC pos);
BOOL GetParmMod (PINPUTBUF pibIn, PSTRLEX szLex, PSTREQN szeqn);
BOOL GetPrint (PINPUTBUF pibIn, PSTR szLex, POUTSPEC pos);
BOOL GetPrintStep (PINPUTBUF pibIn, PSTR szLex, POUTSPEC pos);
int  GetSetPointsSpec (PINPUTBUF pibIn, PANALYSIS  panal, PSTR szLex);
BOOL GetSimType (PINPUTBUF pibIn);
BOOL GetSimulate (PINPUTBUF pibIn, PEXPERIMENT pexp);
BOOL GetStringArg (PINPUTBUF pibIn, PSTR *pszArg, PSTR szLex, BOOL bDelim);
int  GetTerminator (PINPUTBUF pibIn, PSTR szLex);
long ImFromLex (PSTR szLex);
int  McvFromLex (PSTR szLex);
void NewExperiment (PINPUTBUF pibIn);
int  OneDToArray (PVOID pData, PVOID pInfo);
void ProcessWord (PINPUTBUF pibIn, PSTR szLex, PSTR szEqn);
BOOL ReadAnalysis (PINPUTBUF);
int  SetLevel (PINPUTBUF pibIn);
BOOL YesNoFromLex (PSTR szLex);

#endif /* _SIMI_H_ */

/* End */

