/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.models;

import gnu.kawa.models.DrawImage;
import gnu.kawa.models.DrawShape;
import gnu.kawa.models.Picture;
import gnu.kawa.models.PictureVisitor;
import gnu.kawa.models.WithTransform;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.List;

public class PBox
implements Picture {
    char axis;
    Picture[] children;
    Rectangle2D bounds;
    double[] translations;

    private PBox(char axis, Picture[] children) {
        this.axis = axis;
        this.children = children;
        this.init();
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.bounds;
    }

    void init() {
        int n = this.children.length;
        if (n == 0) {
            return;
        }
        Rectangle2D prevBounds = this.children[0].getBounds2D();
        double minX = prevBounds.getMinX();
        double maxX = prevBounds.getMaxX();
        double minY = prevBounds.getMinY();
        double maxY = prevBounds.getMaxY();
        double deltaX = 0.0;
        double deltaY = 0.0;
        this.translations = new double[n];
        for (int i = 1; i < n; ++i) {
            double cmaxY;
            double cmaxX;
            double cminY;
            Rectangle2D curBounds = this.children[i].getBounds2D();
            double delta = 0.0;
            if (this.axis == 'X') {
                delta = prevBounds.getMaxX() - curBounds.getMinX();
                deltaX += delta;
            } else if (this.axis == 'Y') {
                delta = prevBounds.getMaxY() - curBounds.getMinY();
                deltaY += delta;
            }
            this.translations[i] = delta + this.translations[i - 1];
            double cminX = curBounds.getMinX() + deltaX;
            if (cminX < minX) {
                minX = cminX;
            }
            if ((cminY = curBounds.getMinY() + deltaY) < minY) {
                minY = cminY;
            }
            if ((cmaxX = curBounds.getMaxX() + deltaX) > maxX) {
                maxX = cmaxX;
            }
            if ((cmaxY = curBounds.getMaxY() + deltaY) > maxY) {
                maxY = cmaxY;
            }
            prevBounds = curBounds;
        }
        this.bounds = new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics2D graphics) {
        AffineTransform saved = graphics.getTransform();
        try {
            int n = this.children.length;
            double prevOffset = 0.0;
            for (int i = 0; i < n; ++i) {
                double offset = this.translations[i];
                if (i > 0 && this.axis != 'Z') {
                    double delta = offset - prevOffset;
                    if (this.axis == 'X') {
                        graphics.translate(delta, 0.0);
                    } else {
                        graphics.translate(0.0, delta);
                    }
                }
                prevOffset = offset;
                this.children[i].paint(graphics);
            }
        }
        finally {
            graphics.setTransform(saved);
        }
    }

    @Override
    public Picture transform(AffineTransform tr) {
        return new WithTransform(this, tr);
    }

    public static PBox makeHBox(Object ... args) {
        return new PBox('X', PBox.asPictureAll(args));
    }

    public static PBox makeVBox(Object ... args) {
        return new PBox('Y', PBox.asPictureAll(args));
    }

    public static PBox makeZBox(Object ... args) {
        return new PBox('Z', PBox.asPictureAll(args));
    }

    public static Picture combine(List parts) {
        int nparts = parts.size();
        Picture[] pics = new Picture[nparts];
        parts.toArray(pics);
        return nparts == 1 ? pics[0] : new PBox('Z', pics);
    }

    public static Picture asPicture(Object arg) {
        if (arg instanceof BufferedImage) {
            return new DrawImage((BufferedImage)arg);
        }
        if (arg instanceof Shape) {
            return new DrawShape((Shape)arg);
        }
        return (Picture)arg;
    }

    public static Picture[] asPictureAll(Object[] args) {
        int np = args.length;
        Picture[] p = new Picture[np];
        for (int i = 0; i < np; ++i) {
            p[i] = PBox.asPicture(args[i]);
        }
        return p;
    }

    @Override
    public void visit(PictureVisitor visitor) {
        visitor.visitPBox(this);
    }
}

