/*
 * Decompiled with CFR 0.152.
 */
package kawa.lib;

import gnu.expr.GenericProc;
import gnu.expr.ModuleBody;
import gnu.expr.ModuleInfo;
import gnu.expr.ModuleMethod;
import gnu.kawa.functions.AddOp;
import gnu.kawa.functions.Arithmetic;
import gnu.kawa.functions.Format;
import gnu.kawa.functions.MultiplyOp;
import gnu.kawa.lispexpr.LangObjType;
import gnu.kawa.lispexpr.LispReader;
import gnu.lists.Consumer;
import gnu.lists.FString;
import gnu.mapping.CallContext;
import gnu.mapping.Procedure;
import gnu.mapping.SimpleSymbol;
import gnu.mapping.WrongType;
import gnu.math.BitOps;
import gnu.math.Complex;
import gnu.math.DComplex;
import gnu.math.DFloNum;
import gnu.math.Duration;
import gnu.math.IntNum;
import gnu.math.Numeric;
import gnu.math.Quantity;
import gnu.math.RatNum;
import gnu.math.RealNum;
import gnu.math.Unit;
import java.math.BigInteger;
import kawa.lib.std_syntax;
import kawa.standard.throw_name;

public class numbers
extends ModuleBody {
    public static final ModuleMethod number$Qu;
    public static final ModuleMethod quantity$Qu;
    public static final ModuleMethod complex$Qu;
    public static final ModuleMethod real$Qu;
    public static final ModuleMethod rational$Qu;
    public static final ModuleMethod integer$Qu;
    public static final ModuleMethod exact$Qu;
    public static final ModuleMethod inexact$Qu;
    public static final ModuleMethod zero$Qu;
    public static final ModuleMethod positive$Qu;
    public static final ModuleMethod negative$Qu;
    public static final ModuleMethod odd$Qu;
    public static final ModuleMethod even$Qu;
    public static final ModuleMethod max;
    public static final ModuleMethod min;
    public static final ModuleMethod abs;
    public static final GenericProc quotient;
    public static final GenericProc remainder;
    public static final GenericProc modulo;
    public static final ModuleMethod gcd;
    public static final ModuleMethod lcm;
    public static final ModuleMethod numerator;
    public static final ModuleMethod denominator;
    public static final ModuleMethod floor;
    public static final ModuleMethod ceiling;
    public static final ModuleMethod truncate;
    public static final ModuleMethod round;
    public static final ModuleMethod rationalize;
    public static final ModuleMethod exp;
    public static final ModuleMethod log;
    public static final ModuleMethod sin;
    public static final ModuleMethod cos;
    public static final ModuleMethod tan;
    public static final ModuleMethod asin;
    public static final ModuleMethod acos;
    public static final GenericProc atan;
    public static final GenericProc sqrt;
    public static final ModuleMethod make$Mnrectangular;
    public static final ModuleMethod make$Mnpolar;
    public static final ModuleMethod real$Mnpart;
    public static final ModuleMethod imag$Mnpart;
    public static final ModuleMethod magnitude;
    public static final ModuleMethod angle;
    public static final ModuleMethod exact$Mn$Grinexact;
    public static final ModuleMethod inexact$Mn$Grexact;
    public static final ModuleMethod bitwise$Mnarithmetic$Mnshift;
    public static final ModuleMethod bitwise$Mnarithmetic$Mnshift$Mnleft;
    public static final ModuleMethod bitwise$Mnarithmetic$Mnshift$Mnright;
    public static final ModuleMethod bitwise$Mnnot;
    public static final ModuleMethod logop;
    public static final ModuleMethod bitwise$Mnbit$Mnset$Qu;
    public static final ModuleMethod bitwise$Mncopy$Mnbit;
    public static final ModuleMethod bitwise$Mncopy$Mnbit$Mnfield;
    public static final ModuleMethod bitwise$Mnbit$Mnfield;
    public static final ModuleMethod bitwise$Mnand;
    public static final ModuleMethod bitwise$Mnior;
    public static final ModuleMethod bitwise$Mnxor;
    public static final ModuleMethod bitwise$Mnif;
    public static final ModuleMethod logtest;
    public static final ModuleMethod logcount;
    public static final ModuleMethod bitwise$Mnbit$Mncount;
    public static final ModuleMethod bitwise$Mnlength;
    public static final ModuleMethod bitwise$Mnfirst$Mnbit$Mnset;
    public static final ModuleMethod bitwise$Mnrotate$Mnbit$Mnfield;
    public static final ModuleMethod bitwise$Mnreverse$Mnbit$Mnfield;
    public static final ModuleMethod number$Mn$Grstring;
    public static final ModuleMethod string$Mn$Grnumber;
    public static final ModuleMethod quantity$Mn$Grnumber;
    public static final ModuleMethod quantity$Mn$Grunit;
    public static final ModuleMethod make$Mnquantity;
    public static final ModuleMethod duration;
    static final ModuleMethod lambda$Fn1;
    static final ModuleMethod lambda$Fn2;
    static final ModuleMethod lambda$Fn3;
    static final ModuleMethod lambda$Fn4;
    static final ModuleMethod lambda$Fn5;
    static final ModuleMethod lambda$Fn6;
    static final IntNum Lit0;
    static final IntNum Lit1;
    static final ModuleMethod lambda$Fn7;
    static final ModuleMethod lambda$Fn8;
    static final ModuleMethod lambda$Fn9;
    static final ModuleMethod lambda$Fn10;
    static final SimpleSymbol Lit2;
    static final IntNum Lit3;
    public static final numbers $instance;
    static final SimpleSymbol Lit4;
    static final SimpleSymbol Lit5;
    static final SimpleSymbol Lit6;
    static final SimpleSymbol Lit7;
    static final SimpleSymbol Lit8;
    static final SimpleSymbol Lit9;
    static final SimpleSymbol Lit10;
    static final SimpleSymbol Lit11;
    static final SimpleSymbol Lit12;
    static final SimpleSymbol Lit13;
    static final SimpleSymbol Lit14;
    static final SimpleSymbol Lit15;
    static final SimpleSymbol Lit16;
    static final SimpleSymbol Lit17;
    static final SimpleSymbol Lit18;
    static final SimpleSymbol Lit19;
    static final SimpleSymbol Lit20;
    static final SimpleSymbol Lit21;
    static final SimpleSymbol Lit22;
    static final SimpleSymbol Lit23;
    static final SimpleSymbol Lit24;
    static final SimpleSymbol Lit25;
    static final SimpleSymbol Lit26;
    static final SimpleSymbol Lit27;
    static final SimpleSymbol Lit28;
    static final SimpleSymbol Lit29;
    static final SimpleSymbol Lit30;
    static final SimpleSymbol Lit31;
    static final SimpleSymbol Lit32;
    static final SimpleSymbol Lit33;
    static final SimpleSymbol Lit34;
    static final SimpleSymbol Lit35;
    static final SimpleSymbol Lit36;
    static final SimpleSymbol Lit37;
    static final SimpleSymbol Lit38;
    static final SimpleSymbol Lit39;
    static final SimpleSymbol Lit40;
    static final SimpleSymbol Lit41;
    static final SimpleSymbol Lit42;
    static final SimpleSymbol Lit43;
    static final SimpleSymbol Lit44;
    static final SimpleSymbol Lit45;
    static final SimpleSymbol Lit46;
    static final SimpleSymbol Lit47;
    static final SimpleSymbol Lit48;
    static final SimpleSymbol Lit49;
    static final SimpleSymbol Lit50;
    static final SimpleSymbol Lit51;
    static final SimpleSymbol Lit52;
    static final SimpleSymbol Lit53;
    static final SimpleSymbol Lit54;
    static final SimpleSymbol Lit55;
    static final SimpleSymbol Lit56;
    static final SimpleSymbol Lit57;
    static final SimpleSymbol Lit58;
    static final SimpleSymbol Lit59;
    static final SimpleSymbol Lit60;
    static final SimpleSymbol Lit61;
    static final SimpleSymbol Lit62;
    static final SimpleSymbol Lit63;
    static final SimpleSymbol Lit64;
    static final SimpleSymbol Lit65;
    static final SimpleSymbol Lit66;
    static final SimpleSymbol Lit67;
    static final SimpleSymbol Lit68;
    static final SimpleSymbol Lit69;

    public numbers() {
        ModuleInfo.register(this);
    }

    public static boolean isNumber(Object x) {
        return x instanceof Numeric;
    }

    public static boolean isQuantity(Object x) {
        return x instanceof Quantity;
    }

    public static boolean isComplex(Object x) {
        return x instanceof Complex;
    }

    public static boolean isReal(Object x) {
        return x instanceof RealNum;
    }

    public static boolean isRational(Object x) {
        return x instanceof RatNum;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isInteger(Object x) {
        Boolean x62;
        Boolean bl;
        boolean bl2;
        boolean x2 = x instanceof IntNum;
        if (x2) {
            bl2 = x2;
            return bl2;
        }
        boolean x7 = x instanceof DFloNum;
        if (x7) {
            Object object2 = x;
            try {
                if (Math.IEEEremainder(((DFloNum)object2).doubleValue(), 1.0) == 0.0) {
                    bl = Boolean.TRUE;
                }
                bl = Boolean.FALSE;
            }
            catch (ClassCastException classCastException) {
                throw new WrongType(classCastException, "gnu.math.DFloNum.doubleValue()", 1, object2);
            }
        } else {
            bl = x62 = x7 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (x62 != Boolean.FALSE) {
            if (x62 == Boolean.FALSE) return false;
            return true;
        }
        boolean x6 = x instanceof Number;
        if (!x6) {
            void var3_2;
            bl2 = var3_2;
            return bl2;
        }
        boolean x5 = x instanceof Long;
        if (x5) {
            bl2 = x5;
            return bl2;
        }
        boolean x4 = x instanceof Integer;
        if (x4) {
            bl2 = x4;
            return bl2;
        }
        boolean x3 = x instanceof Short;
        if (x3) {
            bl2 = x3;
            return bl2;
        }
        bl2 = x instanceof BigInteger;
        return bl2;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isExact(Object x) {
        void var1_1;
        boolean x2 = x instanceof Numeric;
        return x2 ? ((Numeric)x).isExact() : var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isInexact(Object x) {
        void var1_1;
        boolean x2 = x instanceof Numeric;
        return (x2 ? ((Numeric)x).isExact() + 1 & 1 : var1_1) != 0;
    }

    public static boolean isZero(Numeric x) {
        return x.isZero();
    }

    public static boolean isPositive(RealNum x) {
        return x.sign() > 0;
    }

    public static boolean isNegative(RealNum x) {
        return x.isNegative();
    }

    public static boolean isOdd(IntNum x) {
        return x.isOdd();
    }

    public static boolean isEven(IntNum x) {
        return (numbers.isOdd(x) + 1 & 1) != 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object max(Object ... args) {
        RealNum result;
        Object object3 = args[0];
        try {
            result = (RealNum)object3;
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, null, -4, object3);
        }
        int n = args.length;
        int i = 1;
        while (i < n) {
            Object object2 = args[i];
            try {
                result = result.max((RealNum)object2);
                ++i;
            }
            catch (ClassCastException classCastException) {
                throw new WrongType(classCastException, "gnu.math.RealNum.max(gnu.math.RealNum)", 2, object2);
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object min(Object ... args) {
        RealNum result;
        Object object2 = args[0];
        try {
            result = (RealNum)object2;
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, null, -4, object2);
        }
        int n = args.length;
        int i = 0;
        while (i < n) {
            Object object3 = args[i];
            try {
                result = result.min((RealNum)object3);
                ++i;
            }
            catch (ClassCastException classCastException) {
                throw new WrongType(classCastException, "gnu.math.RealNum.min(gnu.math.RealNum)", 2, object3);
            }
        }
        return result;
    }

    public static Numeric abs(Numeric x) {
        return x.abs();
    }

    static IntNum lambda1(IntNum x, IntNum y) {
        return IntNum.quotient(x, y);
    }

    static RealNum lambda2(RealNum x, RealNum y) {
        return RealNum.divide(x, y).toInt(Numeric.TRUNCATE);
    }

    static IntNum lambda3(IntNum x, IntNum y) {
        return IntNum.remainder(x, y);
    }

    static RealNum lambda4(RealNum x, RealNum y) {
        return numbers.isZero(y) ? (numbers.isExact(y) ? x : (RealNum)numbers.exact$To$Inexact(x)) : (RealNum)((Procedure)AddOp.$Mn).apply2(x, ((Procedure)MultiplyOp.$St).apply2(RealNum.divide(x, y).toInt(Numeric.TRUNCATE), y));
    }

    static IntNum lambda5(IntNum x, IntNum y) {
        return IntNum.modulo(x, y);
    }

    static RealNum lambda6(RealNum x, RealNum y) {
        return numbers.isZero(y) ? (numbers.isExact(y) ? x : (RealNum)numbers.exact$To$Inexact(x)) : (RealNum)((Procedure)AddOp.$Mn).apply2(x, ((Procedure)MultiplyOp.$St).apply2(RealNum.divide(x, y).toInt(Numeric.FLOOR), y));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IntNum gcd(Object ... args) {
        int i;
        IntNum result;
        IntNum intNum;
        int n = args.length;
        if (numbers.isZero(IntNum.make(n))) {
            intNum = LangObjType.coerceIntNum(Lit0);
            return intNum;
        }
        Object object2 = args[0];
        try {
            result = LangObjType.coerceIntNum(object2);
            i = 1;
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, null, -4, object2);
        }
        while (true) {
            if (i >= n) {
                intNum = result;
                return intNum;
            }
            result = IntNum.gcd(result, LangObjType.coerceIntNum(args[i]));
            ++i;
        }
    }

    public static IntNum lcm(Object ... args) {
        IntNum intNum;
        int n = args.length;
        if (numbers.isZero(IntNum.make(n))) {
            intNum = LangObjType.coerceIntNum(Lit1);
        } else {
            IntNum result = IntNum.abs(LangObjType.coerceIntNum(args[0]));
            int i = 1;
            while (true) {
                if (i >= n) {
                    intNum = result;
                    break;
                }
                result = IntNum.lcm(result, LangObjType.coerceIntNum(args[i]));
                ++i;
            }
        }
        return intNum;
    }

    public static IntNum numerator(RatNum x) {
        return x.numerator();
    }

    public static IntNum denominator(RatNum x) {
        return x.denominator();
    }

    public static RealNum floor(RealNum x) {
        return x.toInt(Numeric.FLOOR);
    }

    public static RealNum ceiling(RealNum x) {
        return x.toInt(Numeric.CEILING);
    }

    public static RealNum truncate(RealNum x) {
        return x.toInt(Numeric.TRUNCATE);
    }

    public static RealNum round(RealNum x) {
        return x.toInt(Numeric.ROUND);
    }

    public static RealNum rationalize(RealNum x, RealNum y) {
        return RatNum.rationalize((RealNum)x.sub(y), (RealNum)x.add(y));
    }

    public static Complex exp(Complex x) {
        return x.exp();
    }

    public static Complex log(Complex x) {
        return x.log();
    }

    public static double sin(double x) {
        return Math.sin(x);
    }

    public static double cos(double x) {
        return Math.cos(x);
    }

    public static double tan(double x) {
        return Math.tan(x);
    }

    public static double asin(double x) {
        return Math.asin(x);
    }

    public static double acos(double x) {
        return Math.acos(x);
    }

    static double lambda7(double y, double x) {
        return Math.atan2(y, x);
    }

    static double lambda8(double x) {
        return Math.atan(x);
    }

    static Quantity lambda9(Quantity num) {
        return Quantity.make(num.number().sqrt(), num.unit().sqrt());
    }

    static double lambda10(double x) {
        return Math.sqrt(x);
    }

    public static Complex makeRectangular(RealNum x, RealNum y) {
        return Complex.make(x, y);
    }

    public static DComplex makePolar(double x, double y) {
        return Complex.polar(x, y);
    }

    public static RealNum realPart(Complex x) {
        return x.re();
    }

    public static RealNum imagPart(Complex x) {
        return x.im();
    }

    public static Numeric magnitude(Numeric x) {
        return x.abs();
    }

    public static RealNum angle(Complex x) {
        return x.angle();
    }

    public static Numeric exact$To$Inexact(Numeric num) {
        return num.isExact() ? new DFloNum(((RealNum)num).doubleValue()) : num;
    }

    public static Numeric inexact$To$Exact(Numeric num) {
        return num instanceof RealNum ? ((RealNum)num).toExact() : num;
    }

    public static IntNum bitwiseArithmeticShift(IntNum value, int amount) {
        return IntNum.shift(value, amount);
    }

    public static IntNum bitwiseArithmeticShiftLeft(IntNum value, int amount) {
        block0: {
            if (amount >= 0) break block0;
            ((Procedure)throw_name.throwName).apply2(Lit2, "shift amount must be non-negative");
        }
        return IntNum.shift(value, amount);
    }

    public static IntNum bitwiseArithmeticShiftRight(IntNum value, int amount) {
        block0: {
            if (amount >= 0) break block0;
            ((Procedure)throw_name.throwName).apply2(Lit2, "shift amount must be non-negative");
        }
        return IntNum.shift(value, -amount);
    }

    public static IntNum bitwiseNot(IntNum i) {
        return BitOps.not(i);
    }

    public static IntNum logop(int op, IntNum i, IntNum j) {
        return BitOps.bitOp(op, i, j);
    }

    public static boolean isBitwiseBitSet(IntNum i, int bitno) {
        return BitOps.bitValue(i, bitno);
    }

    public static IntNum bitwiseCopyBit(IntNum i, int bitno, int new$Mnvalue) {
        return BitOps.setBitValue(i, bitno, new$Mnvalue);
    }

    public static IntNum bitwiseCopyBitField(IntNum to, int start, int end, IntNum from) {
        IntNum mask2;
        IntNum intNum;
        IntNum mask1;
        IntNum intNum2 = Lit3;
        try {
            mask1 = numbers.bitwiseArithmeticShiftLeft(LangObjType.coerceIntNum(intNum2), start);
            intNum = Lit3;
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "bitwise-arithmetic-shift-left", 0, (Object)intNum2);
        }
        try {
            mask2 = numbers.bitwiseNot(numbers.bitwiseArithmeticShiftLeft(LangObjType.coerceIntNum(intNum), end));
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "bitwise-arithmetic-shift-left", 0, (Object)intNum);
        }
        IntNum mask = numbers.bitwiseAnd(mask1, mask2);
        return numbers.bitwiseIf(mask, numbers.bitwiseArithmeticShiftLeft(from, start), to);
    }

    public static IntNum bitwiseBitField(IntNum i, int start, int end) {
        return BitOps.extract(i, start, end);
    }

    /*
     * Loose catch block
     */
    public static IntNum bitwiseAnd(Object ... args) {
        Object object2;
        Object object3;
        IntNum intNum;
        int n = args.length;
        if (numbers.isZero(IntNum.make(n))) {
            intNum = LangObjType.coerceIntNum(Lit3);
        } else {
            object3 = args[0];
            IntNum result = LangObjType.coerceIntNum(object3);
            int i = 1;
            while (true) {
                if (i >= n) {
                    intNum = result;
                    break;
                }
                object2 = args[i];
                IntNum arg$Mni = LangObjType.coerceIntNum(object2);
                result = BitOps.and(result, arg$Mni);
                ++i;
            }
        }
        return intNum;
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, null, -4, object3);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, null, -4, object2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IntNum bitwiseIor(Object ... args) {
        int i;
        IntNum result;
        IntNum intNum;
        int n = args.length;
        if (numbers.isZero(IntNum.make(n))) {
            intNum = LangObjType.coerceIntNum(Lit0);
            return intNum;
        }
        Object object3 = args[0];
        try {
            result = LangObjType.coerceIntNum(object3);
            i = 1;
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, null, -4, object3);
        }
        while (true) {
            if (i >= n) {
                intNum = result;
                return intNum;
            }
            Object object2 = args[i];
            try {
                result = BitOps.ior(result, LangObjType.coerceIntNum(object2));
                ++i;
            }
            catch (ClassCastException classCastException) {
                throw new WrongType(classCastException, "gnu.math.BitOps.ior(integer,integer)", 2, object2);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IntNum bitwiseXor(Object ... args) {
        int i;
        IntNum result;
        IntNum intNum;
        int n = args.length;
        if (numbers.isZero(IntNum.make(n))) {
            intNum = LangObjType.coerceIntNum(Lit0);
            return intNum;
        }
        Object object3 = args[0];
        try {
            result = LangObjType.coerceIntNum(object3);
            i = 1;
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, null, -4, object3);
        }
        while (true) {
            if (i >= n) {
                intNum = result;
                return intNum;
            }
            Object object2 = args[i];
            try {
                result = BitOps.xor(result, LangObjType.coerceIntNum(object2));
                ++i;
            }
            catch (ClassCastException classCastException) {
                throw new WrongType(classCastException, "gnu.math.BitOps.xor(integer,integer)", 2, object2);
            }
        }
    }

    public static IntNum bitwiseIf(IntNum e1, IntNum e2, IntNum e3) {
        return numbers.bitwiseIor(numbers.bitwiseAnd(e1, e2), numbers.bitwiseAnd(numbers.bitwiseNot(e1), e3));
    }

    public static boolean logtest(IntNum i, IntNum j) {
        return BitOps.test(i, j);
    }

    public static int logcount(IntNum i) {
        return BitOps.bitCount(IntNum.compare(i, 0L) >= 0 ? i : BitOps.not(i));
    }

    public static int bitwiseBitCount(IntNum i) {
        return IntNum.compare(i, 0L) >= 0 ? BitOps.bitCount(i) : -1 - BitOps.bitCount(BitOps.not(i));
    }

    public static int bitwiseLength(IntNum i) {
        return i.intLength();
    }

    public static int bitwiseFirstBitSet(IntNum i) {
        return BitOps.lowestBitSet(i);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IntNum bitwiseRotateBitField(IntNum n, int start, int end, int count) {
        IntNum field1;
        IntNum intNum;
        int width = end - start;
        if (!numbers.isPositive(IntNum.make(width))) {
            intNum = n;
            return intNum;
        }
        Object count2 = ((Procedure)modulo).apply2(IntNum.make(count), IntNum.make(width));
        IntNum field0 = numbers.bitwiseBitField(n, start, end);
        Object object3 = count2;
        try {
            field1 = numbers.bitwiseArithmeticShiftLeft(field0, ((Number)object3).intValue());
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "bitwise-arithmetic-shift-left", 1, object3);
        }
        Object object2 = ((Procedure)AddOp.$Mn).apply2(IntNum.make(width), count2);
        try {}
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "bitwise-arithmetic-shift-right", 1, object2);
        }
        IntNum field2 = numbers.bitwiseArithmeticShiftRight(field0, ((Number)object2).intValue());
        IntNum field = numbers.bitwiseIor(field1, field2);
        intNum = numbers.bitwiseCopyBitField(n, start, end, field);
        return intNum;
    }

    public static IntNum bitwiseReverseBitField(IntNum n, int start, int end) {
        return BitOps.reverseBits(n, start, end);
    }

    public static FString number$To$String(Number number) {
        return numbers.number$To$String(number, 10);
    }

    public static FString number$To$String(Number arg, int radix) {
        return new FString((CharSequence)Arithmetic.toString(arg, radix));
    }

    public static Object string$To$Number(CharSequence charSequence) {
        return numbers.string$To$Number(charSequence, 10);
    }

    public static Object string$To$Number(CharSequence str, int radix) {
        Object result = LispReader.parseNumber(str, radix);
        return result instanceof Numeric ? result : Boolean.FALSE;
    }

    public static Complex quantity$To$Number(Quantity q) {
        q.unit();
        double factor = q.doubleValue();
        return factor == 1.0 ? q.number() : Complex.make(q.reValue(), q.imValue());
    }

    public static Unit quantity$To$Unit(Quantity q) {
        return q.unit();
    }

    /*
     * Loose catch block
     */
    public static Quantity makeQuantity(Object val, Object unit) {
        Unit u;
        Unit unit2;
        Object object2;
        if (unit instanceof Unit) {
            object2 = unit;
            unit2 = (Unit)object2;
        }
        Object object3 = unit;
        unit2 = u = Unit.lookup((String)(object3 == null ? null : object3.toString()));
        if (u == null) {
            throw (Throwable)new IllegalArgumentException(Format.format("unknown unit: ~s", unit).toString());
        }
        object2 = val;
        try {
            return Quantity.make((Complex)object2, u);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "gnu.math.Quantity.make(gnu.math.Complex,gnu.math.Unit)", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, null, -4, object2);
        }
    }

    public static Duration duration(Object duration) {
        Object object2 = duration;
        return Duration.parseDuration((String)(object2 == null ? null : object2.toString()));
    }

    public final void run(CallContext $ctx) {
        Consumer $result = $ctx.consumer;
        std_syntax.addProcedureProperties(quotient, lambda$Fn1, lambda$Fn2);
        std_syntax.addProcedureProperties(remainder, lambda$Fn3, lambda$Fn4);
        std_syntax.addProcedureProperties(modulo, lambda$Fn5, lambda$Fn6);
        std_syntax.addProcedureProperties(atan, lambda$Fn7, lambda$Fn8);
        std_syntax.addProcedureProperties(sqrt, lambda$Fn9, lambda$Fn10);
    }

    static {
        Lit69 = SimpleSymbol.valueOf("duration");
        Lit68 = SimpleSymbol.valueOf("make-quantity");
        Lit67 = SimpleSymbol.valueOf("quantity->unit");
        Lit66 = SimpleSymbol.valueOf("quantity->number");
        Lit65 = SimpleSymbol.valueOf("string->number");
        Lit64 = SimpleSymbol.valueOf("number->string");
        Lit63 = SimpleSymbol.valueOf("bitwise-reverse-bit-field");
        Lit62 = SimpleSymbol.valueOf("bitwise-rotate-bit-field");
        Lit61 = SimpleSymbol.valueOf("bitwise-first-bit-set");
        Lit60 = SimpleSymbol.valueOf("bitwise-length");
        Lit59 = SimpleSymbol.valueOf("bitwise-bit-count");
        Lit58 = SimpleSymbol.valueOf("logcount");
        Lit57 = SimpleSymbol.valueOf("logtest");
        Lit56 = SimpleSymbol.valueOf("bitwise-if");
        Lit55 = SimpleSymbol.valueOf("bitwise-xor");
        Lit54 = SimpleSymbol.valueOf("bitwise-ior");
        Lit53 = SimpleSymbol.valueOf("bitwise-and");
        Lit52 = SimpleSymbol.valueOf("bitwise-bit-field");
        Lit51 = SimpleSymbol.valueOf("bitwise-copy-bit-field");
        Lit50 = SimpleSymbol.valueOf("bitwise-copy-bit");
        Lit49 = SimpleSymbol.valueOf("bitwise-bit-set?");
        Lit48 = SimpleSymbol.valueOf("logop");
        Lit47 = SimpleSymbol.valueOf("bitwise-not");
        Lit46 = SimpleSymbol.valueOf("bitwise-arithmetic-shift-right");
        Lit45 = SimpleSymbol.valueOf("bitwise-arithmetic-shift-left");
        Lit44 = SimpleSymbol.valueOf("bitwise-arithmetic-shift");
        Lit43 = SimpleSymbol.valueOf("inexact->exact");
        Lit42 = SimpleSymbol.valueOf("exact->inexact");
        Lit41 = SimpleSymbol.valueOf("angle");
        Lit40 = SimpleSymbol.valueOf("magnitude");
        Lit39 = SimpleSymbol.valueOf("imag-part");
        Lit38 = SimpleSymbol.valueOf("real-part");
        Lit37 = SimpleSymbol.valueOf("make-polar");
        Lit36 = SimpleSymbol.valueOf("make-rectangular");
        Lit35 = SimpleSymbol.valueOf("acos");
        Lit34 = SimpleSymbol.valueOf("asin");
        Lit33 = SimpleSymbol.valueOf("tan");
        Lit32 = SimpleSymbol.valueOf("cos");
        Lit31 = SimpleSymbol.valueOf("sin");
        Lit30 = SimpleSymbol.valueOf("log");
        Lit29 = SimpleSymbol.valueOf("exp");
        Lit28 = SimpleSymbol.valueOf("rationalize");
        Lit27 = SimpleSymbol.valueOf("round");
        Lit26 = SimpleSymbol.valueOf("truncate");
        Lit25 = SimpleSymbol.valueOf("ceiling");
        Lit24 = SimpleSymbol.valueOf("floor");
        Lit23 = SimpleSymbol.valueOf("denominator");
        Lit22 = SimpleSymbol.valueOf("numerator");
        Lit21 = SimpleSymbol.valueOf("lcm");
        Lit20 = SimpleSymbol.valueOf("gcd");
        Lit19 = SimpleSymbol.valueOf("abs");
        Lit18 = SimpleSymbol.valueOf("min");
        Lit17 = SimpleSymbol.valueOf("max");
        Lit16 = SimpleSymbol.valueOf("even?");
        Lit15 = SimpleSymbol.valueOf("odd?");
        Lit14 = SimpleSymbol.valueOf("negative?");
        Lit13 = SimpleSymbol.valueOf("positive?");
        Lit12 = SimpleSymbol.valueOf("zero?");
        Lit11 = SimpleSymbol.valueOf("inexact?");
        Lit10 = SimpleSymbol.valueOf("exact?");
        Lit9 = SimpleSymbol.valueOf("integer?");
        Lit8 = SimpleSymbol.valueOf("rational?");
        Lit7 = SimpleSymbol.valueOf("real?");
        Lit6 = SimpleSymbol.valueOf("complex?");
        Lit5 = SimpleSymbol.valueOf("quantity?");
        Lit4 = SimpleSymbol.valueOf("number?");
        Lit3 = IntNum.make(-1);
        Lit2 = SimpleSymbol.valueOf("misc-error");
        Lit1 = IntNum.make(1);
        Lit0 = IntNum.make(0);
        $instance = new numbers();
        quotient = new GenericProc("quotient");
        remainder = new GenericProc("remainder");
        modulo = new GenericProc("modulo");
        atan = new GenericProc("atan");
        sqrt = new GenericProc("sqrt");
        numbers numbers2 = $instance;
        number$Qu = new ModuleMethod(numbers2, 1, Lit4, 4097);
        quantity$Qu = new ModuleMethod(numbers2, 2, Lit5, 4097);
        complex$Qu = new ModuleMethod(numbers2, 3, Lit6, 4097);
        real$Qu = new ModuleMethod(numbers2, 4, Lit7, 4097);
        rational$Qu = new ModuleMethod(numbers2, 5, Lit8, 4097);
        integer$Qu = new ModuleMethod(numbers2, 6, Lit9, 4097);
        exact$Qu = new ModuleMethod(numbers2, 7, Lit10, 4097);
        inexact$Qu = new ModuleMethod(numbers2, 8, Lit11, 4097);
        zero$Qu = new ModuleMethod(numbers2, 9, Lit12, 4097);
        positive$Qu = new ModuleMethod(numbers2, 10, Lit13, 4097);
        negative$Qu = new ModuleMethod(numbers2, 11, Lit14, 4097);
        odd$Qu = new ModuleMethod(numbers2, 12, Lit15, 4097);
        even$Qu = new ModuleMethod(numbers2, 13, Lit16, 4097);
        max = new ModuleMethod(numbers2, 14, Lit17, -4096);
        min = new ModuleMethod(numbers2, 15, Lit18, -4096);
        abs = new ModuleMethod(numbers2, 16, Lit19, 4097);
        ModuleMethod moduleMethod = new ModuleMethod(numbers2, 17, null, 8194);
        moduleMethod.setProperty("source-location", "../.././kawa-1.9.90/kawa/lib/numbers.scm:66");
        lambda$Fn1 = moduleMethod;
        ModuleMethod moduleMethod2 = new ModuleMethod(numbers2, 18, null, 8194);
        moduleMethod2.setProperty("source-location", "../.././kawa-1.9.90/kawa/lib/numbers.scm:68");
        lambda$Fn2 = moduleMethod2;
        ModuleMethod moduleMethod3 = new ModuleMethod(numbers2, 19, null, 8194);
        moduleMethod3.setProperty("source-location", "../.././kawa-1.9.90/kawa/lib/numbers.scm:73");
        lambda$Fn3 = moduleMethod3;
        ModuleMethod moduleMethod4 = new ModuleMethod(numbers2, 20, null, 8194);
        moduleMethod4.setProperty("source-location", "../.././kawa-1.9.90/kawa/lib/numbers.scm:75");
        lambda$Fn4 = moduleMethod4;
        ModuleMethod moduleMethod5 = new ModuleMethod(numbers2, 21, null, 8194);
        moduleMethod5.setProperty("source-location", "../.././kawa-1.9.90/kawa/lib/numbers.scm:83");
        lambda$Fn5 = moduleMethod5;
        ModuleMethod moduleMethod6 = new ModuleMethod(numbers2, 22, null, 8194);
        moduleMethod6.setProperty("source-location", "../.././kawa-1.9.90/kawa/lib/numbers.scm:85");
        lambda$Fn6 = moduleMethod6;
        gcd = new ModuleMethod(numbers2, 23, Lit20, -4096);
        lcm = new ModuleMethod(numbers2, 24, Lit21, -4096);
        numerator = new ModuleMethod(numbers2, 25, Lit22, 4097);
        denominator = new ModuleMethod(numbers2, 26, Lit23, 4097);
        floor = new ModuleMethod(numbers2, 27, Lit24, 4097);
        ceiling = new ModuleMethod(numbers2, 28, Lit25, 4097);
        truncate = new ModuleMethod(numbers2, 29, Lit26, 4097);
        round = new ModuleMethod(numbers2, 30, Lit27, 4097);
        rationalize = new ModuleMethod(numbers2, 31, Lit28, 8194);
        exp = new ModuleMethod(numbers2, 32, Lit29, 4097);
        log = new ModuleMethod(numbers2, 33, Lit30, 4097);
        sin = new ModuleMethod(numbers2, 34, Lit31, 4097);
        cos = new ModuleMethod(numbers2, 35, Lit32, 4097);
        tan = new ModuleMethod(numbers2, 36, Lit33, 4097);
        asin = new ModuleMethod(numbers2, 37, Lit34, 4097);
        acos = new ModuleMethod(numbers2, 38, Lit35, 4097);
        ModuleMethod moduleMethod7 = new ModuleMethod(numbers2, 39, null, 8194);
        moduleMethod7.setProperty("source-location", "../.././kawa-1.9.90/kawa/lib/numbers.scm:155");
        lambda$Fn7 = moduleMethod7;
        ModuleMethod moduleMethod8 = new ModuleMethod(numbers2, 40, null, 4097);
        moduleMethod8.setProperty("source-location", "../.././kawa-1.9.90/kawa/lib/numbers.scm:157");
        lambda$Fn8 = moduleMethod8;
        ModuleMethod moduleMethod9 = new ModuleMethod(numbers2, 41, null, 4097);
        moduleMethod9.setProperty("source-location", "../.././kawa-1.9.90/kawa/lib/numbers.scm:161");
        lambda$Fn9 = moduleMethod9;
        ModuleMethod moduleMethod10 = new ModuleMethod(numbers2, 42, null, 4097);
        moduleMethod10.setProperty("source-location", "../.././kawa-1.9.90/kawa/lib/numbers.scm:165");
        lambda$Fn10 = moduleMethod10;
        make$Mnrectangular = new ModuleMethod(numbers2, 43, Lit36, 8194);
        make$Mnpolar = new ModuleMethod(numbers2, 44, Lit37, 8194);
        real$Mnpart = new ModuleMethod(numbers2, 45, Lit38, 4097);
        imag$Mnpart = new ModuleMethod(numbers2, 46, Lit39, 4097);
        magnitude = new ModuleMethod(numbers2, 47, Lit40, 4097);
        angle = new ModuleMethod(numbers2, 48, Lit41, 4097);
        exact$Mn$Grinexact = new ModuleMethod(numbers2, 49, Lit42, 4097);
        inexact$Mn$Grexact = new ModuleMethod(numbers2, 50, Lit43, 4097);
        bitwise$Mnarithmetic$Mnshift = new ModuleMethod(numbers2, 51, Lit44, 8194);
        bitwise$Mnarithmetic$Mnshift$Mnleft = new ModuleMethod(numbers2, 52, Lit45, 8194);
        bitwise$Mnarithmetic$Mnshift$Mnright = new ModuleMethod(numbers2, 53, Lit46, 8194);
        bitwise$Mnnot = new ModuleMethod(numbers2, 54, Lit47, 4097);
        logop = new ModuleMethod(numbers2, 55, Lit48, 12291);
        bitwise$Mnbit$Mnset$Qu = new ModuleMethod(numbers2, 56, Lit49, 8194);
        bitwise$Mncopy$Mnbit = new ModuleMethod(numbers2, 57, Lit50, 12291);
        bitwise$Mncopy$Mnbit$Mnfield = new ModuleMethod(numbers2, 58, Lit51, 16388);
        bitwise$Mnbit$Mnfield = new ModuleMethod(numbers2, 59, Lit52, 12291);
        bitwise$Mnand = new ModuleMethod(numbers2, 60, Lit53, -4096);
        bitwise$Mnior = new ModuleMethod(numbers2, 61, Lit54, -4096);
        bitwise$Mnxor = new ModuleMethod(numbers2, 62, Lit55, -4096);
        bitwise$Mnif = new ModuleMethod(numbers2, 63, Lit56, 12291);
        logtest = new ModuleMethod(numbers2, 64, Lit57, 8194);
        logcount = new ModuleMethod(numbers2, 65, Lit58, 4097);
        bitwise$Mnbit$Mncount = new ModuleMethod(numbers2, 66, Lit59, 4097);
        bitwise$Mnlength = new ModuleMethod(numbers2, 67, Lit60, 4097);
        bitwise$Mnfirst$Mnbit$Mnset = new ModuleMethod(numbers2, 68, Lit61, 4097);
        bitwise$Mnrotate$Mnbit$Mnfield = new ModuleMethod(numbers2, 69, Lit62, 16388);
        bitwise$Mnreverse$Mnbit$Mnfield = new ModuleMethod(numbers2, 70, Lit63, 12291);
        number$Mn$Grstring = new ModuleMethod(numbers2, 71, Lit64, 8193);
        string$Mn$Grnumber = new ModuleMethod(numbers2, 73, Lit65, 8193);
        quantity$Mn$Grnumber = new ModuleMethod(numbers2, 75, Lit66, 4097);
        quantity$Mn$Grunit = new ModuleMethod(numbers2, 76, Lit67, 4097);
        make$Mnquantity = new ModuleMethod(numbers2, 77, Lit68, 8194);
        duration = new ModuleMethod(numbers2, 78, Lit69, 4097);
        $instance.run();
    }

    public int match1(ModuleMethod moduleMethod, Object object2, CallContext callContext) {
        switch (moduleMethod.selector) {
            case 78: {
                callContext.value1 = object2;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 76: {
                Object object3 = object2;
                if (!(object3 instanceof Quantity)) {
                    return -786431;
                }
                callContext.value1 = object3;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 75: {
                Object object4 = object2;
                if (!(object4 instanceof Quantity)) {
                    return -786431;
                }
                callContext.value1 = object4;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 73: {
                Object object5 = object2;
                if (!(object5 instanceof CharSequence)) {
                    return -786431;
                }
                callContext.value1 = object5;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 71: {
                Object object6 = object2;
                if (!(object6 instanceof Number)) {
                    return -786431;
                }
                callContext.value1 = object6;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 68: {
                Object object7 = object2;
                if (IntNum.asIntNumOrNull(object7) == null) {
                    return -786431;
                }
                callContext.value1 = object7;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 67: {
                Object object8 = object2;
                if (IntNum.asIntNumOrNull(object8) == null) {
                    return -786431;
                }
                callContext.value1 = object8;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 66: {
                Object object9 = object2;
                if (IntNum.asIntNumOrNull(object9) == null) {
                    return -786431;
                }
                callContext.value1 = object9;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 65: {
                Object object10 = object2;
                if (IntNum.asIntNumOrNull(object10) == null) {
                    return -786431;
                }
                callContext.value1 = object10;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 54: {
                Object object11 = object2;
                if (IntNum.asIntNumOrNull(object11) == null) {
                    return -786431;
                }
                callContext.value1 = object11;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 50: {
                Object object12 = object2;
                if (!(object12 instanceof Numeric)) {
                    return -786431;
                }
                callContext.value1 = object12;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 49: {
                Object object13 = object2;
                if (!(object13 instanceof Numeric)) {
                    return -786431;
                }
                callContext.value1 = object13;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 48: {
                Object object14 = object2;
                if (!(object14 instanceof Complex)) {
                    return -786431;
                }
                callContext.value1 = object14;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 47: {
                Object object15 = object2;
                if (!(object15 instanceof Numeric)) {
                    return -786431;
                }
                callContext.value1 = object15;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 46: {
                Object object16 = object2;
                if (!(object16 instanceof Complex)) {
                    return -786431;
                }
                callContext.value1 = object16;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 45: {
                Object object17 = object2;
                if (!(object17 instanceof Complex)) {
                    return -786431;
                }
                callContext.value1 = object17;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 42: {
                Object object18 = object2;
                if (!(object18 instanceof Number)) {
                    return -786431;
                }
                callContext.value1 = object18;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 41: {
                Object object19 = object2;
                if (!(object19 instanceof Quantity)) {
                    return -786431;
                }
                callContext.value1 = object19;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 40: {
                Object object20 = object2;
                if (!(object20 instanceof Number)) {
                    return -786431;
                }
                callContext.value1 = object20;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 38: {
                Object object21 = object2;
                if (!(object21 instanceof Number)) {
                    return -786431;
                }
                callContext.value1 = object21;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 37: {
                Object object22 = object2;
                if (!(object22 instanceof Number)) {
                    return -786431;
                }
                callContext.value1 = object22;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 36: {
                Object object23 = object2;
                if (!(object23 instanceof Number)) {
                    return -786431;
                }
                callContext.value1 = object23;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 35: {
                Object object24 = object2;
                if (!(object24 instanceof Number)) {
                    return -786431;
                }
                callContext.value1 = object24;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 34: {
                Object object25 = object2;
                if (!(object25 instanceof Number)) {
                    return -786431;
                }
                callContext.value1 = object25;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 33: {
                Object object26 = object2;
                if (!(object26 instanceof Complex)) {
                    return -786431;
                }
                callContext.value1 = object26;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 32: {
                Object object27 = object2;
                if (!(object27 instanceof Complex)) {
                    return -786431;
                }
                callContext.value1 = object27;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 30: {
                Object object28 = object2;
                if (!(object28 instanceof RealNum)) {
                    return -786431;
                }
                callContext.value1 = object28;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 29: {
                Object object29 = object2;
                if (!(object29 instanceof RealNum)) {
                    return -786431;
                }
                callContext.value1 = object29;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 28: {
                Object object30 = object2;
                if (!(object30 instanceof RealNum)) {
                    return -786431;
                }
                callContext.value1 = object30;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 27: {
                Object object31 = object2;
                if (!(object31 instanceof RealNum)) {
                    return -786431;
                }
                callContext.value1 = object31;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 26: {
                Object object32 = object2;
                if (!(object32 instanceof RatNum)) {
                    return -786431;
                }
                callContext.value1 = object32;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 25: {
                Object object33 = object2;
                if (!(object33 instanceof RatNum)) {
                    return -786431;
                }
                callContext.value1 = object33;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 16: {
                Object object34 = object2;
                if (!(object34 instanceof Numeric)) {
                    return -786431;
                }
                callContext.value1 = object34;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 13: {
                Object object35 = object2;
                if (IntNum.asIntNumOrNull(object35) == null) {
                    return -786431;
                }
                callContext.value1 = object35;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 12: {
                Object object36 = object2;
                if (IntNum.asIntNumOrNull(object36) == null) {
                    return -786431;
                }
                callContext.value1 = object36;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 11: {
                Object object37 = object2;
                if (!(object37 instanceof RealNum)) {
                    return -786431;
                }
                callContext.value1 = object37;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 10: {
                Object object38 = object2;
                if (!(object38 instanceof RealNum)) {
                    return -786431;
                }
                callContext.value1 = object38;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 9: {
                Object object39 = object2;
                if (!(object39 instanceof Numeric)) {
                    return -786431;
                }
                callContext.value1 = object39;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 8: {
                callContext.value1 = object2;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 7: {
                callContext.value1 = object2;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 6: {
                callContext.value1 = object2;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 5: {
                callContext.value1 = object2;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 4: {
                callContext.value1 = object2;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 3: {
                callContext.value1 = object2;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 2: {
                callContext.value1 = object2;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 1: {
                callContext.value1 = object2;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
        }
        return super.match1(moduleMethod, object2, callContext);
    }

    public int match2(ModuleMethod moduleMethod, Object object2, Object object3, CallContext callContext) {
        switch (moduleMethod.selector) {
            case 77: {
                callContext.value1 = object2;
                callContext.value2 = object3;
                callContext.proc = moduleMethod;
                callContext.pc = 2;
                return 0;
            }
            case 73: {
                Object object4 = object2;
                if (!(object4 instanceof CharSequence)) {
                    return -786431;
                }
                callContext.value1 = object4;
                Object object5 = object3;
                if (!(object5 instanceof Number)) {
                    return -786430;
                }
                callContext.value2 = object5;
                callContext.proc = moduleMethod;
                callContext.pc = 2;
                return 0;
            }
            case 71: {
                Object object6 = object2;
                if (!(object6 instanceof Number)) {
                    return -786431;
                }
                callContext.value1 = object6;
                Object object7 = object3;
                if (!(object7 instanceof Number)) {
                    return -786430;
                }
                callContext.value2 = object7;
                callContext.proc = moduleMethod;
                callContext.pc = 2;
                return 0;
            }
            case 64: {
                Object object8 = object2;
                if (IntNum.asIntNumOrNull(object8) == null) {
                    return -786431;
                }
                callContext.value1 = object8;
                Object object9 = object3;
                if (IntNum.asIntNumOrNull(object9) == null) {
                    return -786430;
                }
                callContext.value2 = object9;
                callContext.proc = moduleMethod;
                callContext.pc = 2;
                return 0;
            }
            case 56: {
                Object object10 = object2;
                if (IntNum.asIntNumOrNull(object10) == null) {
                    return -786431;
                }
                callContext.value1 = object10;
                Object object11 = object3;
                if (!(object11 instanceof Number)) {
                    return -786430;
                }
                callContext.value2 = object11;
                callContext.proc = moduleMethod;
                callContext.pc = 2;
                return 0;
            }
            case 53: {
                Object object12 = object2;
                if (IntNum.asIntNumOrNull(object12) == null) {
                    return -786431;
                }
                callContext.value1 = object12;
                Object object13 = object3;
                if (!(object13 instanceof Number)) {
                    return -786430;
                }
                callContext.value2 = object13;
                callContext.proc = moduleMethod;
                callContext.pc = 2;
                return 0;
            }
            case 52: {
                Object object14 = object2;
                if (IntNum.asIntNumOrNull(object14) == null) {
                    return -786431;
                }
                callContext.value1 = object14;
                Object object15 = object3;
                if (!(object15 instanceof Number)) {
                    return -786430;
                }
                callContext.value2 = object15;
                callContext.proc = moduleMethod;
                callContext.pc = 2;
                return 0;
            }
            case 51: {
                Object object16 = object2;
                if (IntNum.asIntNumOrNull(object16) == null) {
                    return -786431;
                }
                callContext.value1 = object16;
                Object object17 = object3;
                if (!(object17 instanceof Number)) {
                    return -786430;
                }
                callContext.value2 = object17;
                callContext.proc = moduleMethod;
                callContext.pc = 2;
                return 0;
            }
            case 44: {
                Object object18 = object2;
                if (!(object18 instanceof Number)) {
                    return -786431;
                }
                callContext.value1 = object18;
                Object object19 = object3;
                if (!(object19 instanceof Number)) {
                    return -786430;
                }
                callContext.value2 = object19;
                callContext.proc = moduleMethod;
                callContext.pc = 2;
                return 0;
            }
            case 43: {
                Object object20 = object2;
                if (!(object20 instanceof RealNum)) {
                    return -786431;
                }
                callContext.value1 = object20;
                Object object21 = object3;
                if (!(object21 instanceof RealNum)) {
                    return -786430;
                }
                callContext.value2 = object21;
                callContext.proc = moduleMethod;
                callContext.pc = 2;
                return 0;
            }
            case 39: {
                Object object22 = object2;
                if (!(object22 instanceof Number)) {
                    return -786431;
                }
                callContext.value1 = object22;
                Object object23 = object3;
                if (!(object23 instanceof Number)) {
                    return -786430;
                }
                callContext.value2 = object23;
                callContext.proc = moduleMethod;
                callContext.pc = 2;
                return 0;
            }
            case 31: {
                Object object24 = object2;
                if (!(object24 instanceof RealNum)) {
                    return -786431;
                }
                callContext.value1 = object24;
                Object object25 = object3;
                if (!(object25 instanceof RealNum)) {
                    return -786430;
                }
                callContext.value2 = object25;
                callContext.proc = moduleMethod;
                callContext.pc = 2;
                return 0;
            }
            case 22: {
                Object object26 = object2;
                if (!(object26 instanceof RealNum)) {
                    return -786431;
                }
                callContext.value1 = object26;
                Object object27 = object3;
                if (!(object27 instanceof RealNum)) {
                    return -786430;
                }
                callContext.value2 = object27;
                callContext.proc = moduleMethod;
                callContext.pc = 2;
                return 0;
            }
            case 21: {
                Object object28 = object2;
                if (IntNum.asIntNumOrNull(object28) == null) {
                    return -786431;
                }
                callContext.value1 = object28;
                Object object29 = object3;
                if (IntNum.asIntNumOrNull(object29) == null) {
                    return -786430;
                }
                callContext.value2 = object29;
                callContext.proc = moduleMethod;
                callContext.pc = 2;
                return 0;
            }
            case 20: {
                Object object30 = object2;
                if (!(object30 instanceof RealNum)) {
                    return -786431;
                }
                callContext.value1 = object30;
                Object object31 = object3;
                if (!(object31 instanceof RealNum)) {
                    return -786430;
                }
                callContext.value2 = object31;
                callContext.proc = moduleMethod;
                callContext.pc = 2;
                return 0;
            }
            case 19: {
                Object object32 = object2;
                if (IntNum.asIntNumOrNull(object32) == null) {
                    return -786431;
                }
                callContext.value1 = object32;
                Object object33 = object3;
                if (IntNum.asIntNumOrNull(object33) == null) {
                    return -786430;
                }
                callContext.value2 = object33;
                callContext.proc = moduleMethod;
                callContext.pc = 2;
                return 0;
            }
            case 18: {
                Object object34 = object2;
                if (!(object34 instanceof RealNum)) {
                    return -786431;
                }
                callContext.value1 = object34;
                Object object35 = object3;
                if (!(object35 instanceof RealNum)) {
                    return -786430;
                }
                callContext.value2 = object35;
                callContext.proc = moduleMethod;
                callContext.pc = 2;
                return 0;
            }
            case 17: {
                Object object36 = object2;
                if (IntNum.asIntNumOrNull(object36) == null) {
                    return -786431;
                }
                callContext.value1 = object36;
                Object object37 = object3;
                if (IntNum.asIntNumOrNull(object37) == null) {
                    return -786430;
                }
                callContext.value2 = object37;
                callContext.proc = moduleMethod;
                callContext.pc = 2;
                return 0;
            }
        }
        return super.match2(moduleMethod, object2, object3, callContext);
    }

    public int match3(ModuleMethod moduleMethod, Object object2, Object object3, Object object4, CallContext callContext) {
        switch (moduleMethod.selector) {
            case 70: {
                Object object5 = object2;
                if (IntNum.asIntNumOrNull(object5) == null) {
                    return -786431;
                }
                callContext.value1 = object5;
                Object object6 = object3;
                if (!(object6 instanceof Number)) {
                    return -786430;
                }
                callContext.value2 = object6;
                Object object7 = object4;
                if (!(object7 instanceof Number)) {
                    return -786429;
                }
                callContext.value3 = object7;
                callContext.proc = moduleMethod;
                callContext.pc = 3;
                return 0;
            }
            case 63: {
                Object object8 = object2;
                if (IntNum.asIntNumOrNull(object8) == null) {
                    return -786431;
                }
                callContext.value1 = object8;
                Object object9 = object3;
                if (IntNum.asIntNumOrNull(object9) == null) {
                    return -786430;
                }
                callContext.value2 = object9;
                Object object10 = object4;
                if (IntNum.asIntNumOrNull(object10) == null) {
                    return -786429;
                }
                callContext.value3 = object10;
                callContext.proc = moduleMethod;
                callContext.pc = 3;
                return 0;
            }
            case 59: {
                Object object11 = object2;
                if (IntNum.asIntNumOrNull(object11) == null) {
                    return -786431;
                }
                callContext.value1 = object11;
                Object object12 = object3;
                if (!(object12 instanceof Number)) {
                    return -786430;
                }
                callContext.value2 = object12;
                Object object13 = object4;
                if (!(object13 instanceof Number)) {
                    return -786429;
                }
                callContext.value3 = object13;
                callContext.proc = moduleMethod;
                callContext.pc = 3;
                return 0;
            }
            case 57: {
                Object object14 = object2;
                if (IntNum.asIntNumOrNull(object14) == null) {
                    return -786431;
                }
                callContext.value1 = object14;
                Object object15 = object3;
                if (!(object15 instanceof Number)) {
                    return -786430;
                }
                callContext.value2 = object15;
                Object object16 = object4;
                if (!(object16 instanceof Number)) {
                    return -786429;
                }
                callContext.value3 = object16;
                callContext.proc = moduleMethod;
                callContext.pc = 3;
                return 0;
            }
            case 55: {
                Object object17 = object2;
                if (!(object17 instanceof Number)) {
                    return -786431;
                }
                callContext.value1 = object17;
                Object object18 = object3;
                if (IntNum.asIntNumOrNull(object18) == null) {
                    return -786430;
                }
                callContext.value2 = object18;
                Object object19 = object4;
                if (IntNum.asIntNumOrNull(object19) == null) {
                    return -786429;
                }
                callContext.value3 = object19;
                callContext.proc = moduleMethod;
                callContext.pc = 3;
                return 0;
            }
        }
        return super.match3(moduleMethod, object2, object3, object4, callContext);
    }

    public int match4(ModuleMethod moduleMethod, Object object2, Object object3, Object object4, Object object5, CallContext callContext) {
        switch (moduleMethod.selector) {
            case 69: {
                Object object6 = object2;
                if (IntNum.asIntNumOrNull(object6) == null) {
                    return -786431;
                }
                callContext.value1 = object6;
                Object object7 = object3;
                if (!(object7 instanceof Number)) {
                    return -786430;
                }
                callContext.value2 = object7;
                Object object8 = object4;
                if (!(object8 instanceof Number)) {
                    return -786429;
                }
                callContext.value3 = object8;
                Object object9 = object5;
                if (!(object9 instanceof Number)) {
                    return -786428;
                }
                callContext.value4 = object9;
                callContext.proc = moduleMethod;
                callContext.pc = 4;
                return 0;
            }
            case 58: {
                Object object10 = object2;
                if (IntNum.asIntNumOrNull(object10) == null) {
                    return -786431;
                }
                callContext.value1 = object10;
                Object object11 = object3;
                if (!(object11 instanceof Number)) {
                    return -786430;
                }
                callContext.value2 = object11;
                Object object12 = object4;
                if (!(object12 instanceof Number)) {
                    return -786429;
                }
                callContext.value3 = object12;
                Object object13 = object5;
                if (IntNum.asIntNumOrNull(object13) == null) {
                    return -786428;
                }
                callContext.value4 = object13;
                callContext.proc = moduleMethod;
                callContext.pc = 4;
                return 0;
            }
        }
        return super.match4(moduleMethod, object2, object3, object4, object5, callContext);
    }

    public int matchN(ModuleMethod moduleMethod, Object[] objectArray, CallContext callContext) {
        switch (moduleMethod.selector) {
            case 62: {
                callContext.values = objectArray;
                callContext.proc = moduleMethod;
                callContext.pc = 5;
                return 0;
            }
            case 61: {
                callContext.values = objectArray;
                callContext.proc = moduleMethod;
                callContext.pc = 5;
                return 0;
            }
            case 60: {
                callContext.values = objectArray;
                callContext.proc = moduleMethod;
                callContext.pc = 5;
                return 0;
            }
            case 24: {
                callContext.values = objectArray;
                callContext.proc = moduleMethod;
                callContext.pc = 5;
                return 0;
            }
            case 23: {
                callContext.values = objectArray;
                callContext.proc = moduleMethod;
                callContext.pc = 5;
                return 0;
            }
            case 15: {
                callContext.values = objectArray;
                callContext.proc = moduleMethod;
                callContext.pc = 5;
                return 0;
            }
            case 14: {
                callContext.values = objectArray;
                callContext.proc = moduleMethod;
                callContext.pc = 5;
                return 0;
            }
        }
        return super.matchN(moduleMethod, objectArray, callContext);
    }

    /*
     * Loose catch block
     */
    public Object apply1(ModuleMethod moduleMethod, Object object2) {
        switch (moduleMethod.selector) {
            case 1: {
                return numbers.isNumber(object2) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 2: {
                return numbers.isQuantity(object2) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 3: {
                return numbers.isComplex(object2) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 4: {
                return numbers.isReal(object2) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 5: {
                return numbers.isRational(object2) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 6: {
                return numbers.isInteger(object2) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 7: {
                return numbers.isExact(object2) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 8: {
                return numbers.isInexact(object2) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 9: {
                return numbers.isZero((Numeric)object2) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 10: {
                return numbers.isPositive((RealNum)object2) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 11: {
                return numbers.isNegative((RealNum)object2) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 12: {
                return numbers.isOdd(LangObjType.coerceIntNum(object2)) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 13: {
                return numbers.isEven(LangObjType.coerceIntNum(object2)) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 16: {
                return numbers.abs((Numeric)object2);
            }
            case 25: {
                return numbers.numerator((RatNum)object2);
            }
            case 26: {
                return numbers.denominator((RatNum)object2);
            }
            case 27: {
                return numbers.floor((RealNum)object2);
            }
            case 28: {
                return numbers.ceiling((RealNum)object2);
            }
            case 29: {
                return numbers.truncate((RealNum)object2);
            }
            case 30: {
                return numbers.round((RealNum)object2);
            }
            case 32: {
                return numbers.exp((Complex)object2);
            }
            case 33: {
                return numbers.log((Complex)object2);
            }
            case 34: {
                return DFloNum.make(numbers.sin(((Number)object2).doubleValue()));
            }
            case 35: {
                return DFloNum.make(numbers.cos(((Number)object2).doubleValue()));
            }
            case 36: {
                return DFloNum.make(numbers.tan(((Number)object2).doubleValue()));
            }
            case 37: {
                return DFloNum.make(numbers.asin(((Number)object2).doubleValue()));
            }
            case 38: {
                return DFloNum.make(numbers.acos(((Number)object2).doubleValue()));
            }
            case 40: {
                return DFloNum.make(numbers.lambda8(((Number)object2).doubleValue()));
            }
            case 41: {
                return numbers.lambda9((Quantity)object2);
            }
            case 42: {
                return DFloNum.make(numbers.lambda10(((Number)object2).doubleValue()));
            }
            case 45: {
                return numbers.realPart((Complex)object2);
            }
            case 46: {
                return numbers.imagPart((Complex)object2);
            }
            case 47: {
                return numbers.magnitude((Numeric)object2);
            }
            case 48: {
                return numbers.angle((Complex)object2);
            }
            case 49: {
                return numbers.exact$To$Inexact((Numeric)object2);
            }
            case 50: {
                return numbers.inexact$To$Exact((Numeric)object2);
            }
            case 54: {
                return numbers.bitwiseNot(LangObjType.coerceIntNum(object2));
            }
            case 65: {
                return IntNum.make(numbers.logcount(LangObjType.coerceIntNum(object2)));
            }
            case 66: {
                return IntNum.make(numbers.bitwiseBitCount(LangObjType.coerceIntNum(object2)));
            }
            case 67: {
                return IntNum.make(numbers.bitwiseLength(LangObjType.coerceIntNum(object2)));
            }
            case 68: {
                return IntNum.make(numbers.bitwiseFirstBitSet(LangObjType.coerceIntNum(object2)));
            }
            case 71: {
                return numbers.number$To$String((Number)object2);
            }
            case 73: {
                return numbers.string$To$Number((CharSequence)object2);
            }
            case 75: {
                return numbers.quantity$To$Number((Quantity)object2);
            }
            case 76: {
                return numbers.quantity$To$Unit((Quantity)object2);
            }
            case 78: {
                return numbers.duration(object2);
            }
        }
        return super.apply1(moduleMethod, object2);
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "zero?", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "positive?", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "negative?", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "odd?", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "even?", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "abs", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "numerator", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "denominator", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "floor", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "ceiling", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "truncate", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "round", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "exp", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "log", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "sin", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "cos", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "tan", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "asin", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "acos", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "lambda", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "lambda", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "lambda", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "real-part", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "imag-part", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "magnitude", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "angle", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "exact->inexact", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "inexact->exact", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "bitwise-not", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "logcount", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "bitwise-bit-count", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "bitwise-length", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "bitwise-first-bit-set", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "number->string", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "string->number", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "quantity->number", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "quantity->unit", 1, object2);
        }
    }

    /*
     * Loose catch block
     */
    public Object apply2(ModuleMethod moduleMethod, Object object2, Object object3) {
        switch (moduleMethod.selector) {
            case 17: {
                IntNum intNum = LangObjType.coerceIntNum(object2);
                return numbers.lambda1(intNum, LangObjType.coerceIntNum(object3));
            }
            case 18: {
                RealNum realNum = (RealNum)object2;
                return numbers.lambda2(realNum, (RealNum)object3);
            }
            case 19: {
                IntNum intNum = LangObjType.coerceIntNum(object2);
                return numbers.lambda3(intNum, LangObjType.coerceIntNum(object3));
            }
            case 20: {
                RealNum realNum = (RealNum)object2;
                return numbers.lambda4(realNum, (RealNum)object3);
            }
            case 21: {
                IntNum intNum = LangObjType.coerceIntNum(object2);
                return numbers.lambda5(intNum, LangObjType.coerceIntNum(object3));
            }
            case 22: {
                RealNum realNum = (RealNum)object2;
                return numbers.lambda6(realNum, (RealNum)object3);
            }
            case 31: {
                RealNum realNum = (RealNum)object2;
                return numbers.rationalize(realNum, (RealNum)object3);
            }
            case 39: {
                double d = ((Number)object2).doubleValue();
                return DFloNum.make(numbers.lambda7(d, ((Number)object3).doubleValue()));
            }
            case 43: {
                RealNum realNum = (RealNum)object2;
                return numbers.makeRectangular(realNum, (RealNum)object3);
            }
            case 44: {
                double d = ((Number)object2).doubleValue();
                return numbers.makePolar(d, ((Number)object3).doubleValue());
            }
            case 51: {
                IntNum intNum = LangObjType.coerceIntNum(object2);
                return numbers.bitwiseArithmeticShift(intNum, ((Number)object3).intValue());
            }
            case 52: {
                IntNum intNum = LangObjType.coerceIntNum(object2);
                return numbers.bitwiseArithmeticShiftLeft(intNum, ((Number)object3).intValue());
            }
            case 53: {
                IntNum intNum = LangObjType.coerceIntNum(object2);
                return numbers.bitwiseArithmeticShiftRight(intNum, ((Number)object3).intValue());
            }
            case 56: {
                IntNum intNum = LangObjType.coerceIntNum(object2);
                return numbers.isBitwiseBitSet(intNum, ((Number)object3).intValue()) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 64: {
                IntNum intNum = LangObjType.coerceIntNum(object2);
                return numbers.logtest(intNum, LangObjType.coerceIntNum(object3)) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 71: {
                Number number = (Number)object2;
                return numbers.number$To$String(number, ((Number)object3).intValue());
            }
            case 73: {
                CharSequence charSequence = (CharSequence)object2;
                return numbers.string$To$Number(charSequence, ((Number)object3).intValue());
            }
            case 77: {
                return numbers.makeQuantity(object2, object3);
            }
        }
        return super.apply2(moduleMethod, object2, object3);
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "lambda", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "lambda", 2, object3);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "lambda", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "lambda", 2, object3);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "lambda", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "lambda", 2, object3);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "lambda", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "lambda", 2, object3);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "lambda", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "lambda", 2, object3);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "lambda", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "lambda", 2, object3);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "rationalize", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "rationalize", 2, object3);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "lambda", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "lambda", 2, object3);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "make-rectangular", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "make-rectangular", 2, object3);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "make-polar", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "make-polar", 2, object3);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "bitwise-arithmetic-shift", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "bitwise-arithmetic-shift", 2, object3);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "bitwise-arithmetic-shift-left", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "bitwise-arithmetic-shift-left", 2, object3);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "bitwise-arithmetic-shift-right", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "bitwise-arithmetic-shift-right", 2, object3);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "bitwise-bit-set?", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "bitwise-bit-set?", 2, object3);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "logtest", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "logtest", 2, object3);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "number->string", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "number->string", 2, object3);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "string->number", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "string->number", 2, object3);
        }
    }

    /*
     * Loose catch block
     */
    public Object apply3(ModuleMethod moduleMethod, Object object2, Object object3, Object object4) {
        switch (moduleMethod.selector) {
            case 55: {
                int n = ((Number)object2).intValue();
                IntNum intNum = LangObjType.coerceIntNum(object3);
                return numbers.logop(n, intNum, LangObjType.coerceIntNum(object4));
            }
            case 57: {
                IntNum intNum = LangObjType.coerceIntNum(object2);
                int n = ((Number)object3).intValue();
                return numbers.bitwiseCopyBit(intNum, n, ((Number)object4).intValue());
            }
            case 59: {
                IntNum intNum = LangObjType.coerceIntNum(object2);
                int n = ((Number)object3).intValue();
                return numbers.bitwiseBitField(intNum, n, ((Number)object4).intValue());
            }
            case 63: {
                IntNum intNum = LangObjType.coerceIntNum(object2);
                IntNum intNum2 = LangObjType.coerceIntNum(object3);
                return numbers.bitwiseIf(intNum, intNum2, LangObjType.coerceIntNum(object4));
            }
            case 70: {
                IntNum intNum = LangObjType.coerceIntNum(object2);
                int n = ((Number)object3).intValue();
                return numbers.bitwiseReverseBitField(intNum, n, ((Number)object4).intValue());
            }
        }
        return super.apply3(moduleMethod, object2, object3, object4);
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "logop", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "logop", 2, object3);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "logop", 3, object4);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "bitwise-copy-bit", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "bitwise-copy-bit", 2, object3);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "bitwise-copy-bit", 3, object4);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "bitwise-bit-field", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "bitwise-bit-field", 2, object3);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "bitwise-bit-field", 3, object4);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "bitwise-if", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "bitwise-if", 2, object3);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "bitwise-if", 3, object4);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "bitwise-reverse-bit-field", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "bitwise-reverse-bit-field", 2, object3);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "bitwise-reverse-bit-field", 3, object4);
        }
    }

    /*
     * Loose catch block
     */
    public Object apply4(ModuleMethod moduleMethod, Object object2, Object object3, Object object4, Object object5) {
        switch (moduleMethod.selector) {
            case 58: {
                IntNum intNum = LangObjType.coerceIntNum(object2);
                int n = ((Number)object3).intValue();
                int n2 = ((Number)object4).intValue();
                return numbers.bitwiseCopyBitField(intNum, n, n2, LangObjType.coerceIntNum(object5));
            }
            case 69: {
                IntNum intNum = LangObjType.coerceIntNum(object2);
                int n = ((Number)object3).intValue();
                int n3 = ((Number)object4).intValue();
                return numbers.bitwiseRotateBitField(intNum, n, n3, ((Number)object5).intValue());
            }
        }
        return super.apply4(moduleMethod, object2, object3, object4, object5);
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "bitwise-copy-bit-field", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "bitwise-copy-bit-field", 2, object3);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "bitwise-copy-bit-field", 3, object4);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "bitwise-copy-bit-field", 4, object5);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "bitwise-rotate-bit-field", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "bitwise-rotate-bit-field", 2, object3);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "bitwise-rotate-bit-field", 3, object4);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "bitwise-rotate-bit-field", 4, object5);
        }
    }

    public Object applyN(ModuleMethod moduleMethod, Object[] objectArray) {
        switch (moduleMethod.selector) {
            case 14: {
                return numbers.max(objectArray);
            }
            case 15: {
                return numbers.min(objectArray);
            }
            case 23: {
                return numbers.gcd(objectArray);
            }
            case 24: {
                return numbers.lcm(objectArray);
            }
            case 60: {
                return numbers.bitwiseAnd(objectArray);
            }
            case 61: {
                return numbers.bitwiseIor(objectArray);
            }
            case 62: {
                return numbers.bitwiseXor(objectArray);
            }
        }
        return super.applyN(moduleMethod, objectArray);
    }
}

