/*
 * Decompiled with CFR 0.152.
 */
package gnu.text;

import gnu.mapping.WrappedException;
import gnu.text.Path;
import gnu.text.ResourceStreamHandler;
import gnu.text.URIPath;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;

public class URLPath
extends URIPath {
    final URL url;

    URLPath(URL uRL) {
        super(URLPath.toUri(uRL));
        this.url = uRL;
    }

    public static URLPath valueOf(URL uRL) {
        return new URLPath(uRL);
    }

    public boolean isAbsolute() {
        return true;
    }

    public long getLastModified() {
        return URLPath.getLastModified(this.url);
    }

    public static long getLastModified(URL uRL) {
        try {
            return uRL.openConnection().getLastModified();
        }
        catch (Throwable throwable) {
            return 0L;
        }
    }

    public long getContentLength() {
        return URLPath.getLastModified(this.url);
    }

    public static int getContentLength(URL uRL) {
        try {
            return uRL.openConnection().getContentLength();
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    public URL toURL() {
        return this.url;
    }

    public static URI toUri(URL uRL) {
        try {
            return uRL.toURI();
        }
        catch (Throwable throwable) {
            throw WrappedException.wrapIfNeeded(throwable);
        }
    }

    public URI toUri() {
        return URLPath.toUri(this.url);
    }

    public String toURIString() {
        return this.url.toString();
    }

    public Path resolve(String string) {
        try {
            return URLPath.valueOf(new URL(this.url, string));
        }
        catch (Throwable throwable) {
            throw WrappedException.wrapIfNeeded(throwable);
        }
    }

    public static InputStream openInputStream(URL uRL) throws IOException {
        return uRL.openConnection().getInputStream();
    }

    public InputStream openInputStream() throws IOException {
        return URLPath.openInputStream(this.url);
    }

    public static OutputStream openOutputStream(URL uRL) throws IOException {
        String string = uRL.toString();
        if (string.startsWith("file:")) {
            try {
                return new FileOutputStream(new File(new URI(string)));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setDoInput(false);
        uRLConnection.setDoOutput(true);
        return uRLConnection.getOutputStream();
    }

    public OutputStream openOutputStream() throws IOException {
        return URLPath.openOutputStream(this.url);
    }

    public static URLPath classResourcePath(Class clazz) {
        try {
            return URLPath.valueOf(ResourceStreamHandler.makeURL(clazz));
        }
        catch (Throwable throwable) {
            throw WrappedException.wrapIfNeeded(throwable);
        }
    }
}

