/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.mapping.CallContext;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.InheritingEnvironment;
import gnu.mapping.Location;
import gnu.mapping.NamedLocation;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.mapping.SharedLocation;
import gnu.mapping.Symbol;

public class RunnableClosure
implements Runnable {
    Object result;
    CallContext context;
    public Environment environment;
    private InPort in;
    private OutPort out;
    private OutPort err;
    Throwable exception;
    Procedure action;
    String name;
    static int nrunnables = 0;

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public RunnableClosure(Procedure procedure, CallContext callContext) {
        this(procedure, callContext, callContext.getEnvironment());
    }

    public RunnableClosure(Procedure procedure, CallContext callContext, Environment environment) {
        this.setName("r" + nrunnables++);
        this.action = procedure;
        InheritingEnvironment inheritingEnvironment = Environment.make(this.getName(), environment);
        inheritingEnvironment.flags |= 8;
        inheritingEnvironment.flags &= 0xFFFFFFEF;
        this.environment = inheritingEnvironment;
        int n = callContext.pushedFluidsCount;
        for (int i = 0; i < n; ++i) {
            Location location2 = callContext.pushedFluids[i];
            Symbol symbol = location2.getKeySymbol();
            Object object2 = location2.getKeyProperty();
            if (symbol == null || !(location2 instanceof NamedLocation)) continue;
            NamedLocation namedLocation = (NamedLocation)location2;
            if (namedLocation.base == null) {
                SharedLocation sharedLocation = new SharedLocation(symbol, object2, 0);
                sharedLocation.value = namedLocation.value;
                namedLocation.base = sharedLocation;
                namedLocation.value = null;
                namedLocation = sharedLocation;
            }
            int n2 = symbol.hashCode() ^ System.identityHashCode(object2);
            NamedLocation namedLocation2 = inheritingEnvironment.addUnboundLocation(symbol, object2, n2);
            namedLocation2.base = namedLocation;
        }
    }

    public RunnableClosure(Procedure procedure, Environment environment, InPort inPort, OutPort outPort, OutPort outPort2) {
        this(procedure, CallContext.getInstance(), environment);
        this.in = inPort;
        this.out = outPort;
        this.err = outPort2;
    }

    public RunnableClosure(Procedure procedure) {
        this(procedure, CallContext.getInstance());
    }

    public final CallContext getCallContext() {
        return this.context;
    }

    public void run() {
        try {
            if (this.context == null) {
                this.context = CallContext.getInstance();
            } else {
                CallContext.setInstance(this.context);
            }
            this.context.curEnvironment = this.environment;
            if (this.in != null) {
                InPort.setInDefault(this.in);
            }
            if (this.out != null) {
                OutPort.setOutDefault(this.out);
            }
            if (this.err != null) {
                OutPort.setErrDefault(this.err);
            }
            this.result = this.action.apply0();
        }
        catch (Throwable throwable) {
            this.exception = throwable;
        }
    }

    Object getResult() throws Throwable {
        Throwable throwable = this.exception;
        if (throwable != null) {
            throw throwable;
        }
        return this.result;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#<runnable ");
        stringBuffer.append(this.getName());
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

