/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.xml;

import gnu.kawa.xml.KDocument;
import gnu.lists.Consumer;
import gnu.lists.XConsumer;
import gnu.mapping.Location;
import gnu.mapping.ThreadLocation;
import gnu.text.Path;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import gnu.xml.NodeTree;
import gnu.xml.XMLParser;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Hashtable;

public class Document {
    public static final Document document = new Document();
    private static ThreadLocation docMapLocation = new ThreadLocation("document-map");
    private static HashMap cache = new HashMap();

    public static void parse(Object object2, Consumer consumer) throws Throwable {
        SourceMessages sourceMessages = new SourceMessages();
        if (consumer instanceof XConsumer) {
            ((XConsumer)consumer).beginEntity(object2);
        }
        XMLParser.parse(object2, sourceMessages, consumer);
        if (sourceMessages.seenErrors()) {
            throw new SyntaxException("document function read invalid XML", sourceMessages);
        }
        if (consumer instanceof XConsumer) {
            ((XConsumer)consumer).endEntity();
        }
    }

    public static KDocument parse(Object object2) throws Throwable {
        NodeTree nodeTree = new NodeTree();
        Document.parse(object2, nodeTree);
        return new KDocument(nodeTree, 10);
    }

    public static void clearLocalCache() {
        Location location2 = docMapLocation.getLocation();
        location2.set(null);
    }

    public static void clearSoftCache() {
        cache = new HashMap();
    }

    public static KDocument parseCached(Object object2) throws Throwable {
        return Document.parseCached(Path.valueOf(object2));
    }

    public static synchronized KDocument parseCached(Path path) throws Throwable {
        KDocument kDocument;
        Object object2;
        while ((object2 = (DocReference)DocReference.queue.poll()) != null) {
            cache.remove(((DocReference)object2).key);
        }
        object2 = docMapLocation.getLocation();
        Hashtable<Path, KDocument> hashtable2 = (Hashtable<Path, KDocument>)((Location)object2).get(null);
        if (hashtable2 == null) {
            hashtable2 = new Hashtable<Path, KDocument>();
            ((Location)object2).set(hashtable2);
        }
        if ((kDocument = (KDocument)hashtable2.get(path)) != null) {
            return kDocument;
        }
        DocReference docReference = (DocReference)cache.get(path);
        if (docReference != null) {
            kDocument = (KDocument)docReference.get();
            if (kDocument == null) {
                cache.remove(path);
            } else {
                hashtable2.put(path, kDocument);
                return kDocument;
            }
        }
        kDocument = Document.parse(path);
        hashtable2.put(path, kDocument);
        cache.put(path, new DocReference(path, kDocument));
        return kDocument;
    }

    private static class DocReference
    extends SoftReference {
        static ReferenceQueue queue = new ReferenceQueue();
        Path key;

        public DocReference(Path path, KDocument kDocument) {
            super(kDocument, queue);
            this.key = path;
        }
    }
}

