/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.reflect;

import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Member;
import gnu.bytecode.Method;
import gnu.bytecode.ObjectType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.CanInline;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.ErrorExp;
import gnu.expr.Expression;
import gnu.expr.InlineCalls;
import gnu.expr.Inlineable;
import gnu.expr.Language;
import gnu.expr.QuoteExp;
import gnu.expr.Target;
import gnu.kawa.lispexpr.LangPrimType;
import gnu.kawa.reflect.ClassMethods;
import gnu.kawa.reflect.Invoke;
import gnu.kawa.reflect.SlotSet;
import gnu.lists.FString;
import gnu.mapping.HasSetter;
import gnu.mapping.Procedure;
import gnu.mapping.Procedure2;
import gnu.mapping.SimpleSymbol;
import gnu.mapping.Symbol;
import gnu.mapping.Values;
import gnu.mapping.WrappedException;
import gnu.mapping.WrongArguments;
import gnu.mapping.WrongType;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;

public class SlotGet
extends Procedure2
implements HasSetter,
CanInline,
Inlineable {
    static Class[] noClasses = new Class[0];
    boolean isStatic;
    Procedure setter;
    public static final SlotGet field = new SlotGet("field", false, SlotSet.set$Mnfield$Ex);
    public static final SlotGet slotRef = new SlotGet("slot-ref", false, SlotSet.set$Mnfield$Ex);
    public static final SlotGet staticField = new SlotGet("static-field", true, SlotSet.set$Mnstatic$Mnfield$Ex);

    public SlotGet(String string, boolean bl) {
        super(string);
        this.isStatic = bl;
    }

    public SlotGet(String string, boolean bl, Procedure procedure) {
        super(string);
        this.isStatic = bl;
        this.setter = procedure;
    }

    public static Object field(Object object2, String string) {
        return field.apply2(object2, string);
    }

    public static Object staticField(Object object2, String string) {
        return staticField.apply2(object2, string);
    }

    public Object apply2(Object object2, Object object3) {
        String string;
        String string2;
        String string3 = null;
        String string4 = null;
        if (object3 instanceof gnu.bytecode.Field) {
            string2 = ((gnu.bytecode.Field)object3).getName();
            string = Compilation.demangleName(string2, true);
        } else if (object3 instanceof Method) {
            String string5 = ((Method)object3).getName();
            string = Compilation.demangleName(string5, false);
            if (string5.startsWith("get")) {
                string3 = string5;
            } else if (string5.startsWith("is")) {
                string4 = string5;
            }
            string2 = null;
        } else if (object3 instanceof SimpleSymbol || object3 instanceof CharSequence) {
            string = object3.toString();
            string2 = Compilation.mangleNameIfNeeded(string);
        } else {
            throw new WrongType((Procedure)this, 2, object3, "string");
        }
        if ("class".equals(string2)) {
            string2 = "class";
        } else if ("length".equals(string2)) {
            string2 = "length";
        }
        return SlotGet.getSlotValue(this.isStatic, object2, string, string2, string3, string4, Language.getDefaultLanguage());
    }

    public static Object getSlotValue(boolean bl, Object object2, String string, String string2, String string3, String string4, Language language) {
        Object object3;
        Class<?> clazz;
        Class<?> clazz2 = clazz = bl ? SlotGet.coerceToClass(object2) : object2.getClass();
        if (string2 == "length" && clazz.isArray()) {
            int n = Array.getLength(object2);
            return language.coerceToObject(n);
        }
        if (string2 == "class") {
            return clazz;
        }
        boolean bl2 = false;
        if (string2 != null) {
            try {
                object3 = clazz.getField(string2);
            }
            catch (Exception exception) {
                object3 = null;
            }
            if (object3 != null) {
                if (bl && (((Field)object3).getModifiers() & 8) == 0) {
                    throw new RuntimeException("cannot access non-static field '" + string2 + '\'');
                }
                try {
                    return language.coerceToObject(((Field)object3).getType(), ((Field)object3).get(object2));
                }
                catch (IllegalAccessException illegalAccessException) {
                    bl2 = true;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        try {
            object3 = null;
            java.lang.reflect.Method method = null;
            try {
                object3 = string3 != null ? string3 : ClassExp.slotToMethodName("get", string);
                method = clazz.getMethod((String)object3, noClasses);
            }
            catch (Exception exception) {
                object3 = string4 != null ? string4 : ClassExp.slotToMethodName("is", string);
                method = clazz.getMethod((String)object3, noClasses);
            }
            if (bl && (method.getModifiers() & 8) == 0) {
                throw new RuntimeException("cannot call non-static getter method '" + (String)object3 + '\'');
            }
            Object object4 = method.invoke(object2, Values.noArgs);
            object4 = language.coerceToObject(method.getReturnType(), object4);
            return object4;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw WrappedException.wrapIfNeeded(invocationTargetException.getTargetException());
        }
        catch (IllegalAccessException illegalAccessException) {
            bl2 = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (bl2) {
            throw new RuntimeException("illegal access for field " + string2);
        }
        throw new RuntimeException("no such field " + string2 + " in " + clazz.getName());
    }

    static Class coerceToClass(Object object2) {
        if (object2 instanceof Class) {
            return (Class)object2;
        }
        if (object2 instanceof Type) {
            return ((Type)object2).getReflectClass();
        }
        throw new RuntimeException("argument is neither Class nor Type");
    }

    public void setN(Object[] objectArray) {
        int n = objectArray.length;
        if (n != 3) {
            throw new WrongArguments(this.getSetter(), n);
        }
        this.set2(objectArray[0], objectArray[1], objectArray[2]);
    }

    public void set2(Object object2, Object object3, Object object4) {
        SlotSet.apply(this.isStatic, object2, (String)object3, object4);
    }

    public static Member lookupMember(ObjectType objectType, String string, ClassType classType) {
        String string2;
        Method method;
        gnu.bytecode.Field field = objectType.getField(Compilation.mangleNameIfNeeded(string), -1);
        if (field != null) {
            if (classType == null) {
                classType = Type.pointer_type;
            }
            if (classType.isAccessible(field, objectType)) {
                return field;
            }
        }
        if ((method = objectType.getMethod(string2 = ClassExp.slotToMethodName("get", string), Type.typeArray0)) == null) {
            return field;
        }
        return method;
    }

    public Expression inline(ApplyExp object2, InlineCalls inlineCalls, boolean bl) {
        Object object3;
        Object object4;
        Object object5;
        Type type;
        Object object6;
        ((ApplyExp)object2).walkArgs(inlineCalls, bl);
        Compilation compilation = inlineCalls.getCompilation();
        Language language = compilation.getLanguage();
        Expression[] expressionArray = ((ApplyExp)object2).getArgs();
        Expression expression = expressionArray[0];
        Expression expression2 = expressionArray[1];
        String string = null;
        if (expression2 instanceof QuoteExp && ((object6 = ((QuoteExp)expression2).getValue()) instanceof String || object6 instanceof FString || object6 instanceof Symbol)) {
            string = object6.toString();
        }
        if (this.isStatic) {
            type = language.getTypeFor(expression);
            int n = Invoke.checkKnownClass(type, compilation);
            if (n < 0) {
                return object2;
            }
            if ("class".equals(string)) {
                if (n > 0) {
                    return QuoteExp.getInstance(type.getReflectClass());
                }
                Method method = Compilation.typeType.getDeclaredMethod("getReflectClass", 0);
                return new ApplyExp(method, new Expression[]{expression});
            }
            if (type != null) {
                object5 = new Expression[]{new QuoteExp(type), expression2};
                object4 = new ApplyExp(((ApplyExp)object2).getFunction(), (Expression[])object5);
                ((Expression)object4).setLine((Expression)object2);
                object2 = object4;
            }
        } else {
            type = expression.getType();
        }
        if (type instanceof ClassType && string != null) {
            ClassType classType = (ClassType)type;
            object5 = compilation.curClass != null ? compilation.curClass : compilation.mainClass;
            object4 = SlotGet.lookupMember(classType, string, (ClassType)object5);
            if (object4 instanceof gnu.bytecode.Field) {
                boolean bl2;
                object3 = (gnu.bytecode.Field)object4;
                int n = ((gnu.bytecode.Field)object3).getModifiers();
                boolean bl3 = bl2 = (n & 8) != 0;
                if (this.isStatic && !bl2) {
                    return new ErrorExp("cannot access non-static field `" + string + "' using `" + this.getName() + '\'', compilation);
                }
                if (object5 != null && !object5.isAccessible((Member)object3, classType)) {
                    return new ErrorExp("field " + ((gnu.bytecode.Field)object3).getDeclaringClass().getName() + '.' + string + " is not accessible here", compilation);
                }
            } else if (object4 instanceof Method) {
                object3 = (Method)object4;
                ClassType classType2 = ((Method)object3).getDeclaringClass();
                int n = ((Method)object3).getModifiers();
                boolean bl4 = ((Method)object3).getStaticFlag();
                if (this.isStatic && !bl4) {
                    return new ErrorExp("cannot call non-static getter method `" + string + "' using `" + this.getName() + '\'', compilation);
                }
                if (object5 != null && !object5.isAccessible(classType2, classType, n)) {
                    return new ErrorExp("method " + object3 + " is not accessible here", compilation);
                }
            }
            if (object4 != null) {
                object3 = new Expression[]{expression, new QuoteExp(object4)};
                ApplyExp applyExp = new ApplyExp(((ApplyExp)object2).getFunction(), (Expression[])object3);
                applyExp.setLine((Expression)object2);
                return applyExp;
            }
            if (type != Type.pointer_type) {
                compilation.error('e', "no slot `" + string + "' in " + classType.getName());
            }
        }
        if (string != null && !(type instanceof ArrayType)) {
            String string2 = Compilation.mangleNameIfNeeded(string);
            string2 = string2.intern();
            object5 = ClassExp.slotToMethodName("get", string);
            object4 = ClassExp.slotToMethodName("is", string);
            object3 = new ApplyExp(Invoke.invokeStatic, new Expression[]{QuoteExp.getInstance("gnu.kawa.reflect.SlotGet"), QuoteExp.getInstance("getSlotValue"), this.isStatic ? QuoteExp.trueExp : QuoteExp.falseExp, expressionArray[0], QuoteExp.getInstance(string), QuoteExp.getInstance(string2), QuoteExp.getInstance(object5), QuoteExp.getInstance(object4), QuoteExp.getInstance(language)});
            ((Expression)object3).setLine((Expression)object2);
            return inlineCalls.walkApplyOnly((ApplyExp)object3);
        }
        return object2;
    }

    public void compile(ApplyExp applyExp, Compilation compilation, Target target) {
        Object object2;
        Expression[] expressionArray = applyExp.getArgs();
        Expression expression = expressionArray[0];
        Expression expression2 = expressionArray[1];
        Language language = compilation.getLanguage();
        Type type = this.isStatic ? language.getTypeFor(expression) : expression.getType();
        CodeAttr codeAttr = compilation.getCode();
        if (type instanceof ClassType && expression2 instanceof QuoteExp) {
            object2 = (ClassType)type;
            Object object3 = ((QuoteExp)expression2).getValue();
            if (object3 instanceof gnu.bytecode.Field) {
                gnu.bytecode.Field field = (gnu.bytecode.Field)object3;
                int n = field.getModifiers();
                boolean bl = (n & 8) != 0;
                expressionArray[0].compile(compilation, bl ? Target.Ignore : Target.pushValue((Type)object2));
                if (bl) {
                    boolean bl2 = false;
                    if (!bl2) {
                        codeAttr.emitGetStatic(field);
                    }
                } else {
                    codeAttr.emitGetField(field);
                }
                Type type2 = field.getType();
                Class clazz = type2.getReflectClass();
                if (clazz != null) {
                    type2 = language.getTypeFor(clazz);
                }
                target.compileFromStack(compilation, type2);
                return;
            }
            if (object3 instanceof Method) {
                Method method = (Method)object3;
                int n = method.getModifiers();
                boolean bl = method.getStaticFlag();
                expressionArray[0].compile(compilation, bl ? Target.Ignore : Target.pushValue((Type)object2));
                if (bl) {
                    codeAttr.emitInvokeStatic(method);
                } else if (((ClassType)object2).isInterface()) {
                    codeAttr.emitInvokeInterface(method);
                } else {
                    codeAttr.emitInvokeVirtual(method);
                }
                target.compileFromStack(compilation, method.getReturnType());
                return;
            }
        }
        object2 = ClassMethods.checkName(expression2);
        if (type instanceof ArrayType && "length".equals(object2) && !this.isStatic) {
            expressionArray[0].compile(compilation, Target.pushValue(type));
            codeAttr.emitArrayLength();
            target.compileFromStack(compilation, LangPrimType.intType);
            return;
        }
        ApplyExp.compile(applyExp, compilation, target);
    }

    public Type getReturnType(Expression[] expressionArray) {
        int n = expressionArray.length;
        if (n == 2) {
            Expression expression = expressionArray[0];
            Expression expression2 = expressionArray[1];
            if (expression2 instanceof QuoteExp) {
                Object object2 = ((QuoteExp)expression2).getValue();
                if (object2 instanceof gnu.bytecode.Field) {
                    return ((gnu.bytecode.Field)object2).getType();
                }
                if (object2 instanceof Method) {
                    return ((Method)object2).getReturnType();
                }
                if (!this.isStatic && expression.getType() instanceof ArrayType && "length".equals(ClassMethods.checkName(expression2, true))) {
                    return LangPrimType.intType;
                }
            }
        }
        return Type.pointer_type;
    }

    public Procedure getSetter() {
        return this.setter == null ? super.getSetter() : this.setter;
    }

    public static ApplyExp makeGetField(Expression expression, String string) {
        Expression[] expressionArray = new Expression[]{expression, new QuoteExp((Object)string)};
        return new ApplyExp(field, expressionArray);
    }
}

