/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.lispexpr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Field;
import gnu.bytecode.Filter;
import gnu.bytecode.Method;
import gnu.bytecode.ObjectType;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Language;
import gnu.expr.PairClassType;
import gnu.expr.PrimProcedure;
import gnu.expr.Target;
import gnu.expr.TypeValue;
import gnu.kawa.functions.MakeList;
import gnu.kawa.reflect.InstanceOf;
import gnu.mapping.Procedure;
import gnu.mapping.WrongType;
import gnu.math.IntNum;
import gnu.text.FilePath;
import gnu.text.Path;
import gnu.text.URIPath;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LangObjType
extends ObjectType
implements TypeValue {
    final int typeCode;
    private static final int PATH_TYPE_CODE = 1;
    private static final int FILEPATH_TYPE_CODE = 2;
    private static final int URI_TYPE_CODE = 3;
    private static final int CLASS_TYPE_CODE = 4;
    private static final int TYPE_TYPE_CODE = 5;
    private static final int CLASSTYPE_TYPE_CODE = 6;
    private static final int INTEGER_TYPE_CODE = 7;
    private static final int LIST_TYPE_CODE = 8;
    private static final int VECTOR_TYPE_CODE = 9;
    private static final int STRING_TYPE_CODE = 10;
    private static final int REGEX_TYPE_CODE = 11;
    public static final LangObjType pathType = new LangObjType("path", "gnu.text.Path", 1);
    public static final LangObjType filepathType = new LangObjType("filepath", "gnu.text.FilePath", 2);
    public static final LangObjType URIType = new LangObjType("URI", "gnu.text.URIPath", 3);
    public static final LangObjType typeClass = new LangObjType("class", "java.lang.Class", 4);
    public static final LangObjType typeType = new LangObjType("type", "gnu.bytecode.Type", 5);
    public static final LangObjType typeClassType = new LangObjType("class-type", "gnu.bytecode.ClassType", 6);
    public static final LangObjType integerType = new LangObjType("integer", "gnu.math.IntNum", 7);
    public static final LangObjType vectorType = new LangObjType("vector", "gnu.lists.FVector", 9);
    public static final LangObjType regexType = new LangObjType("regex", "java.util.regex.Pattern", 11);
    public static final LangObjType stringType = new LangObjType("string", "java.lang.CharSequence", 10);
    public static final LangObjType listType = new LangObjType("list", "gnu.lists.LList", 8);
    static final ClassType typeArithmetic = ClassType.make("gnu.kawa.functions.Arithmetic");
    ClassType implementationType;
    static PrimProcedure makePathProc = new PrimProcedure("gnu.text.Path", "valueOf", 1);
    static PrimProcedure makeFilepathProc = new PrimProcedure("gnu.text.FilePath", "makeFilePath", 1);
    static PrimProcedure makeURIProc = new PrimProcedure("gnu.text.URIPath", "makeURI", 1);
    static final String VARARGS_SUFFIX = "";
    public static final ClassType typeLangObjType = ClassType.make("gnu.kawa.lispexpr.LangObjType");

    LangObjType(String string, String string2, int n) {
        super(string);
        this.implementationType = ClassType.make(string2);
        this.typeCode = n;
        this.setSignature(this.implementationType.getSignature());
    }

    @Override
    public int compare(Type type) {
        switch (this.typeCode) {
            case 4: {
                if (type != typeType && type != typeClassType && type != LangObjType.typeType.implementationType && type != LangObjType.typeClassType.implementationType) break;
                return -1;
            }
            case 5: {
                if (type == typeClass || type == typeClassType || type == LangObjType.typeClass.implementationType || type == LangObjType.typeClassType.implementationType) {
                    return 1;
                }
            }
            case 6: {
                if (type == typeClass || type == LangObjType.typeClass.implementationType) {
                    return 1;
                }
                if (type != typeType && type != LangObjType.typeClass.implementationType) break;
                return -1;
            }
            case 7: {
                if (!(type instanceof PrimType)) break;
                char c = type.getSignature().charAt(0);
                switch (c) {
                    case 'B': 
                    case 'I': 
                    case 'J': 
                    case 'S': {
                        return 1;
                    }
                }
            }
        }
        return this.getImplementationType().compare(type.getImplementationType());
    }

    @Override
    public Field getField(String string, int n) {
        return this.implementationType.getField(string, n);
    }

    @Override
    public Method getMethod(String string, Type[] typeArray) {
        return this.implementationType.getMethod(string, typeArray);
    }

    @Override
    public int getMethods(Filter filter, int n, List<Method> list) {
        return this.implementationType.getMethods(filter, n, list);
    }

    @Override
    public Class getReflectClass() {
        return this.implementationType.getReflectClass();
    }

    @Override
    public Type getImplementationType() {
        return this.implementationType;
    }

    @Override
    public void emitIsInstance(Variable variable, Compilation compilation, Target target) {
        switch (this.typeCode) {
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                this.implementationType.emitIsInstance(compilation.getCode());
                target.compileFromStack(compilation, compilation.getLanguage().getTypeFor(Boolean.TYPE));
                break;
            }
            default: {
                InstanceOf.emitIsInstance(this, variable, compilation, target);
            }
        }
    }

    public static IntNum coerceIntNum(Object object2) {
        IntNum intNum = IntNum.asIntNumOrNull(object2);
        if (intNum == null && object2 != null) {
            throw new WrongType(-4, object2, integerType);
        }
        return intNum;
    }

    public static Class coerceToClassOrNull(Object object2) {
        if (object2 instanceof Class) {
            return (Class)object2;
        }
        if (object2 instanceof Type && object2 instanceof ClassType && !(object2 instanceof PairClassType)) {
            return ((ClassType)object2).getReflectClass();
        }
        return null;
    }

    public static Class coerceToClass(Object object2) {
        Class clazz = LangObjType.coerceToClassOrNull(object2);
        if (clazz == null && object2 != null) {
            throw new ClassCastException("cannot cast " + object2 + " to type");
        }
        return clazz;
    }

    public static ClassType coerceToClassTypeOrNull(Object object2) {
        Language language;
        Type type;
        if (object2 instanceof ClassType) {
            return (ClassType)object2;
        }
        if (object2 instanceof Class && (type = (language = Language.getDefaultLanguage()).getTypeFor((Class)object2)) instanceof ClassType) {
            return (ClassType)type;
        }
        return null;
    }

    public static ClassType coerceToClassType(Object object2) {
        ClassType classType = LangObjType.coerceToClassTypeOrNull(object2);
        if (classType == null && object2 != null) {
            throw new ClassCastException("cannot cast " + object2 + " to class-type");
        }
        return classType;
    }

    public static Type coerceToTypeOrNull(Object object2) {
        if (object2 instanceof Type) {
            return (Type)object2;
        }
        if (object2 instanceof Class) {
            Language language = Language.getDefaultLanguage();
            return language.getTypeFor((Class)object2);
        }
        return null;
    }

    public static Type coerceToType(Object object2) {
        Type type = LangObjType.coerceToTypeOrNull(object2);
        if (type == null && object2 != null) {
            throw new ClassCastException("cannot cast " + object2 + " to type");
        }
        return type;
    }

    Method coercionOrNullMethod() {
        String string;
        ClassType classType = this.implementationType;
        switch (this.typeCode) {
            case 1: {
                string = "coerceToPathOrNull";
                break;
            }
            case 2: {
                string = "coerceToFilePathOrNull";
                break;
            }
            case 3: {
                string = "coerceToURIPathOrNull";
                break;
            }
            case 4: {
                classType = typeLangObjType;
                string = "coerceToClassOrNull";
                break;
            }
            case 6: {
                classType = typeLangObjType;
                string = "coerceToClassTypeOrNull";
                break;
            }
            case 5: {
                classType = typeLangObjType;
                string = "coerceToTypeOrNull";
                break;
            }
            case 7: {
                classType = this.implementationType;
                string = "asIntNumOrNull";
                break;
            }
            default: {
                return null;
            }
        }
        return classType.getDeclaredMethod(string, 1);
    }

    @Override
    public void emitTestIf(Variable variable, Declaration declaration, Compilation compilation) {
        Method method;
        CodeAttr codeAttr = compilation.getCode();
        if (variable != null) {
            codeAttr.emitLoad(variable);
        }
        if ((method = this.coercionOrNullMethod()) != null) {
            codeAttr.emitInvokeStatic(method);
        }
        if (declaration != null) {
            codeAttr.emitDup();
            declaration.compileStore(compilation);
        }
        if (method != null) {
            codeAttr.emitIfNotNull();
        } else {
            this.implementationType.emitIsInstance(codeAttr);
            codeAttr.emitIfIntNotZero();
        }
    }

    @Override
    public Object coerceFromObject(Object object2) {
        switch (this.typeCode) {
            case 1: {
                return Path.valueOf(object2);
            }
            case 2: {
                return FilePath.makeFilePath(object2);
            }
            case 3: {
                return URIPath.makeURI(object2);
            }
            case 4: {
                return LangObjType.coerceToClass(object2);
            }
            case 6: {
                return LangObjType.coerceToClassType(object2);
            }
            case 5: {
                return LangObjType.coerceToType(object2);
            }
            case 7: {
                return LangObjType.coerceIntNum(object2);
            }
        }
        return super.coerceFromObject(object2);
    }

    @Override
    public void emitCoerceFromObject(CodeAttr codeAttr) {
        switch (this.typeCode) {
            case 4: {
                codeAttr.emitInvokeStatic(typeLangObjType.getDeclaredMethod("coerceToClass", 1));
                break;
            }
            case 6: {
                codeAttr.emitInvokeStatic(typeLangObjType.getDeclaredMethod("coerceToClassType", 1));
                break;
            }
            case 5: {
                codeAttr.emitInvokeStatic(typeLangObjType.getDeclaredMethod("coerceToType", 1));
                break;
            }
            case 7: {
                codeAttr.emitInvokeStatic(typeLangObjType.getDeclaredMethod("coerceIntNum", 1));
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                codeAttr.emitCheckcast(this.implementationType);
                break;
            }
            default: {
                codeAttr.emitInvoke(((PrimProcedure)this.getConstructor()).getMethod());
            }
        }
    }

    @Override
    public Procedure getConstructor() {
        switch (this.typeCode) {
            case 1: {
                return makePathProc;
            }
            case 2: {
                return makeFilepathProc;
            }
            case 3: {
                return makeURIProc;
            }
            case 9: {
                return new PrimProcedure("kawa.lib.vectors", "$make$vector$", 1);
            }
            case 8: {
                return MakeList.list;
            }
            case 10: {
                return new PrimProcedure("kawa.lib.strings", "$make$string$", 1);
            }
            case 11: {
                return new PrimProcedure("java.util.regex.Pattern", "compile", 1);
            }
        }
        return null;
    }
}

