/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.bytecode.ClassType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.CanInline;
import gnu.expr.Expression;
import gnu.expr.InlineCalls;
import gnu.expr.QuoteExp;
import gnu.kawa.functions.Convert;
import gnu.kawa.functions.NamedPartSetter;
import gnu.kawa.reflect.Invoke;
import gnu.kawa.reflect.SlotGet;
import gnu.kawa.reflect.SlotSet;
import gnu.mapping.CallContext;
import gnu.mapping.HasSetter;
import gnu.mapping.MethodProc;
import gnu.mapping.Procedure;
import gnu.mapping.ProcedureN;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import kawa.standard.Scheme;

class NamedPart
extends ProcedureN
implements HasSetter,
Externalizable,
CanInline {
    Object container;
    Object member;
    char kind;
    MethodProc methods;

    public NamedPart(Object object2, Object object3, char c) {
        this.container = object2;
        this.member = object3;
        this.kind = c;
    }

    public NamedPart(Object object2, String string, char c, MethodProc methodProc) {
        this.container = object2;
        this.methods = methodProc;
        this.member = string;
        this.kind = c;
    }

    public int numArgs() {
        if (this.kind == 'I' || this.kind == 'C') {
            return 4097;
        }
        if (this.kind == 'D') {
            return 4096;
        }
        return -4096;
    }

    public Expression inline(ApplyExp applyExp, InlineCalls inlineCalls, boolean bl) {
        applyExp.walkArgs(inlineCalls, bl);
        Expression[] expressionArray = applyExp.getArgs();
        switch (this.kind) {
            case 'D': {
                SlotGet slotGet;
                String string = this.member.toString().substring(1);
                Expression[] expressionArray2 = new Expression[2];
                expressionArray2[1] = QuoteExp.getInstance(string);
                if (expressionArray.length > 0) {
                    expressionArray2[0] = Convert.makeCoercion(expressionArray[0], new QuoteExp(this.container));
                    slotGet = SlotGet.field;
                } else {
                    expressionArray2[0] = QuoteExp.getInstance(this.container);
                    slotGet = SlotGet.staticField;
                }
                ApplyExp applyExp2 = new ApplyExp(slotGet, expressionArray2);
                applyExp2.setLine(applyExp);
                return inlineCalls.walkApplyOnly(applyExp2);
            }
        }
        return applyExp;
    }

    public void apply(CallContext callContext) throws Throwable {
        this.apply(callContext.getArgs(), callContext);
    }

    public void apply(Object[] objectArray, CallContext callContext) throws Throwable {
        if (this.kind == 'S') {
            this.methods.checkN(objectArray, callContext);
        } else if (this.kind == 'M') {
            int n = objectArray.length;
            Object[] objectArray2 = new Object[n + 1];
            objectArray2[0] = this.container;
            System.arraycopy(objectArray, 0, objectArray2, 1, n);
            this.methods.checkN(objectArray2, callContext);
        } else {
            callContext.writeValue(this.applyN(objectArray));
        }
    }

    public Object applyN(Object[] objectArray) throws Throwable {
        switch (this.kind) {
            case 'I': {
                return Scheme.instanceOf.apply2(objectArray[0], this.container);
            }
            case 'C': {
                return Convert.as.apply2(this.container, objectArray[0]);
            }
            case 'N': {
                Object[] objectArray2 = new Object[objectArray.length + 1];
                objectArray2[0] = this.container;
                System.arraycopy(objectArray, 0, objectArray2, 1, objectArray.length);
                return Invoke.make.applyN(objectArray2);
            }
            case 'S': {
                return this.methods.applyN(objectArray);
            }
            case 'M': {
                Object[] objectArray3 = new Object[objectArray.length + 1];
                objectArray3[0] = this.container;
                System.arraycopy(objectArray, 0, objectArray3, 1, objectArray.length);
                return this.methods.applyN(objectArray3);
            }
            case 'D': {
                String string = this.member.toString().substring(1);
                if (objectArray.length == 0) {
                    return SlotGet.staticField((ClassType)this.container, string);
                }
                return SlotGet.field(((Type)this.container).coerceFromObject(objectArray[0]), string);
            }
        }
        throw new Error("unknown part " + this.member + " in " + this.container);
    }

    public Procedure getSetter() {
        if (this.kind == 'D') {
            return new NamedPartSetter(this);
        }
        throw new RuntimeException("procedure '" + this.getName() + "' has no setter");
    }

    public void set0(Object object2) throws Throwable {
        switch (this.kind) {
            case 'D': {
                String string = this.member.toString().substring(1);
                SlotSet.setStaticField((ClassType)this.container, string, object2);
                return;
            }
        }
        throw new Error("invalid setter for " + this);
    }

    public void set1(Object object2, Object object3) throws Throwable {
        switch (this.kind) {
            case 'D': {
                String string = this.member.toString().substring(1);
                object2 = ((Type)this.container).coerceFromObject(object2);
                SlotSet.setField(object2, string, object3);
                return;
            }
        }
        throw new Error("invalid setter for " + this);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.container);
        objectOutput.writeObject(this.member);
        objectOutput.writeChar(this.kind);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.kind = objectInput.readChar();
        this.container = (Procedure)objectInput.readObject();
        this.member = (Procedure)objectInput.readObject();
    }
}

