/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.Type;
import gnu.expr.AccessExp;
import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.ConsumerTarget;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.InlineCalls;
import gnu.expr.LambdaExp;
import gnu.expr.ModuleExp;
import gnu.expr.QuoteExp;
import gnu.expr.ScopeExp;
import gnu.expr.Target;
import gnu.kawa.util.IdentityHashTable;
import gnu.mapping.CallContext;
import gnu.mapping.Environment;
import gnu.mapping.EnvironmentKey;
import gnu.mapping.Location;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.mapping.Symbol;
import gnu.mapping.UnboundLocationException;

public class ReferenceExp
extends AccessExp {
    static int counter;
    int id = ++counter;
    public static final int DONT_DEREFERENCE = 1;
    public static final int PROCEDURE_NAME = 2;
    public static final int PREFER_BINDING2 = 4;
    public static final int CREATE_FIELD_REFERENCE = 8;
    public static final int TYPE_NAME = 16;

    public final boolean getDontDereference() {
        return (this.flags & 1) != 0;
    }

    public final void setDontDereference(boolean bl) {
        this.setFlag(bl, 1);
    }

    public final boolean isUnknown() {
        return Declaration.isUnknown(this.binding);
    }

    public final boolean isProcedureName() {
        return (this.flags & 2) != 0;
    }

    public final void setProcedureName(boolean bl) {
        this.setFlag(bl, 2);
    }

    public ReferenceExp(Object object2) {
        this.symbol = object2;
    }

    public ReferenceExp(Object object2, Declaration declaration) {
        this.symbol = object2;
        this.binding = declaration;
    }

    public ReferenceExp(Declaration declaration) {
        this(declaration.getSymbol(), declaration);
    }

    protected boolean mustCompile() {
        return false;
    }

    public final Object valueIfConstant() {
        Expression expression;
        if (this.binding != null && (expression = this.binding.getValue()) != null) {
            return expression.valueIfConstant();
        }
        return null;
    }

    public void apply(CallContext callContext) throws Throwable {
        Object object2;
        if (this.binding != null && this.binding.isAlias() && !this.getDontDereference() && this.binding.value instanceof ReferenceExp) {
            Expression expression;
            ReferenceExp referenceExp = (ReferenceExp)this.binding.value;
            if (referenceExp.getDontDereference() && referenceExp.binding != null && ((expression = referenceExp.binding.getValue()) instanceof QuoteExp || expression instanceof ReferenceExp || expression instanceof LambdaExp)) {
                expression.apply(callContext);
                return;
            }
            object2 = this.binding.value.eval(callContext);
        } else if (this.binding != null && this.binding.field != null && this.binding.field.getDeclaringClass().isExisting() && (!this.getDontDereference() || this.binding.isIndirectBinding())) {
            try {
                Object object3 = this.binding.field.getStaticFlag() ? null : this.contextDecl().getValue().eval(callContext);
                object2 = this.binding.field.getReflectField().get(object3);
            }
            catch (Exception exception) {
                String string = "exception evaluating " + this.symbol + " from " + this.binding.field + " - " + exception;
                throw new UnboundLocationException((Object)string, this);
            }
        } else if (this.binding != null && (this.binding.value instanceof QuoteExp || this.binding.value instanceof LambdaExp) && this.binding.value != QuoteExp.undefined_exp && (!this.getDontDereference() || this.binding.isIndirectBinding())) {
            object2 = this.binding.value.eval(callContext);
        } else {
            if (this.binding == null || this.binding.context instanceof ModuleExp && !this.binding.isPrivate()) {
                Object object4;
                Object object5;
                Environment environment = callContext.getEnvironment();
                Symbol symbol = this.symbol instanceof Symbol ? (Symbol)this.symbol : environment.getSymbol(this.symbol.toString());
                Object object6 = object5 = this.getFlag(4) && this.isProcedureName() ? EnvironmentKey.FUNCTION : null;
                if (this.getDontDereference()) {
                    object4 = environment.getLocation(symbol, object5);
                } else {
                    String string = Location.UNBOUND;
                    object4 = environment.get(symbol, object5, string);
                    if (object4 == string) {
                        throw new UnboundLocationException((Object)symbol, this);
                    }
                }
                callContext.writeValue(object4);
                return;
            }
            object2 = callContext.evalFrames[ScopeExp.nesting(this.binding.context)][this.binding.evalIndex];
        }
        if (!this.getDontDereference() && this.binding.isIndirectBinding()) {
            object2 = ((Location)object2).get();
        }
        callContext.writeValue(object2);
    }

    public void compile(Compilation compilation, Target target) {
        if (!(target instanceof ConsumerTarget) || !((ConsumerTarget)target).compileWrite(this, compilation)) {
            this.binding.load(this, this.flags, compilation, target);
        }
    }

    protected Expression deepCopy(IdentityHashTable identityHashTable) {
        Declaration declaration = identityHashTable.get(this.binding, this.binding);
        Object object2 = identityHashTable.get(this.symbol, this.symbol);
        ReferenceExp referenceExp = new ReferenceExp(object2, declaration);
        referenceExp.flags = this.getFlags();
        return referenceExp;
    }

    protected Expression walk(ExpWalker expWalker) {
        return expWalker.walkReferenceExp(this);
    }

    public Expression inline(ApplyExp applyExp, InlineCalls inlineCalls, Declaration declaration, boolean bl) {
        declaration = this.binding;
        if (declaration != null && !declaration.getFlag(65536)) {
            Expression expression;
            if (!(declaration = Declaration.followAliases(declaration)).isIndirectBinding() && (expression = declaration.getValue()) != null) {
                return expression.inline(applyExp, inlineCalls, declaration, bl);
            }
        } else if (this.getSymbol() instanceof Symbol) {
            Symbol symbol = (Symbol)this.getSymbol();
            Object object2 = Environment.getCurrent().getFunction(symbol, null);
            if (object2 instanceof Procedure) {
                return new QuoteExp(object2).inline(applyExp, inlineCalls, null, bl);
            }
        }
        if (!bl) {
            applyExp.args = inlineCalls.walkExps(applyExp.args, applyExp.args.length);
        }
        return applyExp;
    }

    public void print(OutPort outPort) {
        outPort.print("(Ref/");
        outPort.print(this.id);
        if (this.symbol != null && (this.binding == null || this.symbol.toString() != this.binding.getName())) {
            outPort.print('/');
            outPort.print(this.symbol);
        }
        if (this.binding != null) {
            outPort.print('/');
            outPort.print(this.binding);
        }
        outPort.print(")");
    }

    public Type getType() {
        Expression expression;
        Declaration declaration = this.binding;
        if (declaration == null || declaration.isFluid()) {
            return Type.pointer_type;
        }
        if (this.getDontDereference()) {
            return Compilation.typeLocation;
        }
        Type type = (declaration = Declaration.followAliases(declaration)).getType();
        if ((type == null || type == Type.pointer_type) && (expression = declaration.getValue()) != null) {
            Expression expression2 = declaration.value;
            declaration.value = null;
            type = expression.getType();
            declaration.value = expression2;
        }
        return type;
    }

    public boolean isSingleValue() {
        if (this.binding != null && this.binding.getFlag(262144)) {
            return true;
        }
        return super.isSingleValue();
    }

    public boolean side_effects() {
        return this.binding == null || !this.binding.isLexical();
    }

    public String toString() {
        return "RefExp/" + this.symbol + '/' + this.id + '/';
    }
}

