/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.BlockExp;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ErrorExp;
import gnu.expr.ExitExp;
import gnu.expr.Expression;
import gnu.expr.FluidLetExp;
import gnu.expr.IfExp;
import gnu.expr.LambdaExp;
import gnu.expr.LangExp;
import gnu.expr.LetExp;
import gnu.expr.ModuleExp;
import gnu.expr.ObjectExp;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;
import gnu.expr.SetExp;
import gnu.expr.SynchronizedExp;
import gnu.expr.ThisExp;
import gnu.expr.TryExp;
import gnu.text.SourceLocator;
import gnu.text.SourceMessages;

public class ExpWalker
implements SourceLocator {
    protected SourceMessages messages;
    Compilation comp;
    protected LambdaExp currentLambda = null;
    protected Object exitValue = null;

    public Compilation getCompilation() {
        return this.comp;
    }

    public SourceMessages getMessages() {
        return this.messages;
    }

    protected Expression walkExpression(Expression expression) {
        expression.walkChildren(this);
        return expression;
    }

    public void setContext(Compilation compilation) {
        this.comp = compilation;
        this.messages = compilation.getMessages();
    }

    public Expression walk(Expression expression) {
        int n = expression.getLineNumber();
        if (this.messages != null && n > 0) {
            String string = this.messages.getFileName();
            int n2 = this.messages.getLineNumber();
            int n3 = this.messages.getColumnNumber();
            this.messages.setLine(expression.getFileName(), n, expression.getColumnNumber());
            Expression expression2 = expression.walk(this);
            this.messages.setLine(string, n2, n3);
            return expression2;
        }
        return expression.walk(this);
    }

    protected Expression walkApplyExp(ApplyExp applyExp) {
        return this.walkExpression(applyExp);
    }

    protected Expression walkIfExp(IfExp ifExp) {
        return this.walkExpression(ifExp);
    }

    protected final void walkDeclarationType(Declaration declaration) {
        Expression expression;
        Expression expression2 = declaration.getTypeExp();
        if (expression2 != null && (expression = expression2.walk(this)) != expression2) {
            declaration.setTypeExp(expression);
        }
    }

    protected final void walkDeclarationTypes(ScopeExp scopeExp) {
        for (Declaration declaration = scopeExp.firstDecl(); declaration != null; declaration = declaration.nextDecl()) {
            this.walkDeclarationType(declaration);
        }
    }

    protected Expression walkScopeExp(ScopeExp scopeExp) {
        this.walkDeclarationTypes(scopeExp);
        return this.walkExpression(scopeExp);
    }

    protected Expression walkLetExp(LetExp letExp) {
        return this.walkScopeExp(letExp);
    }

    protected Expression walkLambdaExp(LambdaExp lambdaExp) {
        return this.walkScopeExp(lambdaExp);
    }

    protected Expression walkClassExp(ClassExp classExp) {
        return this.walkLambdaExp(classExp);
    }

    protected Expression walkObjectExp(ObjectExp objectExp) {
        return this.walkClassExp(objectExp);
    }

    protected Expression walkModuleExp(ModuleExp moduleExp) {
        return this.walkLambdaExp(moduleExp);
    }

    protected Expression walkSetExp(SetExp setExp) {
        Declaration declaration = setExp.binding;
        boolean bl = declaration != null && declaration.value == setExp.new_value;
        Expression expression = this.walkExpression(setExp);
        if (bl && setExp.isDefining()) {
            declaration.value = setExp.new_value;
            if (setExp.new_value instanceof LambdaExp) {
                ((LambdaExp)setExp.new_value).nameDecl = declaration;
            }
        }
        return expression;
    }

    protected Expression walkTryExp(TryExp tryExp) {
        return this.walkExpression(tryExp);
    }

    protected Expression walkBeginExp(BeginExp beginExp) {
        return this.walkExpression(beginExp);
    }

    protected Expression walkQuoteExp(QuoteExp quoteExp) {
        return this.walkExpression(quoteExp);
    }

    protected Expression walkReferenceExp(ReferenceExp referenceExp) {
        return this.walkExpression(referenceExp);
    }

    protected Expression walkThisExp(ThisExp thisExp) {
        return this.walkReferenceExp(thisExp);
    }

    protected Expression walkSynchronizedExp(SynchronizedExp synchronizedExp) {
        return this.walkExpression(synchronizedExp);
    }

    protected Expression walkBlockExp(BlockExp blockExp) {
        return this.walkExpression(blockExp);
    }

    protected Expression walkExitExp(ExitExp exitExp) {
        return this.walkExpression(exitExp);
    }

    protected Expression walkFluidLetExp(FluidLetExp fluidLetExp) {
        return this.walkLetExp(fluidLetExp);
    }

    protected Expression walkLangExp(LangExp langExp) {
        return this.walkExpression(langExp);
    }

    public Object getExitValue() {
        return this.exitValue;
    }

    public final LambdaExp getCurrentLambda() {
        return this.currentLambda;
    }

    public Expression[] walkExps(Expression[] expressionArray) {
        return this.walkExps(expressionArray, expressionArray.length);
    }

    public Expression[] walkExps(Expression[] expressionArray, int n) {
        int n2;
        int n3;
        String string;
        if (this.messages != null) {
            string = this.messages.getFileName();
            n3 = this.messages.getLineNumber();
            n2 = this.messages.getColumnNumber();
        } else {
            string = null;
            n3 = 0;
            n2 = 0;
        }
        boolean bl = false;
        for (int i = 0; i < n && this.exitValue == null; ++i) {
            Expression expression = expressionArray[i];
            int n4 = expression.getLineNumber();
            if (this.messages != null && n4 > 0) {
                this.messages.setLine(expression.getFileName(), n4, expression.getColumnNumber());
                bl = true;
            } else if (bl) {
                this.messages.setLine(string, n3, n2);
                bl = false;
            }
            expressionArray[i] = this.walk(expression);
        }
        if (bl) {
            this.messages.setLine(string, n3, n2);
        }
        return expressionArray;
    }

    public void walkDefaultArgs(LambdaExp lambdaExp) {
        if (lambdaExp.defaultArgs != null) {
            lambdaExp.defaultArgs = this.walkExps(lambdaExp.defaultArgs);
        }
    }

    public void error(char c, String string) {
        if (c == 'w' && this.comp.getBooleanOption("warn-as-error", false)) {
            c = (char)101;
        }
        if (this.messages != null) {
            this.messages.error(c, string);
        } else {
            new Error("internal error: " + string);
        }
    }

    public Expression noteError(String string) {
        if (this.messages != null) {
            this.messages.error('e', string);
        }
        return new ErrorExp(string);
    }

    public final String getFileName() {
        return this.messages.getFileName();
    }

    public final int getLineNumber() {
        return this.messages.getLineNumber();
    }

    public final int getColumnNumber() {
        return this.messages.getColumnNumber();
    }

    public String getPublicId() {
        return this.messages.getPublicId();
    }

    public String getSystemId() {
        return this.messages.getSystemId();
    }

    public boolean isStableSourceLocation() {
        return false;
    }

    public void setFile(String string) {
        this.messages.setFile(string);
    }

    public void setLine(int n) {
        this.messages.setLine(n);
    }

    public void setColumn(int n) {
        this.messages.setColumn(n);
    }

    public void setLine(String string, int n, int n2) {
        this.messages.setLine(string, n, n2);
    }
}

