/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Type;
import gnu.expr.BlockExitException;
import gnu.expr.BlockExp;
import gnu.expr.Compilation;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.QuoteExp;
import gnu.expr.Target;
import gnu.kawa.util.IdentityHashTable;
import gnu.mapping.CallContext;
import gnu.mapping.OutPort;

public class ExitExp
extends Expression {
    BlockExp block;
    Expression result;

    public ExitExp(Expression expression, BlockExp blockExp) {
        this.result = expression;
        this.block = blockExp;
    }

    public ExitExp(BlockExp blockExp) {
        this.result = QuoteExp.voidExp;
        this.block = blockExp;
    }

    protected boolean mustCompile() {
        return false;
    }

    public void apply(CallContext callContext) throws Throwable {
        throw new BlockExitException(this, this.result.eval(callContext));
    }

    public void compile(Compilation compilation, Target target) {
        CodeAttr codeAttr = compilation.getCode();
        Expression expression = this.result == null ? QuoteExp.voidExp : this.result;
        expression.compileWithPosition(compilation, this.block.exitTarget);
        this.block.exitableBlock.exit();
    }

    protected Expression deepCopy(IdentityHashTable identityHashTable) {
        Expression expression = ExitExp.deepCopy(this.result, identityHashTable);
        if (expression == null && this.result != null) {
            return null;
        }
        Object v = identityHashTable.get(this.block);
        ExitExp exitExp = new ExitExp(expression, v == null ? this.block : (BlockExp)v);
        exitExp.flags = this.getFlags();
        return exitExp;
    }

    protected Expression walk(ExpWalker expWalker) {
        return expWalker.walkExitExp(this);
    }

    protected void walkChildren(ExpWalker expWalker) {
        this.result = expWalker.walk(this.result);
    }

    public void print(OutPort outPort) {
        outPort.startLogicalBlock("(Exit", false, ")");
        outPort.writeSpaceFill();
        if (this.block == null || this.block.label == null) {
            outPort.print("<unknown>");
        } else {
            outPort.print(this.block.label.getName());
        }
        if (this.result != null) {
            outPort.writeSpaceLinear();
            this.result.print(outPort);
        }
        outPort.endLogicalBlock(")");
    }

    public Type getType() {
        return Type.neverReturnsType;
    }
}

