/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.CodeAttr;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Initializer;
import gnu.expr.LambdaExp;
import gnu.expr.Target;

public class ClassInitializer
extends Initializer {
    ClassExp cexp;

    public ClassInitializer(ClassExp classExp, Compilation compilation) {
        this.field = classExp.allocFieldFor(compilation);
        classExp.compileMembers(compilation);
        this.cexp = classExp;
        if (this.field.getStaticFlag()) {
            this.next = compilation.clinitChain;
            compilation.clinitChain = this;
        } else {
            LambdaExp lambdaExp = classExp.getOwningLambda();
            this.next = lambdaExp.initChain;
            lambdaExp.initChain = this;
        }
    }

    public void emit(Compilation compilation) {
        CodeAttr codeAttr = compilation.getCode();
        if (!this.field.getStaticFlag()) {
            codeAttr.emitPushThis();
        }
        this.cexp.compilePushClass(compilation, Target.pushValue(Compilation.typeClassType));
        if (this.field.getStaticFlag()) {
            codeAttr.emitPutStatic(this.field);
        } else {
            codeAttr.emitPutField(this.field);
        }
    }
}

