/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.FluidLetExp;
import gnu.expr.LambdaExp;
import gnu.expr.LetExp;
import gnu.expr.ModuleExp;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.SetExp;
import gnu.expr.ThisExp;
import gnu.mapping.EnvironmentKey;
import gnu.mapping.KeyPair;
import gnu.mapping.Symbol;
import java.io.Externalizable;
import java.util.Hashtable;

public class FindCapturedVars
extends ExpWalker {
    Hashtable unknownDecls = null;
    ModuleExp currentModule = null;

    public static void findCapturedVars(Expression expression, Compilation compilation) {
        FindCapturedVars findCapturedVars = new FindCapturedVars();
        findCapturedVars.setContext(compilation);
        expression.walk(findCapturedVars);
    }

    protected Expression walkApplyExp(ApplyExp applyExp) {
        Expression expression;
        Declaration declaration;
        boolean bl = false;
        if (applyExp.func instanceof ReferenceExp && Compilation.defaultCallConvention <= 1 && (declaration = Declaration.followAliases(((ReferenceExp)applyExp.func).binding)) != null && declaration.context instanceof ModuleExp && !declaration.getFlag(4096) && (expression = declaration.getValue()) instanceof LambdaExp) {
            LambdaExp lambdaExp = (LambdaExp)expression;
            LambdaExp lambdaExp2 = this.getCurrentLambda();
            if (!lambdaExp.getNeedsClosureEnv()) {
                bl = true;
            }
        }
        if (!bl) {
            applyExp.func = applyExp.func.walk(this);
        }
        if (this.exitValue == null) {
            applyExp.args = this.walkExps(applyExp.args);
        }
        return applyExp;
    }

    public void walkDefaultArgs(LambdaExp lambdaExp) {
        if (lambdaExp.defaultArgs == null) {
            return;
        }
        super.walkDefaultArgs(lambdaExp);
        for (Declaration declaration = lambdaExp.firstDecl(); declaration != null; declaration = declaration.nextDecl()) {
            if (declaration.isSimple()) continue;
            lambdaExp.setFlag(true, 512);
            break;
        }
    }

    protected Expression walkClassExp(ClassExp classExp) {
        Expression expression = super.walkClassExp(classExp);
        if (!classExp.explicitInit && !classExp.getNeedsClosureEnv()) {
            Compilation.getConstructor(classExp.instanceType, classExp);
        }
        return expression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expression walkModuleExp(ModuleExp moduleExp) {
        ModuleExp moduleExp2 = this.currentModule;
        Hashtable hashtable = this.unknownDecls;
        this.currentModule = moduleExp;
        this.unknownDecls = null;
        try {
            Expression expression = this.walkLambdaExp(moduleExp);
            return expression;
        }
        finally {
            this.currentModule = moduleExp2;
            this.unknownDecls = hashtable;
        }
    }

    protected Expression walkFluidLetExp(FluidLetExp fluidLetExp) {
        for (Declaration declaration = fluidLetExp.firstDecl(); declaration != null; declaration = declaration.nextDecl()) {
            if (declaration.base != null) continue;
            Declaration declaration2 = this.allocUnboundDecl(declaration.getSymbol(), false);
            this.capture(declaration2);
            declaration.base = declaration2;
        }
        return super.walkLetExp(fluidLetExp);
    }

    protected Expression walkLetExp(LetExp letExp) {
        if (letExp.body instanceof BeginExp) {
            Expression[] expressionArray = letExp.inits;
            int n = expressionArray.length;
            Expression[] expressionArray2 = ((BeginExp)letExp.body).exps;
            int n2 = 0;
            Declaration declaration = letExp.firstDecl();
            for (int i = 0; i < expressionArray2.length && n2 < n; ++i) {
                Expression expression = expressionArray2[i];
                if (!(expression instanceof SetExp)) continue;
                SetExp setExp = (SetExp)expression;
                if (setExp.binding != declaration || expressionArray[n2] != QuoteExp.nullExp || !setExp.isDefining()) continue;
                Expression expression2 = setExp.new_value;
                if ((expression2 instanceof QuoteExp || expression2 instanceof LambdaExp) && declaration.getValue() == expression2) {
                    expressionArray[n2] = expression2;
                    expressionArray2[i] = QuoteExp.voidExp;
                }
                ++n2;
                declaration = declaration.nextDecl();
            }
        }
        return super.walkLetExp(letExp);
    }

    public void capture(Declaration declaration) {
        LambdaExp lambdaExp;
        Expression expression;
        Expression expression2;
        if (!declaration.getCanRead() && !declaration.getCanCall()) {
            return;
        }
        if (declaration.field != null && declaration.field.getStaticFlag()) {
            return;
        }
        LambdaExp lambdaExp2 = this.getCurrentLambda();
        LambdaExp lambdaExp3 = declaration.getContext().currentLambda();
        Expression expression3 = null;
        LambdaExp lambdaExp4 = null;
        while (lambdaExp2 != lambdaExp3 && lambdaExp2.getInlineOnly()) {
            expression2 = lambdaExp2.outerLambda();
            if (expression2 != expression3) {
                lambdaExp4 = expression2.firstChild;
                expression3 = expression2;
            }
            expression = lambdaExp2.returnContinuation;
            if (lambdaExp4 == null || expression == null) {
                lambdaExp2.setCanCall(false);
                return;
            }
            lambdaExp2 = ((ApplyExp)expression).context;
            lambdaExp4 = lambdaExp4.nextSibling;
        }
        if (this.comp.usingCPStyle() ? lambdaExp2 instanceof ModuleExp : lambdaExp2 == lambdaExp3) {
            return;
        }
        expression2 = declaration.getValue();
        if (expression2 == null || !(expression2 instanceof LambdaExp)) {
            expression = null;
        } else {
            expression = expression2;
            if (((LambdaExp)expression).getInlineOnly()) {
                return;
            }
            if (((LambdaExp)expression).isHandlingTailCalls()) {
                expression = null;
            } else if (expression == lambdaExp2 && !declaration.getCanRead()) {
                return;
            }
        }
        if (declaration.getFlag(65536)) {
            for (lambdaExp = lambdaExp2; lambdaExp != lambdaExp3; lambdaExp = lambdaExp.outerLambda()) {
                if (lambdaExp.nameDecl == null || !lambdaExp.nameDecl.getFlag(2048)) continue;
                declaration.setFlag(2048);
                break;
            }
        }
        if (declaration.base != null) {
            declaration.base.setCanRead(true);
            this.capture(declaration.base);
        } else if (declaration.getCanRead() || expression == null) {
            if (!declaration.isStatic()) {
                LambdaExp lambdaExp5;
                lambdaExp = lambdaExp2;
                lambdaExp.setImportsLexVars();
                LambdaExp lambdaExp6 = lambdaExp5 = lambdaExp.outerLambda();
                while (lambdaExp6 != lambdaExp3 && lambdaExp6 != null) {
                    lambdaExp = lambdaExp6;
                    if (!declaration.getCanRead() && expression == lambdaExp6) break;
                    Declaration declaration2 = lambdaExp.nameDecl;
                    if (declaration2 != null && declaration2.getFlag(2048)) {
                        this.comp.error('e', "static " + lambdaExp.getName() + " references non-static " + declaration.getName());
                    }
                    lambdaExp.setNeedsStaticLink();
                    lambdaExp6 = lambdaExp.outerLambda();
                }
            }
            lambdaExp3.capture(declaration);
        }
    }

    Declaration allocUnboundDecl(Object object2, boolean bl) {
        Declaration declaration;
        Object object3 = object2;
        if (bl && object2 instanceof Symbol) {
            if (!this.getCompilation().getLanguage().hasSeparateFunctionNamespace()) {
                bl = false;
            } else {
                object3 = new KeyPair((Symbol)object2, EnvironmentKey.FUNCTION);
            }
        }
        if (this.unknownDecls == null) {
            this.unknownDecls = new Hashtable(100);
            declaration = null;
        } else {
            declaration = (Declaration)this.unknownDecls.get(object3);
        }
        if (declaration == null) {
            declaration = this.currentModule.addDeclaration(object2);
            declaration.setSimple(false);
            declaration.setPrivate(true);
            if (bl) {
                declaration.setProcedureDecl(true);
            }
            if (this.currentModule.isStatic()) {
                declaration.setFlag(2048);
            }
            declaration.setCanRead(true);
            declaration.setFlag(65536);
            declaration.setIndirectBinding(true);
            this.unknownDecls.put(object3, declaration);
        }
        return declaration;
    }

    protected Expression walkReferenceExp(ReferenceExp referenceExp) {
        Declaration declaration = referenceExp.getBinding();
        if (declaration == null) {
            declaration = this.allocUnboundDecl(referenceExp.getSymbol(), referenceExp.isProcedureName());
            referenceExp.setBinding(declaration);
        }
        if (declaration.getFlag(65536)) {
            Object object2;
            Type type = this.getCompilation().getLanguage().getTypeFor(referenceExp);
            if (type instanceof Externalizable && !referenceExp.getDontDereference()) {
                return new QuoteExp(type);
            }
            if (this.comp.getBooleanOption("warn-undefined-variable", false) && (object2 = this.comp.resolve(referenceExp.getSymbol(), referenceExp.isProcedureName())) == null) {
                this.comp.error('w', "no declaration seen for " + referenceExp.getName());
            }
        }
        this.capture(referenceExp.contextDecl(), declaration);
        return referenceExp;
    }

    void capture(Declaration declaration, Declaration declaration2) {
        if (declaration2.isAlias() && declaration2.value instanceof ReferenceExp) {
            ReferenceExp referenceExp = (ReferenceExp)declaration2.value;
            Declaration declaration3 = referenceExp.binding;
            if (!(declaration3 == null || declaration != null && declaration3.needsContext())) {
                this.capture(referenceExp.contextDecl(), declaration3);
                return;
            }
        }
        if (declaration != null && declaration2.needsContext()) {
            this.capture(declaration);
        } else {
            this.capture(declaration2);
        }
    }

    protected Expression walkThisExp(ThisExp thisExp) {
        if (thisExp.isForContext()) {
            this.getCurrentLambda().setImportsLexVars();
            return thisExp;
        }
        return this.walkReferenceExp(thisExp);
    }

    protected Expression walkSetExp(SetExp setExp) {
        Declaration declaration = setExp.binding;
        if (declaration == null) {
            setExp.binding = declaration = this.allocUnboundDecl(setExp.getSymbol(), setExp.isFuncDef());
        }
        if (!declaration.ignorable()) {
            if (!setExp.isDefining()) {
                declaration = Declaration.followAliases(declaration);
            }
            this.capture(setExp.contextDecl(), declaration);
        }
        return super.walkSetExp(setExp);
    }
}

