/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.Attribute;
import gnu.bytecode.ClassType;
import gnu.bytecode.ClassTypeWriter;
import gnu.bytecode.ConstantPool;
import gnu.bytecode.SourceFileAttr;
import java.io.DataOutputStream;
import java.io.IOException;

public class SourceDebugExtAttr
extends Attribute {
    byte[] data;
    int dlength;
    private String outputFileName;
    private String defaultStratumId;
    int fileCount;
    int[] fileIDs;
    String[] fileNames;
    int lineCount;
    int[] lines;
    int curLineIndex = -1;
    int curFileIndex = -1;
    int maxFileID;
    String curFileName;

    private int fixLine(int n, int n2) {
        int n3;
        int n4 = this.lines[n2];
        int n5 = this.lines[n2 + 2];
        if (n < n4) {
            if (n2 > 0) {
                return -1;
            }
            n3 = n4 + n5 - 1;
            this.lines[n2] = n;
            this.lines[n2 + 2] = n3 - n + 1;
            this.lines[n2 + 3] = n;
            n4 = n;
        }
        n3 = this.lines[n2 + 3] - n4;
        if (n < n4 + n5) {
            return n + n3;
        }
        if (n2 == 5 * (this.lineCount - 1) || n2 == 0 && n < this.lines[8]) {
            this.lines[n2 + 2] = n - n4 + 1;
            return n + n3;
        }
        return -1;
    }

    int fixLine(int n) {
        int n2;
        int n3;
        if (this.curLineIndex >= 0 && (n3 = this.fixLine(n, this.curLineIndex)) >= 0) {
            return n3;
        }
        int n4 = 0;
        int n5 = this.curFileIndex;
        for (n2 = 0; n2 < this.lineCount; ++n2) {
            if (n4 != this.curLineIndex && n5 == this.lines[n4 + 1] && (n3 = this.fixLine(n, n4)) >= 0) {
                this.curLineIndex = n4;
                return n3;
            }
            n4 += 5;
        }
        if (this.lines == null) {
            this.lines = new int[20];
        } else if (n4 >= this.lines.length) {
            int[] nArray = new int[2 * n4];
            System.arraycopy(this.lines, 0, nArray, 0, n4);
            this.lines = nArray;
        }
        int n6 = n;
        if (n4 == 0) {
            n2 = n;
        } else {
            n2 = this.lines[n4 - 5 + 3] + this.lines[n4 - 5 + 2];
            if (n4 == 5 && n2 < 10000) {
                n2 = 10000;
            }
            n = n2;
        }
        this.lines[n4] = n6;
        this.lines[n4 + 1] = n5;
        this.lines[n4 + 2] = 1;
        this.lines[n4 + 3] = n2;
        this.lines[n4 + 4] = 1;
        this.curLineIndex = n4;
        ++this.lineCount;
        return n;
    }

    void addFile(String string) {
        int n;
        String string2;
        if (this.curFileName == string || string != null && string.equals(this.curFileName)) {
            return;
        }
        this.curFileName = string;
        int n2 = (string = SourceFileAttr.fixSourceFile(string)).lastIndexOf(47);
        if (n2 >= 0) {
            String string3 = string;
            string = string.substring(n2 + 1);
            string2 = string + '\n' + string3;
        } else {
            string2 = string;
        }
        if (this.curFileIndex >= 0 && string2.equals(this.fileNames[this.curFileIndex])) {
            return;
        }
        int n3 = this.fileCount;
        for (n = 0; n < n3; ++n) {
            if (n == this.curFileIndex || !string2.equals(this.fileNames[n])) continue;
            this.curFileIndex = n;
            this.curLineIndex = -1;
            return;
        }
        if (this.fileIDs == null) {
            this.fileIDs = new int[5];
            this.fileNames = new String[5];
        } else if (n3 >= this.fileIDs.length) {
            int[] nArray = new int[2 * n3];
            String[] stringArray = new String[2 * n3];
            System.arraycopy(this.fileIDs, 0, nArray, 0, n3);
            System.arraycopy(this.fileNames, 0, stringArray, 0, n3);
            this.fileIDs = nArray;
            this.fileNames = stringArray;
        }
        ++this.fileCount;
        n = ++this.maxFileID;
        n <<= 1;
        if (n2 >= 0) {
            ++n;
        }
        this.fileNames[n3] = string2;
        if (this.outputFileName == null) {
            this.outputFileName = string;
        }
        this.fileIDs[n3] = n;
        this.curFileIndex = n3;
        this.curLineIndex = -1;
    }

    public void addStratum(String string) {
        this.defaultStratumId = string;
    }

    public SourceDebugExtAttr(ClassType classType) {
        super("SourceDebugExtension");
        this.addToFrontOf(classType);
    }

    void nonAsteriskString(String string, StringBuffer stringBuffer) {
        if (string == null || string.length() == 0 || string.charAt(0) == '*') {
            stringBuffer.append(' ');
        }
        stringBuffer.append(string);
    }

    public void assignConstants(ClassType classType) {
        int n;
        int n2;
        int n3;
        super.assignConstants(classType);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SMAP\n");
        this.nonAsteriskString(this.outputFileName, stringBuffer);
        stringBuffer.append('\n');
        String string = this.defaultStratumId == null ? "Java" : this.defaultStratumId;
        this.nonAsteriskString(string, stringBuffer);
        stringBuffer.append('\n');
        stringBuffer.append("*S ");
        stringBuffer.append(string);
        stringBuffer.append('\n');
        stringBuffer.append("*F\n");
        for (n3 = 0; n3 < this.fileCount; ++n3) {
            n2 = this.fileIDs[n3];
            n = (n2 & 1) != 0 ? 1 : 0;
            n2 >>= 1;
            if (n != 0) {
                stringBuffer.append("+ ");
            }
            stringBuffer.append(n2);
            stringBuffer.append(' ');
            stringBuffer.append(this.fileNames[n3]);
            stringBuffer.append('\n');
        }
        if (this.lineCount > 0) {
            n3 = 0;
            stringBuffer.append("*L\n");
            n2 = 0;
            n = 0;
            do {
                int n4 = this.lines[n];
                int n5 = this.fileIDs[this.lines[n + 1]] >> 1;
                int n6 = this.lines[n + 2];
                int n7 = this.lines[n + 3];
                int n8 = this.lines[n + 4];
                stringBuffer.append(n4);
                if (n5 != n3) {
                    stringBuffer.append('#');
                    stringBuffer.append(n5);
                    n3 = n5;
                }
                if (n6 != 1) {
                    stringBuffer.append(',');
                    stringBuffer.append(n6);
                }
                stringBuffer.append(':');
                stringBuffer.append(n7);
                if (n8 != 1) {
                    stringBuffer.append(',');
                    stringBuffer.append(n8);
                }
                stringBuffer.append('\n');
                n += 5;
            } while (++n2 < this.lineCount);
        }
        stringBuffer.append("*E\n");
        try {
            this.data = stringBuffer.toString().getBytes("UTF-8");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        this.dlength = this.data.length;
    }

    public int getLength() {
        return this.dlength;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.write(this.data, 0, this.dlength);
    }

    public void print(ClassTypeWriter classTypeWriter) {
        ClassType classType = (ClassType)this.container;
        ConstantPool constantPool = classType.getConstants();
        classTypeWriter.print("Attribute \"");
        classTypeWriter.print(this.getName());
        classTypeWriter.print("\", length:");
        classTypeWriter.println(this.dlength);
        try {
            classTypeWriter.print(new String(this.data, 0, this.dlength, "UTF-8"));
        }
        catch (Exception exception) {
            classTypeWriter.print("(Caught ");
            classTypeWriter.print(exception);
            classTypeWriter.println(')');
        }
        if (this.dlength > 0 && this.data[this.dlength - 1] != 13 && this.data[this.dlength - 1] != 10) {
            classTypeWriter.println();
        }
    }
}

