/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.buffer;

import gnu.lists.CharBuffer;
import gnu.mapping.InPort;
import gnu.text.NullReader;
import java.io.IOException;

public class BufferReader
extends InPort {
    CharBuffer content;
    int rangeStart;
    int rangeLength;

    public BufferReader(CharBuffer content, String name, int start, int count) {
        super(NullReader.nullReader, (Object)name);
        this.content = content;
        this.buffer = content.getArray();
        this.rangeStart = start;
        this.rangeLength = count;
        if (start < content.gapStart) {
            this.pos = start;
            this.limit = start + count;
            if (this.limit > content.gapStart) {
                this.limit = content.gapStart;
            }
        } else {
            int gapSize = content.gapEnd - content.gapStart;
            this.pos = start + gapSize;
            int length = content.getArray().length;
            this.limit = this.pos + count > length ? length : this.pos + count;
        }
    }

    public int read() {
        if (this.pos < this.limit) {
            return this.buffer[this.pos++];
        }
        if (this.limit == this.content.gapStart) {
            int gapSize = this.content.gapEnd - this.content.gapStart;
            this.pos = this.content.gapEnd;
            int count = this.rangeLength - (this.content.gapStart - this.rangeStart);
            int length = this.content.getArray().length;
            int n = this.limit = this.pos + count > length ? length : this.pos + count;
            if (this.pos < this.limit) {
                return this.buffer[this.pos++];
            }
        }
        return -1;
    }

    public void reset() throws IOException {
        if (this.readAheadLimit <= 0) {
            throw new IOException("mark invalid");
        }
        if (this.pos >= this.content.gapEnd && this.markPos <= this.content.gapStart) {
            this.limit = this.content.gapEnd;
        }
        this.pos = this.markPos;
        this.readAheadLimit = 0;
    }

    public int getLineNumber() {
        throw new Error("BufferReader.getLineNumber - not implemented");
    }

    public int getColumnNumber() {
        throw new Error("BufferReader.getColumnNumber - not implemented");
    }
}

