/*
 * Decompiled with CFR 0.152.
 */
package gnu.commonlisp.lisp;

import gnu.commonlisp.lang.CommonLisp;
import gnu.commonlisp.lang.Symbols;
import gnu.expr.Interpreter;
import gnu.expr.ModuleBody;
import gnu.expr.ModuleMethod;
import gnu.kawa.functions.AddOp;
import gnu.kawa.functions.Apply;
import gnu.kawa.functions.NumberCompare;
import gnu.lists.FString;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.lists.Sequence;
import gnu.lists.SimpleVector;
import gnu.mapping.Environment;
import gnu.mapping.Procedure;
import gnu.mapping.Symbol;
import gnu.mapping.WrongType;
import gnu.math.IntNum;
import kawa.lang.AnyPat;
import kawa.lang.EqualPat;
import kawa.lang.ListRepeatPat;
import kawa.lang.Macro;
import kawa.lang.PairPat;
import kawa.lang.SyntaxRule;
import kawa.lang.SyntaxRules;
import kawa.lib.lists;
import kawa.lib.misc;
import kawa.lib.strings;

public class PrimOps
extends ModuleBody {
    static final PrimOps $instance = new PrimOps();
    public static final ModuleMethod car;
    public static final ModuleMethod cdr;
    public static final ModuleMethod setcar;
    public static final ModuleMethod setcdr;
    public static final ModuleMethod boundp;
    public static final ModuleMethod symbolp;
    public static final ModuleMethod symbol$Mnname;
    public static final ModuleMethod plist$Mnget;
    public static final ModuleMethod plist$Mnput;
    public static final ModuleMethod plist$Mnremprop;
    public static final ModuleMethod plist$Mnmember;
    public static final ModuleMethod get;
    public static final ModuleMethod put;
    public static final ModuleMethod symbol$Mnvalue;
    public static final ModuleMethod set;
    public static final ModuleMethod symbol$Mnfunction;
    public static final ModuleMethod fset;
    public static final ModuleMethod apply;
    public static final Macro prog1;
    public static final ModuleMethod length;
    public static final ModuleMethod arrayp;
    public static final ModuleMethod aref;
    public static final ModuleMethod aset;
    public static final ModuleMethod fillarray;
    public static final ModuleMethod stringp;
    public static final ModuleMethod make$Mnstring;
    public static final ModuleMethod substring;
    public static final ModuleMethod char$Mnto$Mnstring;
    static final IntNum Lit0;

    /*
     * Enabled aggressive block sorting
     */
    static {
        Lit0 = IntNum.make(0);
        prog1 = Macro.make("prog1", new SyntaxRules((Object[])new String[]{"prog1"}, new SyntaxRule[]{new SyntaxRule(PairPat.make(AnyPat.make(), EqualPat.make(LList.Empty)), "\u0000", "\u0005", new Object[0], 0), new SyntaxRule(PairPat.make(AnyPat.make(), ListRepeatPat.make(AnyPat.make())), "\u0000\u0001", "\t\u0002\u0006\u0003\u0007\u0004\u000b\u0001\u0001\u0005\u0002\t\u0001\u0002\u0001\r\u0001", new Object[]{LList.Empty}, 1)}, 5), new String[]{"%prog1-save%", "begin", "let"}, ";;;");
        car = new ModuleMethod($instance, 11, "car", 4097);
        cdr = new ModuleMethod($instance, 10, "cdr", 4097);
        setcar = new ModuleMethod($instance, 23, "setcar", 8194);
        setcdr = new ModuleMethod($instance, 22, "setcdr", 8194);
        boundp = new ModuleMethod($instance, 9, "boundp", 4097);
        symbolp = new ModuleMethod($instance, 8, "symbolp", 4097);
        symbol$Mnname = new ModuleMethod($instance, 7, "symbol-name", 4097);
        plist$Mnget = new ModuleMethod($instance, 21, "plist-get", 12290);
        plist$Mnput = new ModuleMethod($instance, 26, "plist-put", 12291);
        plist$Mnremprop = new ModuleMethod($instance, 20, "plist-remprop", 8194);
        plist$Mnmember = new ModuleMethod($instance, 19, "plist-member", 8194);
        get = new ModuleMethod($instance, 18, "get", 12290);
        put = new ModuleMethod($instance, 25, "put", 12291);
        symbol$Mnvalue = new ModuleMethod($instance, 6, "symbol-value", 4097);
        set = new ModuleMethod($instance, 17, "set", 8194);
        symbol$Mnfunction = new ModuleMethod($instance, 5, "symbol-function", 4097);
        fset = new ModuleMethod($instance, 16, "fset", 8194);
        apply = new ModuleMethod($instance, 27, "apply", -4095);
        length = new ModuleMethod($instance, 4, "length", 4097);
        arrayp = new ModuleMethod($instance, 3, "arrayp", 4097);
        aref = new ModuleMethod($instance, 15, "aref", 8194);
        aset = new ModuleMethod($instance, 24, "aset", 12291);
        fillarray = new ModuleMethod($instance, 14, "fillarray", 8194);
        stringp = new ModuleMethod($instance, 2, "stringp", 4097);
        make$Mnstring = new ModuleMethod($instance, 13, "make-string", 8194);
        substring = new ModuleMethod($instance, 12, "substring", 12290);
        char$Mnto$Mnstring = new ModuleMethod($instance, 1, "char-to-string", 4097);
    }

    public static Object car(Object x) {
        return x == LList.Empty ? x : ((Pair)x).car;
    }

    public static Object cdr(Object x) {
        return x == LList.Empty ? x : ((Pair)x).cdr;
    }

    public static void setcar(Pair p, Object x) {
        lists.setCar$Ex(p, x);
    }

    public static void setcdr(Pair p, Object x) {
        lists.setCdr$Ex(p, x);
    }

    public static boolean boundp(Object symbol) {
        return Symbols.isBound(symbol);
    }

    public static boolean symbolp(Object x) {
        return Symbols.isSymbol(x);
    }

    public static Object symbolName(Object symbol) {
        return Symbols.getPrintName(symbol);
    }

    public static Object plistGet(Object object2, Object object3) {
        return PrimOps.plistGet(object2, object3, Boolean.FALSE);
    }

    public static Object plistGet(Object plist, Object prop, Object object2) {
        return Symbols.plistGet(plist, prop, object2);
    }

    public static Object plistPut(Object plist, Object prop, Object value) {
        return Symbols.plistPut(plist, prop, value);
    }

    public static Object plistRemprop(Object plist, Object prop) {
        return Symbols.plistRemove(plist, prop);
    }

    public static Object plistMember(Object plist, Object prop) {
        return Symbols.plistGet(plist, prop, Interpreter.voidObject) == Interpreter.voidObject ? LList.Empty : "t";
    }

    public static Object get(Symbol symbol, Object object2) {
        return PrimOps.get(symbol, object2, LList.Empty);
    }

    public static Object get(Symbol symbol, Object property, Object object2) {
        return symbol.getProperty(property, object2);
    }

    public static void put(Symbol symbol, Object property, Object value) {
        symbol.setProperty(property, value);
    }

    public static Object symbolValue(Object sym) {
        return Symbols.getSymbol(sym).get();
    }

    public static void set(Object symbol, Object value) {
        Symbols.setValueBinding(symbol, value);
    }

    public static Object symbolFunction(Object symbol) {
        return Symbols.getFunctionBinding(symbol);
    }

    public static void fset(Object symbol, Object object2) {
        Symbols.setFunctionBinding(Environment.getCurrent(), symbol, object2);
    }

    public static Object apply$V(Object func, Object[] args) {
        return Apply.applyN(misc.isSymbol(func) ? (Procedure)PrimOps.symbolFunction(func) : (Procedure)func, args);
    }

    public static int length(Sequence x) {
        return x.size();
    }

    public static boolean arrayp(Object x) {
        return x instanceof SimpleVector;
    }

    public static Object aref(SimpleVector array, int k) {
        return array.get(k);
    }

    public static Object aset(SimpleVector array, int k, Object obj) {
        array.set(k, obj);
        return obj;
    }

    public static Object fillarray(SimpleVector array, Object obj) {
        array.fill(obj);
        return obj;
    }

    public static boolean stringp(Object x) {
        return x instanceof FString;
    }

    public static FString makeString(int count, Object ch) {
        return new FString(count, CommonLisp.asChar(ch));
    }

    public static FString substring(FString fString, Object object2) {
        return PrimOps.substring(fString, object2, LList.Empty);
    }

    public static FString substring(FString str, Object from, Object to) {
        int n;
        if (to == LList.Empty) {
            to = IntNum.make(strings.stringLength(str));
        }
        if (((Procedure)NumberCompare.$Ls).apply2(to, Lit0) != Boolean.FALSE) {
            to = ((Procedure)AddOp.$Mn).apply2(IntNum.make(strings.stringLength(str)), to);
        }
        if (((Procedure)NumberCompare.$Ls).apply2(from, Lit0) != Boolean.FALSE) {
            from = ((Procedure)AddOp.$Mn).apply2(IntNum.make(strings.stringLength(str)), from);
        }
        try {
            n = ((Number)from).intValue();
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "gnu.lists.FString.copy(int,int)", 1);
        }
        try {
            return str.copy(n, ((Number)to).intValue());
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "gnu.lists.FString.copy(int,int)", 2);
        }
    }

    public static FString charToString(Object ch) {
        return new FString(1, CommonLisp.asChar(ch));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object apply1(ModuleMethod moduleMethod, Object object2) {
        switch (moduleMethod.selector) {
            case 1: {
                return PrimOps.charToString(object2);
            }
            case 2: {
                if (PrimOps.stringp(object2)) {
                    return "t";
                }
                LList lList = LList.Empty;
                return lList;
            }
            case 3: {
                if (PrimOps.arrayp(object2)) {
                    return "t";
                }
                LList lList = LList.Empty;
                return lList;
            }
            case 4: {
                return IntNum.make(PrimOps.length((Sequence)object2));
            }
            case 5: {
                return PrimOps.symbolFunction(object2);
            }
            case 6: {
                return PrimOps.symbolValue(object2);
            }
            case 7: {
                return PrimOps.symbolName(object2);
            }
            case 8: {
                if (PrimOps.symbolp(object2)) {
                    return "t";
                }
                LList lList = LList.Empty;
                return lList;
            }
            case 9: {
                if (PrimOps.boundp(object2)) {
                    return "t";
                }
                LList lList = LList.Empty;
                return lList;
            }
            case 10: {
                return PrimOps.cdr(object2);
            }
            case 11: {
                return PrimOps.car(object2);
            }
        }
        return super.apply1(moduleMethod, object2);
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "length", 0);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object apply2(ModuleMethod moduleMethod, Object object2, Object object3) {
        switch (moduleMethod.selector) {
            case 12: {
                return PrimOps.substring((FString)object2, object3);
            }
            case 13: {
                return PrimOps.makeString(((Number)object2).intValue(), object3);
            }
            case 14: {
                return PrimOps.fillarray((SimpleVector)object2, object3);
            }
            case 15: {
                SimpleVector simpleVector = (SimpleVector)object2;
                return PrimOps.aref(simpleVector, ((Number)object3).intValue());
            }
            case 16: {
                PrimOps.fset(object2, object3);
                return Interpreter.voidObject;
            }
            case 17: {
                PrimOps.set(object2, object3);
                return Interpreter.voidObject;
            }
            case 18: {
                return PrimOps.get((Symbol)object2, object3);
            }
            case 19: {
                return PrimOps.plistMember(object2, object3);
            }
            case 20: {
                return PrimOps.plistRemprop(object2, object3);
            }
            case 21: {
                return PrimOps.plistGet(object2, object3);
            }
            case 22: {
                PrimOps.setcdr((Pair)object2, object3);
                return Interpreter.voidObject;
            }
            case 23: {
                PrimOps.setcar((Pair)object2, object3);
                return Interpreter.voidObject;
            }
        }
        return super.apply2(moduleMethod, object2, object3);
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "setcar", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "setcdr", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "get", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "aref", 1);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "aref", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "fillarray", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "make-string", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "substring", 0);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object apply3(ModuleMethod moduleMethod, Object object2, Object object3, Object object4) {
        switch (moduleMethod.selector) {
            case 12: {
                return PrimOps.substring((FString)object2, object3, object4);
            }
            case 24: {
                SimpleVector simpleVector = (SimpleVector)object2;
                return PrimOps.aset(simpleVector, ((Number)object3).intValue(), object4);
            }
            case 25: {
                PrimOps.put((Symbol)object2, object3, object4);
                return Interpreter.voidObject;
            }
            case 18: {
                return PrimOps.get((Symbol)object2, object3, object4);
            }
            case 26: {
                return PrimOps.plistPut(object2, object3, object4);
            }
            case 21: {
                return PrimOps.plistGet(object2, object3, object4);
            }
        }
        return super.apply3(moduleMethod, object2, object3, object4);
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "get", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "put", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "aset", 1);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "aset", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "substring", 0);
        }
    }

    public Object applyN(ModuleMethod moduleMethod, Object[] objectArray) {
        if (moduleMethod.selector == 27) {
            Object object2 = objectArray[0];
            int n = objectArray.length - 1;
            Object[] objectArray2 = new Object[n];
            while (--n >= 0) {
                objectArray2 = objectArray2;
                objectArray2[n] = objectArray[n + 1];
            }
            return PrimOps.apply$V(object2, objectArray2);
        }
        return super.applyN(moduleMethod, objectArray);
    }
}

