
;;; search-for-ptr.el

;; Copyright (C) 2014-2015 Davin Pearson

;; Emacs Lisp Archive Entry
;; Filename: search-for-ptr.el
;; Author/Maintainer: Davin Pearson <http://davin.50webs.com>
;; Keywords:
;; Version: 1.0

;;; Commentary:

;; This file is not part of GNU Emacs.

;;; Limitation of Warranty

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or (at
;; your option) any later version.
;;
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs, see the file COPYING.  If not, see:
;;
;; <http://www.gnu.org/licenses/gpl-3.0.txt>.


;;; Known Bugs:

;; None so far!

;;; Code:

(setq s4p-buf "*ptr*")

(defun s4p--log-message (string)
  (save-excursion
    (set-buffer s4p-buf)
    (goto-char (point-max))
    (insert string "\n")))

(defun s4p--find-ptrs-in-current-buffer ()
  (interactive)
  (assert (eq major-mode 'c++-mode))
  (goto-char (point-min))
  (while (setq p (re-search-forward "(" nil t))
    (forward-char -1)
    (setq p-min (point))
    (forward-sexp 1)
    (setq p-max (point))
    ;;(setq bs (buffer-substring-no-properties p-min p-max))
    ;;(ptr--log-message bs)
    (goto-char p-min)
    (while (re-search-forward "[(,][ \t]*\\(ptr<[a-zA-Z0-9]*\\)" p-max t)
      (s4p--log-message (format "%s:%d: found: %s"
                                (buffer-file-name)
                                (d-what-line)
                                (buffer-substring-no-properties (match-beginning 1) (match-end 1)))))
    (goto-char p)))

(defun s4p--find-ptrs-in-file-list (list)
  (save-excursion
    (if (get-buffer s4p-buf)
        (kill-buffer s4p-buf))
    (generate-new-buffer s4p-buf)
    (setq ptr list)
    (while (car ptr)
      (find-file (car ptr))
      (s4p--find-ptrs-in-current-buffer)
      (kill-buffer nil)
      (setq ptr (cdr ptr))))
  (switch-to-buffer s4p-buf)
  (goto-char (point-min))
  (insert "\n\n") ;;; NOTE: needed for enter key to work
  (compilation-mode)
  (read-only-mode -1)
  )


;;; (setq file-list (directory-files-no-dotdotdot "~/3-autogc-nosplit/2007/r4" t "\\.\\(cc\\|ch\\|hh\\)$"))
;;; (setq file-list '("~/3-autogc-nosplit/2007/r4/a.cc"))
;;; (s4p--find-ptrs-in-file-list file-list)

;;foo(ptr<Avcc> foo,ptr<Deg> hello)
;;(what-line)
