;;; d-dabbrev.el --- Improved dabbrev functionality

;; Copyright (C) 2006-2015 Davin Pearson

;; Emacs Lisp Archive Entry
;; Filename: d-dabbrev.el
;; Author/Maintainer: Davin Pearson <http://davin.50webs.com>
;; Version: 1.0
;; Keywords: improved dabbrev

;;; Commentary:

;; This file is not part of GNU Emacs.

;; This code improves on the Emacs built in function dabbrev-expand.
;; The kill-ring, file-name-history, command-history,
;; minibuffer-history, search-ring, apropos-pattern-quoted,
;; buffer-list and deleted text are searched in addition to all
;; buffers in memory.

;;; m4_limitation_of_warranty

;;; m4_install_instructions(d-dabbrev)

;;; Known Bugs:

;; None!

;;; Code:

(add-hook 'java-mode-hook 'd-abbrev-java)

(defun d-abbrev-java ()
  (progn
    (define-abbrev java-mode-abbrev-table "SOP" "SYSTEM_OUT_PRINTLN")
    (define-abbrev java-mode-abbrev-table "sop" "System.out.println(")
    (define-abbrev java-mode-abbrev-table "soe" "System.exit(-1);")
    (define-abbrev global-abbrev-table "sop" "System.out.println(")
    )

  ;;(define-abbrev java-mode-abbrev-table "str" "String")
  (define-abbrev
    java-mode-abbrev-table
    "psvm"
    (concat "public static void main(String[] args)\n"
            (make-string c-basic-offset ? ) "{\n" (make-string (1- (* 2 c-basic-offset)) ? )))
  )

(add-hook 'find-file-hook 'd-turn-on-abbrev)

(defun d-turn-on-abbrev ()
  (if (eq major-mode 'java-mode)
      (abbrev-mode 1)))

;;; removes "Abbrev" from minor-mode-alist
(setcdr (assoc 'abbrev-mode minor-mode-alist) '(""))

(provide 'd-abbrev)
;;; d-abbrev.el ends here
