/* Copyright (C) 1995,1996,1997,1998, 1999, 2000 Free Software Foundation, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307 USA
 *
 * As a special exception, the Free Software Foundation gives permission
 * for additional uses of the text contained in its release of GUILE.
 *
 * The exception is that, if you link the GUILE library with other files
 * to produce an executable, this does not by itself cause the
 * resulting executable to be covered by the GNU General Public License.
 * Your use of that executable is in no way restricted on account of
 * linking the GUILE library code into it.
 *
 * This exception does not however invalidate any other reasons why
 * the executable file might be covered by the GNU General Public License.
 *
 * This exception applies only to the code released by the
 * Free Software Foundation under the name GUILE.  If you copy
 * code from other Free Software Foundation releases into a copy of
 * GUILE, as the General Public License permits, the exception does
 * not apply to the code that you add in this way.  To avoid misleading
 * anyone as to the status of such modified files, you must delete
 * this exception notice from them.
 *
 * If you write modifications of your own for GUILE, it is your choice
 * whether to permit this exception to apply to your modifications.
 * If you do not wish that, delete this exception notice.  */

/* Software engineering face-lift by Greg J. Badros, 11-Dec-1999,
   gjb@cs.washington.edu, http://www.cs.washington.edu/homes/gjb */



#include <stdio.h>
#include "libguile/_scm.h"
#include "libguile/ports.h"
#include "libguile/root.h"
#include "libguile/smob.h"
#include "libguile/vectors.h"

#include "libguile/validate.h"
#include "libguile/keywords.h"


static int
prin_keyword (SCM exp,SCM port,scm_print_state *pstate)
{
  scm_puts ("#:", port);
  scm_puts(1 + SCM_CHARS (SCM_CDR (exp)), port);
  return 1;
}

int scm_tc16_keyword;


SCM_DEFINE (scm_make_keyword_from_dash_symbol, "make-keyword-from-dash-symbol", 1, 0, 0, 
            (SCM symbol),
            "Return a keyword object from SYMBOL that starts with `-' (a dash).")
#define FUNC_NAME s_scm_make_keyword_from_dash_symbol
{
  SCM vcell;

  SCM_ASSERT (SCM_SYMBOLP (symbol)
	      && ('-' == SCM_CHARS(symbol)[0]),
	      symbol, SCM_ARG1, FUNC_NAME);

  SCM_DEFER_INTS;
  vcell = scm_sym2ovcell_soft (symbol, scm_keyword_obarray);
  if (SCM_FALSEP (vcell))
    {
      SCM keyword;
      SCM_NEWSMOB (keyword, scm_tc16_keyword, SCM_UNPACK (symbol));
      scm_intern_symbol (scm_keyword_obarray, symbol);
      vcell = scm_sym2ovcell_soft (symbol, scm_keyword_obarray);
      SCM_SETCDR (vcell, keyword);
    }
  SCM_ALLOW_INTS;
  return SCM_CDR (vcell);
}
#undef FUNC_NAME

SCM
scm_c_make_keyword (char *s)
{
  SCM vcell;
  char *buf = scm_must_malloc (strlen (s) + 2, "keyword");
  buf[0] = '-';
  strcpy (buf + 1, s);
  vcell = scm_sysintern0 (buf);
  scm_must_free (buf);
  return scm_make_keyword_from_dash_symbol (SCM_CAR (vcell));
}

SCM_DEFINE (scm_keyword_p, "keyword?", 1, 0, 0, 
            (SCM obj),
	    "Returns #t if the argument OBJ is a keyword, else #f.")
#define FUNC_NAME s_scm_keyword_p
{
  return SCM_BOOL(SCM_KEYWORDP (obj));
}
#undef FUNC_NAME


SCM_DEFINE (scm_keyword_dash_symbol, "keyword-dash-symbol", 1, 0, 0, 
            (SCM keyword),
	    "Return KEYWORD as a dash symbol.\n"
            "This is the inverse of `make-keyword-from-dash-symbol'.\n")
#define FUNC_NAME s_scm_keyword_dash_symbol
{
  SCM_VALIDATE_KEYWORD (1,keyword);
  return SCM_CDR (keyword);
}
#undef FUNC_NAME



void
scm_init_keywords ()
{
  scm_tc16_keyword = scm_make_smob_type_mfpe ("keyword", 0,
                                             scm_markcdr, NULL, prin_keyword, NULL);

  scm_keyword_obarray = scm_make_vector (SCM_MAKINUM (256), SCM_EOL);
#include "libguile/keywords.x"
}


/*
  Local Variables:
  c-file-style: "gnu"
  End:
*/
