/* -*- Mode: c++ -*- 
 *
 *  Copyright 1997 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 */


#ifndef _VrIIRFILTER_H_
#define _VrIIRFILTER_H_

#include <VrSigProc.h>

template<class iType,class oType> 
class VrIIRfilter : public VrSigProc<iType,oType> {
protected:
  int order;
  float B[13], A[13];
  float gain;
public: 
  virtual void work(int n);
  virtual void initialize();
  VrIIRfilter(int);
  ~VrIIRfilter();
};

template<class iType,class oType> void
VrIIRfilter<iType,oType>::work(int n)
{
  float result;
  for (int i=0;i<n;i++,incReadPtr(1)) {
    result = 0;
    iType* x=inputReadPtr(-order+1);
    result += B[0] * x[order-1];

    for (int j=1; j < order; j++) {
      result += (B[j] * x[order-j-1]) - (A[j] * outputRead(-j));
    }
    outputWrite((oType)result);
  }
}


template<class iType,class oType> 
VrIIRfilter<iType,oType>::VrIIRfilter(int ord)
  :order(13),gain(1.0)
{
  B[0] =    0.10294689929909;
  B[1] =    0.00000000000000;
  B[2] =   -0.61768139579454;
  B[3] =    0.00000000000000;
  B[4] =    1.54420348948635;
  B[5] =    0.00000000000000;
  B[6] =   -2.05893798598180;
  B[7] =    0.00000000000000;
  B[8] =    1.54420348948635;
  B[9] =    0.00000000000000;
  B[10]=   -0.61768139579454;
  B[11]=    0.00000000000000;
  B[12]=    0.10294689929909;

  A[0] =    1.00000000000000;
  A[1] =   -3.08868226170759;
  A[2] =    2.53841619253059;
  A[3] =    0.17720846883195;
  A[4] =    0.54877264686210;
  A[5] =   -2.22705459063182;
  A[6] =    0.55755947664311;
  A[7] =    0.65421846247252;
  A[8] =    0.11061240543867;
  A[9] =   -0.26403999814312;
  A[10]=   -0.04981391951430;
  A[11]=    0.03230342495928;
  A[12]=    0.01062778472665;

  setOutputHistory(order);

}

template<class iType,class oType> 
void VrIIRfilter<iType,oType>::initialize()
{
  
  setHistory(order);

}

template<class iType,class oType> 
VrIIRfilter<iType,oType>::~VrIIRfilter()
{
  // delete Ataps;
  //delete Btaps;
}

#endif








