#!/usr/bin/env python
#
# Copyright 2003 Free Software Foundation, Inc.
# 
# This file is part of GNU Radio
# 
# GNU Radio is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# GNU Radio is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with GNU Radio; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.
# 

from GnuRadio import *
from slider_control import *

#
# return a gr_FlowGraph
#
def build_graph1 ():
    interp_rate = 256
    sample_rate = 125e6/interp_rate

    src = VrSigSourceF (sample_rate, VR_DC_WAVE, 0, 1024)
    f2c = GrFloatToComplex ()
    dst = GrFileSink (sizeof_VrComplex, "complex.out")

    fg = gr_FlowGraph ()
    fg.connect (src, f2c)
    fg.connect (f2c, dst)

    return fg

def build_graph2 ():
    def set_tx_freq0 (freq):
        dst.set_tx_freq(0,freq)
    def set_src_freq (freq):
        srcI.setFrequency(freq)
        srcQ.setFrequency(freq)
    def set_amp (amp):
        srcI.setAmplitude(amp)
        srcQ.setAmplitude(amp)

    interp_rate = 256
    sample_rate = 125e6/interp_rate
    which_board = 0
    channel_bitmask = 0x01
    ampl = 19000

    srcI = VrSigSourceF (sample_rate, VR_SIN_WAVE, 30000, ampl)
    srcQ = VrSigSourceF (sample_rate, VR_COS_WAVE, 30000, ampl)
    # srcI = VrSigSourceF (sample_rate, VR_SIN_WAVE, sample_rate/4, ampl)
    # srcQ = VrSigSourceF (sample_rate, VR_DC_WAVE, 0, 0)
    f2c = GrFloatToComplex ()
    dst = GrUsrpSink (which_board, channel_bitmask, interp_rate)
    dst.set_tx_freq (0, 45e6);

    sc1 = slider_control(None,-1,"USRP Freq", set_tx_freq0, 0, 60000000)
    # sc2 = slider_control(None,-1,"Source Freq",srcI.setFrequency,0,sample_rate/2)
    # sc3 = slider_control(None,-1,"Amplitude",srcI.setAmplitude,0,32767)
    sc2 = slider_control(None,-1,"Source Freq", set_src_freq, 0, sample_rate/2)
    sc3 = slider_control(None,-1,"Amplitude", set_amp, 0, 32767)

    fg = gr_FlowGraph ()
    fg.connect (srcI, f2c)
    fg.connect (srcQ, f2c)
    fg.connect (f2c, dst)

    return fg

def build_graph3 ():
    def set_tx_freq0 (freq):
        dst.set_tx_freq(0,freq)

    interp_rate = 256
    sample_rate = 125e6/interp_rate
    which_board = 0
    channel_bitmask = 0x01
    ampl = 10000

    src = GrComplexNCOSource (sample_rate, 600, ampl)
    dst = GrUsrpSink (which_board, channel_bitmask, interp_rate)
    dst.set_tx_freq (0, 5e6);
    # dst.set_ext_clk_div (12);

    sc1 = slider_control(None,-1,"USRP Freq",set_tx_freq0,0,60000000)
    sc2 = slider_control(None,-1,"Source Freq",src.setFrequency,-sample_rate/2,sample_rate/2)
    sc3 = slider_control(None,-1,"Amplitude",src.setAmplitude,0,32767)

    fg = gr_FlowGraph ()
    fg.connect (src, dst)

    return fg


if __name__ == '__main__':
    fg = build_graph2 ()
    fg.start ()                         # fork thread(s) and return immediately
    # your GUI mail loop goes here...
    # fg.wait ();                         # wait (forever)
    #parent,id,title,callback,min,max
    app=wx.PySimpleApp()
    app.MainLoop()
    raw_input ('Press Enter to quit: ')
    fg.stop ()
