#!/usr/bin/python

from wxPython.wx import *
from wxPython.gizmos import *
#from oscope_display import *

sys.path.append ('.')
sys.path.append ('/usr/local/gnuradio/python')

try:
    import pm_thread
except ImportError:
    print "Couldn't find powermate module"
    
ID_ABOUT=101
ID_EXIT=110
ID_BUTTON1 =120
MUTE_BUTTON = 133
ATTN_BUTTON = 143
XMIT_BUTTON = 144
FREQSL = 128
RBOX1 = 23
RBOX2 = 24

bands = [ ("160M",1.8e6,2e6),
          ("80M",3.5e6,4e6),
          ("40M",7e6,7.2e6),
          ("30M",10.1e6,10.15e6),
          ("20M",14e6,14.35e6),
          ("17M",18.068e6,18.168e6),
          ("15M",21e6,21.45e6),
          ("12M",24.890e6,24.99e6),
          ("10M",28e6,29.7e6),
          ("6M",50e6,54e6),
          ("AM-BC", 530e3,1.71e6),
          ("CB-11M",26.965e6,27.405e6),
          ("WWV2.5",2.45e6,2.55e6),
          ("WWV5",4.95e6,5.05e6),
          ("WWV10",9.95e6,10.05e6),
          ("OPEN",0,60e6)]

modes = [ "USB","LSB","CW","AM","FM" ]

class audiocontrols(wxPanel):
    def __init__(self,parent,id):
        wxPanel.__init__(self,parent,-1)
        self.parent = parent
        self.lp = 300
        self.hp = 3000
        self.volslider = wxSlider(self, 100, 0, -50, 50,wxDefaultPosition,# wxPoint(30, 60),
                          wxSize(250, -1),
                          wxSL_HORIZONTAL | wxSL_LABELS ) # |wxSL_AUTOTICKS )
        self.lowslider = wxSlider(self, 192, 300, 0, 1000, wxDefaultPosition,
                                  wxSize(250,-1), wxSL_HORIZONTAL | wxSL_LABELS )
        self.highslider = wxSlider(self, 193, 3000, 1000, 5000, wxDefaultPosition,
                                  wxSize(250,-1), wxSL_HORIZONTAL | wxSL_LABELS )
        EVT_COMMAND_SCROLL(self, 100, self.update_volume)
        EVT_COMMAND_SCROLL(self, 192, self.update_lowpass)
        EVT_COMMAND_SCROLL(self, 193, self.update_highpass)

        self.sizer = wxGridSizer(3,2,3,3)

        self.sizer.AddMany(
            [ wxStaticText(self,-1,"Audio Gain"),
              self.volslider,
              wxStaticText(self,-1,"Upper Cutoff"),
              self.highslider,
              wxStaticText(self,-1,"Lower Cutoff"),
              self.lowslider ] )

        self.SetSizer(self.sizer)

    def update_volume(self,event):
        if(self.parent.myflowgraph):
            self.parent.myflowgraph.set_volume(float(event.GetInt()))

    def update_lowpass(self,event):
        self.lp = event.GetInt()
        if(self.parent.myflowgraph):
            self.parent.myflowgraph.set_bpf(self.lp,self.hp)
        
    def update_highpass(self,event):
        self.hp = event.GetInt()
        if(self.parent.myflowgraph):
            self.parent.myflowgraph.set_bpf(self.lp,self.hp)


class modeselector(wxPanel):
    """Mode Selection"""
    def __init__(self,parent,id):
        wxPanel.__init__(self,parent,-1)

        rb = wxRadioBox(self,RBOX2, "Mode Selection",
                        (0,0),wxDefaultSize,
                        modes,1, wxRA_SPECIFY_ROWS | wxNO_BORDER)

class freqcontrol(wxPanel):
    """Combined display and frequency controller"""
    def __init__(self,parent,id):
        wxPanel.__init__(self,parent,-1)

        self.parent = parent

        self.flag = False
        self.led = wxLEDNumberCtrl(self,id,
                                   wxDefaultPosition,(500,75),wxLED_ALIGN_CENTER)
                                   #(0,0),(50,50),wxLED_ALIGN_CENTER)

        self.freqslider = wxSlider(self, FREQSL, 25, 1, 100, wxPoint(30, 60),
                          wxSize(250, -1),
                          wxSL_HORIZONTAL | wxSL_AUTOTICKS | wxSL_LABELS )
        #self.freqslider.SetTickFreq(1000, 1)
        self.freqslider.SetLineSize(100)
        self.freqslider.SetPageSize(1000)
        EVT_COMMAND_SCROLL(self.freqslider, FREQSL, self.EvtUpdateFreq)

        self.rb = wxRadioBox(self, RBOX1, "Band Selection",
                             #(0,0),(400,400),
                             wxDefaultPosition, wxDefaultSize,
                             [text for (text,start,stop) in bands], 3, wxRA_SPECIFY_COLS | wxNO_BORDER)
            
        EVT_RADIOBOX(self, RBOX1, self.EvtRadioBox)
            
        sizer = wxBoxSizer(wxVERTICAL)
        self.SetSizer(sizer)
        sizer.Add(self.led, 0, wxALIGN_CENTER)
        sizer.Add(self.freqslider, 0, wxALIGN_CENTER)

        if (True):#use_powermate == 0):
            buttons = []
            for x in range(5):
                buttons = buttons + [(wxButton(self,1010+x,"+%d" % 10**x))]
                EVT_BUTTON(self, 1010+x, self.FreqIncr)
            for x in range(5):
                buttons = buttons + [(wxButton(self,1020+x,"-%d" % 10**x))]
                EVT_BUTTON(self, 1020+x, self.FreqIncr)
                    
	    self.buttonsizer = wxGridSizer(2,5,3,3)
            self.buttonsizer.AddMany(buttons)
            sizer.Add(self.buttonsizer,0,wxALIGN_CENTER)

        sizer.Add(self.rb, 0, wxALIGN_CENTER)
        self.SetBand(0)
	
    def FreqIncr(self,event):
        id = event.GetId() - 1010
        if(id > 6):
            self.UpdateFreq(self.freq - 10**(id-10))
        else:
            self.UpdateFreq(self.freq + 10**id)
            
    def EvtRadioBox(self, event):
        self.SetBand(event.GetInt())

    def SetBand(self,band):
        self.curband = band
        self.freqslider.SetRange(bands[band][1],bands[band][2])
        self.UpdateFreq(bands[band][1])

    def EvtSlider(self,event):
        print "slider"
        if(self.flag):
            self.flag = False
        else:
            self.UpdateFreq(event.GetInt())
        
    def EvtUpdateFreq(self, event):
        self.flag = True
        self.UpdateFreq(event.GetInt())

    def UpdateFreq(self,freq):
        self.freq = freq
        if(bands[self.curband][1] > freq):
            self.freq = bands[self.curband][1]
        if(bands[self.curband][2] < freq):
            self.freq = bands[self.curband][2]
        self.freqslider.SetValue(self.freq)
	tmp = int(self.freq)
        if tmp == 0:
            q = "0"
        else:
            digits = []
            for x in range(9):
                digits = digits + [(tmp % 10)] #+ digits
                tmp = int(tmp / 10)
            x = 8
            q = ""
            while digits[x] == 0:
                x=x-1
            while x >= 0:
                q = "%s%s" % (q,digits[x])
                if x>0 and x%3 == 0:
                    q = "%s " % q
                x = x-1
        self.led.SetValue(q)
        if self.parent.myflowgraph:
            self.parent.myflowgraph.set_freq(freq)

    def FreqDelta(self,delta):
        self.UpdateFreq(self.freq + delta)
  
        
class hfgui(wxFrame):
    """ Test Frame """
    def __init__(self,parent,id,title,fg = False):
        wxFrame.__init__(self,parent,-4,title,size = (800,800),
                         style=wxWANTS_CHARS|wxDEFAULT_FRAME_STYLE|wxNO_FULL_REPAINT_ON_RESIZE|wxMAXIMIZE)
        # self.CreateStatusBar()
        self.myflowgraph = fg

        # Setting up the menu.
        filemenu= wxMenu()
        filemenu.Append(ID_ABOUT, "&About"," Information about this program")
        filemenu.AppendSeparator()
        filemenu.Append(ID_EXIT,"E&xit"," Terminate the program")

        # Creating the menubar.
        menuBar = wxMenuBar()
        menuBar.Append(filemenu,"&File") # Adding the "filemenu" to the MenuBar
        self.SetMenuBar(menuBar)  # Adding the MenuBar to the Frame content.

        EVT_MENU(self, ID_EXIT, self.OnExit)   # attach the menu-event ID_EXIT to the
        EVT_MENU(self, ID_ABOUT, self.OnAbout) 

        self.freq_control = freqcontrol(self,-1)

#        self.scope = oscope_display (self, 1)

        self.sizerV = wxBoxSizer(wxVERTICAL)
        self.sizerH = wxBoxSizer(wxHORIZONTAL)
        self.sizerH2 = wxBoxSizer(wxHORIZONTAL)

        self.modes = modeselector(self,-1)
        self.ac = audiocontrols (self, -1)

        self.mute_cb = wxToggleButton(self, MUTE_BUTTON, "Mute", wxPoint(65, 80), wxSize(150, 20), wxNO_BORDER)
        self.attn_cb = wxToggleButton(self, ATTN_BUTTON, "20dB Atten", wxPoint(65, 80), wxSize(150, 20), wxNO_BORDER)
        self.xmit_cb = wxToggleButton(self, XMIT_BUTTON, "Transmit", wxPoint(65, 80), wxSize(150, 20), wxNO_BORDER)
        
        EVT_TOGGLEBUTTON(self.mute_cb, MUTE_BUTTON, self.OnToggle)
        EVT_TOGGLEBUTTON(self.attn_cb, ATTN_BUTTON, self.OnToggle)
        EVT_TOGGLEBUTTON(self.xmit_cb, XMIT_BUTTON, self.OnToggle)

        self.sizerH2.Add(self.freq_control,1,wxALIGN_CENTER|wxEXPAND)
        self.sizerH2.Add(self.sizerV,1,wxALIGN_CENTER|wxEXPAND)

#        self.sizerV.Add(self.panel,1,wxALIGN_CENTER)
        self.sizerH.Add(self.mute_cb,1,wxALIGN_CENTER)
        self.sizerH.Add(self.attn_cb,1,wxALIGN_CENTER)
        self.sizerH.Add(self.xmit_cb,1,wxALIGN_CENTER)
        self.sizerV.Add(self.sizerH,1,wxALIGN_CENTER|wxEXPAND)
        self.sizerV.Add(self.modes,1,wxALIGN_CENTER|wxEXPAND)
        self.sizerV.Add(self.ac,1,wxALIGN_CENTER|wxEXPAND)
        
        self.SetSizer(self.sizerH2)
        self.SetAutoLayout(1)
        self.sizerH2.Fit(self)
        self.Show(true)

        EVT_KEY_DOWN(self,self.OnKeypress)

    def OnKeypress(self,event):
        print "keypress!!"
        
    def OnExit(self,event):
        self.Close(true)  # Close the frame.

    def OnAbout(self,e):
        d = wxMessageDialog( self, " A Field Day App\n"
                            " in wxPython","About GNU Radio FD", wxOK)
        d.ShowModal() # Shows it 
        d.Destroy() # finally destroy it when finished. 

    def OnToggle(self, event):
	if(self.myflowgraph):
            if (event.GetId() == MUTE_BUTTON):
                self.myflowgraph.radio.set_mute(event.Checked())
            elif (event.GetId() == ATTN_BUTTON):
                self.myflowgraph.radio.set_gain(event.Checked())
            elif (event.GetId() == XMIT_BUTTON):
                self.myflowgraph.radio.set_tx(event.Checked())
            else:
                print "event error"
        else:
            print event.Checked()
        

if __name__ == "__main__":
    frame = hfgui(None, -1, "GUI Test")
    try:
        pmate = pm_thread.PowerMateThread(freqcontrol)
        use_powermate = 1
        print "Powermate found"
    except NameError:
        use_powermate = 0
    except RuntimeError:
        print "Powermate not found"
        use_powermate = 0

    app = wxPySimpleApp()
    app.MainLoop()
    if(use_powermate):
        pmate.keep_running = False

