/* -*- c++ -*- */
/*
 * Copyright 2002 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _GRIMAG_H_
#define _GRIMAG_H_

#include <VrSigProc.h>

template<class oType>
class GrImag : public VrSigProc {
 public:
  GrImag () : VrSigProc (1, sizeof (VrComplex), sizeof (oType)) {}

  virtual const char *name() { return "GrImag"; }

  virtual int work(VrSampleRange output, void *o[],
		   VrSampleRange inputs[], void *i[]);

};

template<class oType> int
GrImag<oType>::work(VrSampleRange output, void *ao[],
		    VrSampleRange inputs[], void *ai[])
{
  VrComplex *i0 = ((VrComplex **)ai)[0];
  oType *o0 = ((oType **)ao)[0];
  long 	size = output.size;
  long	i;

  for (i = 0; i < size; i++)
    o0[i] = (oType) imag (i0[i]);

  return output.size;
}


#endif /* _GRIMAG_H_ */
