/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.util.crypto;

import org.gnunet.construct.FixedSizeIntegerArray;
import org.gnunet.util.Strings;
import org.gnunet.util.crypto.Ed25519;

public class EcdhePublicKey {
    @FixedSizeIntegerArray(bitSize=8, signed=false, length=32)
    public byte[] y;

    public EcdhePublicKey() {
    }

    public EcdhePublicKey(Ed25519 a) {
        this.y = a.encode();
    }

    public Ed25519 asPoint() {
        return Ed25519.decode(this.y);
    }

    public String toString() {
        return Strings.dataToString(this.y);
    }

    public EcdhePublicKey fromString(String s) {
        EcdhePublicKey publicKey = new EcdhePublicKey();
        Strings.stringToData(s, publicKey.y);
        return publicKey;
    }
}

