/* Find the person responsible for the given PR.
   Copyright (C) 1993, 1995 Free Software Foundation, Inc.
   Contributed by Brendan Kehoe (brendan@cygnus.com).

This file is part of GNU GNATS.

GNU GNATS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU GNATS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU GNATS; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111, USA.  */

#include "config.h"
#include "gnats.h"

/* Figure out which person is responsible for this PR.  This just calls
   get_responsible_address, which will return the person's email address
   (either as a local user or out of the `responsible' file).  This function
   could be rewritten to use a fuzzy text searcher on the PR body itself,
   to further categorize the PR, if you want.  */

Responsible*
get_responsible (category)
     Category *category;
{
  return get_responsible_address (category->person);
}
