// 
//   Copyright (C) 2007, 2008 Free Software Foundation, Inc.
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#ifndef GNASH_SOUND_H
#define GNASH_SOUND_H


#include "resource.h" // for sound_sample inheritance
#include "sound_handler.h"
#include "ControlTag.h" // for sound tags inheritance

// Forward declarations
namespace gnash {
	class movie_definition;
	class stream;
}


namespace gnash {

/// This class is simply an identifier for a sound sample managed
/// by a sound_handler, so should likely be defined in sound_handler.h
///
/// Definition tags will maintain a mapping between SWF-defined id
/// of the sound and these identifiers.
///
/// Specifying an identifier for use by sound_handler would likely be
/// claner, anyway this is what it is *currently*.
///
/// NOTE that the destructor of this identifier (thus becoming a "smart"
/// identifier) requests the currently registered sound_handler removal
/// of the identified sound_sample. This *might* be the reason why
/// it is a ref-counted thing (hard to belive...).
///
//
/// QUESTION: why is this a resource ?
///           does it really need to be ref-counted ?
///
/// TODO: move definition to sound_handler.h and possibly nest inside sound_handler itself ?
///
class sound_sample: public resource
{
public:
	int	m_sound_handler_id;

	sound_sample(int id)
		:
		m_sound_handler_id(id)
	{
	}

	/// delete the actual sound sample from the currently registered
	/// sound handler.
	~sound_sample();

	sound_sample* cast_to_sound_sample() { return this; }
};

/// SWF Tag SoundStreamBlock (19) 
//
/// TODO: move in it's own SoundStreamBlockTag files...
///
class start_stream_sound_tag : public ControlTag
{
public:
	boost::uint16_t	m_handler_id;
	long		m_start;
	int		latency;

	start_stream_sound_tag()
		:
		m_handler_id(0),
		m_start(0),
		latency(0)
	{
	}


	/// \brief
	/// Initialize this StartSound tag
	/// from the stream & given sample.
	//
	/// Insert ourself into the movie.
	void	read(movie_definition* m, int handler_id, long start);

	void	execute(sprite_instance* m) const;

	/// StartStreamSound is not a "state" tag?
	void execute_state(sprite_instance* m) const;
};

} // namespace gnash


#endif // GNASH_SOUND_H
