/*
 * Copyright (C) 2003-2015 FreeIPMI Core Team
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef IPMI_SENSOR_AND_EVENT_CODE_TABLES_OEM_WISTRON_SPEC_H
#define IPMI_SENSOR_AND_EVENT_CODE_TABLES_OEM_WISTRON_SPEC_H

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>

/*
 * Wistron / Dell Poweredge C6220
 */

#define IPMI_SENSOR_TYPE_PROCESSOR_EVENT_DATA2_OEM_WISTRON_PROCESSOR_1 0x00
#define IPMI_SENSOR_TYPE_PROCESSOR_EVENT_DATA2_OEM_WISTRON_PROCESSOR_2 0x01
#define IPMI_SENSOR_TYPE_PROCESSOR_EVENT_DATA2_OEM_WISTRON_PROCESSOR_3 0x02
#define IPMI_SENSOR_TYPE_PROCESSOR_EVENT_DATA2_OEM_WISTRON_PROCESSOR_4 0x04

#define IPMI_SENSOR_TYPE_MEMORY_EVENT_DATA2_OEM_WISTRON_THRESHOLD_BITMASK 0xF0
#define IPMI_SENSOR_TYPE_MEMORY_EVENT_DATA2_OEM_WISTRON_THRESHOLD_SHIFT   4

#define IPMI_SENSOR_TYPE_MEMORY_EVENT_DATA2_OEM_WISTRON_SBE_WARNING_THRESHOLD  0x00
#define IPMI_SENSOR_TYPE_MEMORY_EVENT_DATA2_OEM_WISTRON_SBE_CRITICAL_THRESHOLD 0x01
#define IPMI_SENSOR_TYPE_MEMORY_EVENT_DATA2_OEM_WISTRON_UNSPECIFIED            0x0F

#define IPMI_SENSOR_TYPE_MEMORY_EVENT_DATA2_OEM_WISTRON_CPU_DIMM_BITMASK 0x0F
#define IPMI_SENSOR_TYPE_MEMORY_EVENT_DATA2_OEM_WISTRON_CPU_DIMM_SHIFT   0

#define IPMI_SENSOR_TYPE_MEMORY_EVENT_DATA2_OEM_WISTRON_CPU1_DIMM_A 0x00
#define IPMI_SENSOR_TYPE_MEMORY_EVENT_DATA2_OEM_WISTRON_CPU2_DIMM_B 0x01
#define IPMI_SENSOR_TYPE_MEMORY_EVENT_DATA2_OEM_WISTRON_CPU3_DIMM_C 0x02
#define IPMI_SENSOR_TYPE_MEMORY_EVENT_DATA2_OEM_WISTRON_CPU4_DIMM_D 0x03

#define IPMI_SENSOR_TYPE_MEMORY_EVENT_DATA3_OEM_WISTRON_DIMM_1_BITMASK 0x01
#define IPMI_SENSOR_TYPE_MEMORY_EVENT_DATA3_OEM_WISTRON_DIMM_2_BITMASK 0x02
#define IPMI_SENSOR_TYPE_MEMORY_EVENT_DATA3_OEM_WISTRON_DIMM_3_BITMASK 0x04
#define IPMI_SENSOR_TYPE_MEMORY_EVENT_DATA3_OEM_WISTRON_DIMM_4_BITMASK 0x08
#define IPMI_SENSOR_TYPE_MEMORY_EVENT_DATA3_OEM_WISTRON_DIMM_5_BITMASK 0x10
#define IPMI_SENSOR_TYPE_MEMORY_EVENT_DATA3_OEM_WISTRON_DIMM_6_BITMASK 0x20
#define IPMI_SENSOR_TYPE_MEMORY_EVENT_DATA3_OEM_WISTRON_DIMM_7_BITMASK 0x40
#define IPMI_SENSOR_TYPE_MEMORY_EVENT_DATA3_OEM_WISTRON_DIMM_8_BITMASK 0x80

#define IPMI_SENSOR_TYPE_CRITICAL_INTERRUPT_OEM_WISTRON_EVENT_DATA2_DEVICE_NUMBER_BITMASK   0xF8
#define IPMI_SENSOR_TYPE_CRITICAL_INTERRUPT_OEM_WISTRON_EVENT_DATA2_DEVICE_NUMBER_SHIFT     3

#define IPMI_SENSOR_TYPE_CRITICAL_INTERRUPT_OEM_WISTRON_EVENT_DATA2_FUNCTION_NUMBER_BITMASK 0x07
#define IPMI_SENSOR_TYPE_CRITICAL_INTERRUPT_OEM_WISTRON_EVENT_DATA2_FUNCTION_NUMBER_SHIFT   0

#define IPMI_SENSOR_TYPE_IOH_CORE_ERROR_OEM_WISTRON_CORE      0x07
#define IPMI_SENSOR_TYPE_IOH_CORE_ERROR_OEM_WISTRON_NON_FATAL 0x08
#define IPMI_SENSOR_TYPE_IOH_CORE_ERROR_OEM_WISTRON_FATAL     0x0A

#define IPMI_SENSOR_TYPE_IOH_CORE_ERROR_EVENT_DATA3_OEM_WISTRON_QPI0_ERROR          0x00
#define IPMI_SENSOR_TYPE_IOH_CORE_ERROR_EVENT_DATA3_OEM_WISTRON_QPI1_ERROR          0x01
#define IPMI_SENSOR_TYPE_IOH_CORE_ERROR_EVENT_DATA3_OEM_WISTRON_QPI2_ERROR          0x02
#define IPMI_SENSOR_TYPE_IOH_CORE_ERROR_EVENT_DATA3_OEM_WISTRON_QPI3_ERROR          0x03
#define IPMI_SENSOR_TYPE_IOH_CORE_ERROR_EVENT_DATA3_OEM_WISTRON_QPI0_PROTOCOL_ERROR 0x04
#define IPMI_SENSOR_TYPE_IOH_CORE_ERROR_EVENT_DATA3_OEM_WISTRON_QPI1_PROTOCOL_ERROR 0x05
#define IPMI_SENSOR_TYPE_IOH_CORE_ERROR_EVENT_DATA3_OEM_WISTRON_QPI2_PROTOCOL_ERROR 0x06
#define IPMI_SENSOR_TYPE_IOH_CORE_ERROR_EVENT_DATA3_OEM_WISTRON_QPI3_PROTOCOL_ERROR 0x07
#define IPMI_SENSOR_TYPE_IOH_CORE_ERROR_EVENT_DATA3_OEM_WISTRON_MISCELLANEOUS_ERROR 0x23
#define IPMI_SENSOR_TYPE_IOH_CORE_ERROR_EVENT_DATA3_OEM_WISTRON_IOH_CORE_ERROR      0x24

#define IPMI_SENSOR_TYPE_CRITICAL_INTERRUPT_EVENT_DATA2_OEM_WISTRON_LOCAL_ERROR_BIT_BITMASK 0x1F
#define IPMI_SENSOR_TYPE_CRITICAL_INTERRUPT_EVENT_DATA2_OEM_WISTRON_LOCAL_ERROR_BIT_SHIFT   0

#define IPMI_SENSOR_TYPE_CRITICAL_INTERRUPT_EVENT_DATA2_OEM_WISTRON_LOCAL_ERROR_BIT_HT_PERIODIC_CRC_ERROR           0x00
#define IPMI_SENSOR_TYPE_CRITICAL_INTERRUPT_EVENT_DATA2_OEM_WISTRON_LOCAL_ERROR_BIT_HT_PROTOCOL_ERROR               0x01 
#define IPMI_SENSOR_TYPE_CRITICAL_INTERRUPT_EVENT_DATA2_OEM_WISTRON_LOCAL_ERROR_BIT_HT_FLOW_CONTROL_BUFFER_OVERFLOW 0x02
#define IPMI_SENSOR_TYPE_CRITICAL_INTERRUPT_EVENT_DATA2_OEM_WISTRON_LOCAL_ERROR_BIT_HT_RESPONSE_ERROR               0x03
#define IPMI_SENSOR_TYPE_CRITICAL_INTERRUPT_EVENT_DATA2_OEM_WISTRON_LOCAL_ERROR_BIT_HT_PER_PACKET_CRC_ERROR         0x04
#define IPMI_SENSOR_TYPE_CRITICAL_INTERRUPT_EVENT_DATA2_OEM_WISTRON_LOCAL_ERROR_BIT_HT_RETRY_COUNTER_ERROR          0x05
#define IPMI_SENSOR_TYPE_CRITICAL_INTERRUPT_EVENT_DATA2_OEM_WISTRON_LOCAL_ERROR_BIT_HT_MCU_PARITY_ERROR             0x07

#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_EVENT_DATA2_OEM_WISTRON_BIOS_FIRST_FIELD_BITMASK 0xF0
#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_EVENT_DATA2_OEM_WISTRON_BIOS_FIRST_FIELD_SHIFT   4

#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_EVENT_DATA2_OEM_WISTRON_BIOS_SECOND_FIELD_HIGH_BITS_BITMASK    0x0F
#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_EVENT_DATA2_OEM_WISTRON_BIOS_SECOND_FIELD_HIGH_BITS_SHIFT      0
#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_EVENT_DATA2_OEM_WISTRON_BIOS_SECOND_FIELD_HIGH_BITS_LEFT_SHIFT 2

#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_EVENT_DATA3_OEM_WISTRON_BIOS_SECOND_FIELD_LOW_BITS_BITMASK 0xC0
#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_EVENT_DATA3_OEM_WISTRON_BIOS_SECOND_FIELD_LOW_BITS_SHIFT   6

#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_EVENT_DATA3_OEM_WISTRON_BIOS_THIRD_FIELD_BITMASK 0x3F
#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_EVENT_DATA3_OEM_WISTRON_BIOS_THIRD_FIELD_SHIFT   0

#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_EVENT_DATA2_OEM_WISTRON_BOOT_TYPE_BITMASK 0x80
#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_EVENT_DATA2_OEM_WISTRON_BOOT_TYPE_SHIFT   7

#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_EVENT_DATA2_OEM_WISTRON_BOOT_TYPE_PC_COMPATIBLE_BOOT 0x0
#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_EVENT_DATA2_OEM_WISTRON_BOOT_TYPE_UEFI_BOOT          0x1 

#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_EVENT_DATA2_OEM_WISTRON_BOOT_DEVICE_BITMASK 0x7F
#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_EVENT_DATA2_OEM_WISTRON_BOOT_DEVICE_SHIFT   0

#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_EVENT_DATA2_OEM_WISTRON_BOOT_DEVICE_FORCE_PXE_BOOT       0x1
#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_EVENT_DATA2_OEM_WISTRON_BOOT_DEVICE_NIC_PXE_BOOT         0x2
#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_EVENT_DATA2_OEM_WISTRON_BOOT_DEVICE_HARD_DISK_BOOT       0x3
#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_EVENT_DATA2_OEM_WISTRON_BOOT_DEVICE_RAID_HDD_BOOT        0x4
#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_EVENT_DATA2_OEM_WISTRON_BOOT_DEVICE_USB_STORAGE_BOOT     0x5
#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_EVENT_DATA2_OEM_WISTRON_BOOT_DEVICE_CD_DVD_ROM_BOOT      0x7
#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_EVENT_DATA2_OEM_WISTRON_BOOT_DEVICE_ISCSI_BOOT           0x8
#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_EVENT_DATA2_OEM_WISTRON_BOOT_DEVICE_UEFI_SHELL           0x9
#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_EVENT_DATA2_OEM_WISTRON_BOOT_DEVICE_EPSA_DIAGNOSTIC_BOOT 0xA

#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_OEM_WISTRON_POST_ERROR_CODE_LOCAL_CONSOLE_RESOURCE_CONFLICT       0x0010
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_OEM_WISTRON_POST_ERROR_CODE_LOCAL_CONSOLE_CONTROLLER_ERROR        0x0011
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_OEM_WISTRON_POST_ERROR_CODE_LOCAL_CONSOLE_OUTPUT_ERROR            0x0012
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_OEM_WISTRON_POST_ERROR_CODE_ISA_IO_CONTROLLER_ERROR               0x0013
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_OEM_WISTRON_POST_ERROR_CODE_ISA_IO_RESOURCE_CONFLICT              0x0014
/* achu: Doc lists "controller error" again, Dell confirms its not a typo. */
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_OEM_WISTRON_POST_ERROR_CODE_ISA_IO_CONTROLLER_ERROR2              0x0015
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_OEM_WISTRON_POST_ERROR_CODE_ISA_FLOPPY_CONTROLLER_ERROR           0x0016
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_OEM_WISTRON_POST_ERROR_CODE_ISA_FLOPPY_INPUT_ERROR                0x0017
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_OEM_WISTRON_POST_ERROR_CODE_ISA_FLOPPY_OUTPUT_ERROR               0x0018
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_OEM_WISTRON_POST_ERROR_CODE_USB_READ_ERROR                        0x0019
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_OEM_WISTRON_POST_ERROR_CODE_USB_WRITE_ERROR                       0x001A
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_OEM_WISTRON_POST_ERROR_CODE_USB_INTERFACE_ERROR                   0x001B
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_OEM_WISTRON_POST_ERROR_CODE_MOUSE_INTERFACE_ERROR                 0x001C
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_OEM_WISTRON_POST_ERROR_CODE_KEYBOARD_NOT_DETECTED                 0x001E
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_OEM_WISTRON_POST_ERROR_CODE_KEYBOARD_CONTROLLER_ERROR             0x001F
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_OEM_WISTRON_POST_ERROR_CODE_KEYBOARD_STUCK_KEY_ERROR              0x0020
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_OEM_WISTRON_POST_ERROR_CODE_KEYBOARD_LOCKED_ERROR                 0x0021
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_OEM_WISTRON_POST_ERROR_CODE_MEMORY_CORRECTABLE_ERROR              0x0023
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_OEM_WISTRON_POST_ERROR_CODE_MEMORY_UNCORRECTABLE_ERROR            0x0024
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_OEM_WISTRON_POST_ERROR_CODE_MEMORY_NON_SPECIFIC_ERROR             0x0025
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_OEM_WISTRON_POST_ERROR_CODE_MP_SERVICE_SELF_TEST_ERROR            0x0026
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_OEM_WISTRON_POST_ERROR_CODE_PCI_IO_CONTROLLER_ERROR               0x0027
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_OEM_WISTRON_POST_ERROR_CODE_PCI_IO_READ_ERROR                     0x0028
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_OEM_WISTRON_POST_ERROR_CODE_PCI_IO_WRITE_ERROR                    0x0029
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_OEM_WISTRON_POST_ERROR_CODE_SERIAL_PORT_NOT_DETECTED              0x002A
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_OEM_WISTRON_POST_ERROR_CODE_SERIAL_PORT_CONTROLLER_ERROR          0x002B
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_OEM_WISTRON_POST_ERROR_CODE_SERIAL_PORT_INPUT_ERROR               0x002C
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_OEM_WISTRON_POST_ERROR_CODE_SERIAL_PORT_OUTPUT_ERROR              0x002D
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_OEM_WISTRON_POST_ERROR_CODE_MICROCODE_UPDATE_ERROR                0x002E
/* achu: spec says "be updated", I assume English typo */
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_OEM_WISTRON_POST_ERROR_CODE_NO_MICROCODE_UPDATED                  0x002F
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_OEM_WISTRON_POST_ERROR_CODE_SATA_0_DEVICE_NOT_FOUND               0x8012
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_OEM_WISTRON_POST_ERROR_CODE_SATA_1_DEVICE_NOT_FOUND               0x8013
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_OEM_WISTRON_POST_ERROR_CODE_SATA_2_DEVICE_NOT_FOUND               0x8014
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_OEM_WISTRON_POST_ERROR_CODE_SATA_3_DEVICE_NOT_FOUND               0x8015
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_OEM_WISTRON_POST_ERROR_CODE_SATA_4_DEVICE_NOT_FOUND               0x8016
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_OEM_WISTRON_POST_ERROR_CODE_SATA_5_DEVICE_NOT_FOUND               0x8017
/* achu: spec says "be Configured", I assume English error */
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_OEM_WISTRON_POST_ERROR_CODE_SPARING_MODE_IS_NOT_CONFIGURED        0x8018
/* achu: spec says "be Configured", I assume English error */
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_OEM_WISTRON_POST_ERROR_CODE_MIRROR_MODE_IS_NOT_CONFIGURED         0x8019
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_OEM_WISTRON_POST_ERROR_CODE_SUPERVISER_AND_USER_PASSWORDS_CLEARED 0x8020
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_OEM_WISTRON_POST_ERROR_CODE_CMOS_BATTERY_FAULT                    0x8021

#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_EVENT_DATA2_OEM_WISTRON_BIOS_RECOVERY_START_RECOVERY   0x1
#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_EVENT_DATA2_OEM_WISTRON_BIOS_RECOVERY_RECOVERY_SUCCESS 0x2
#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_EVENT_DATA2_OEM_WISTRON_BIOS_RECOVERY_LOAD_IMAGE_FAIL  0x3
#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_EVENT_DATA2_OEM_WISTRON_BIOS_RECOVERY_SIGNED_FAIL      0x4

#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_EVENT_DATA2_OEM_WISTRON_ME_FAIL 0x1

/*
 * String arrays for above
 */

extern const char * const ipmi_sensor_type_oem_wistron_ioh_core_error[];
extern unsigned int ipmi_sensor_type_oem_wistron_ioh_core_error_max_index;

#ifdef __cplusplus
}
#endif

#endif /* IPMI_SENSOR_AND_EVENT_CODE_TABLES_OEM_WISTRON_SPEC_H */
