/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.strategy;

import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.lists.LeafList;
import com.sun.electric.tool.ncc.netlist.NetObject;
import com.sun.electric.tool.ncc.netlist.Part;
import com.sun.electric.tool.ncc.strategy.Strategy;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class StratPartType
extends Strategy {
    private Map<Integer, String> typeCodeToTypeName = new HashMap<Integer, String>();
    private Set<Part> forcedMatchParts;

    private StratPartType(Set<Part> forcedMatchParts, NccGlobals globals) {
        super(globals);
        this.forcedMatchParts = forcedMatchParts;
    }

    private LeafList doYourJob2() {
        EquivRecord parts = this.globals.getParts();
        LeafList offspring = this.doFor(parts);
        this.setReasons(offspring);
        this.summary(offspring);
        return offspring;
    }

    private void setReasons(LeafList offspring) {
        Iterator<EquivRecord> it = offspring.iterator();
        while (it.hasNext()) {
            EquivRecord r = it.next();
            int value2 = r.getValue();
            String reason = "part type is " + this.typeCodeToTypeName.get(new Integer(value2));
            this.globals.status2(reason);
            r.setPartitionReason(reason);
        }
    }

    private void summary(LeafList offspring) {
        this.globals.status2("StratPartType produced " + offspring.size() + " offspring");
        if (offspring.size() != 0) {
            this.globals.status2(offspring.sizeInfoString());
            this.globals.status2(this.offspringStats(offspring));
        }
    }

    @Override
    public Integer doFor(NetObject n) {
        int typeCode;
        this.error(!(n instanceof Part), "StratPartType expects only Parts");
        Part p = (Part)n;
        int n2 = typeCode = this.forcedMatchParts.contains(p) ? 0 : p.typeCode() + 1000;
        if (typeCode != 0) {
            String typeName = p.typeString();
            String oldTypeName = this.typeCodeToTypeName.get(typeCode);
            if (oldTypeName != null) {
                this.globals.error(typeCode != 0 && !typeName.equals(oldTypeName), "type code maps to multiple type names");
            } else {
                this.typeCodeToTypeName.put(typeCode, typeName);
            }
        }
        return typeCode;
    }

    public static LeafList doYourJob(Set<Part> forcedMatchParts, NccGlobals globals) {
        StratPartType pow = new StratPartType(forcedMatchParts, globals);
        return pow.doYourJob2();
    }
}

