/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.util.datastructures;

import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmutableList<T>
implements Iterable<T> {
    private ImmutableList<T> next;
    private T item;

    private ImmutableList(ImmutableList<T> next2, T item) {
        this.next = next2;
        this.item = item;
    }

    public static <T> ImmutableList<T> add(ImmutableList<T> list2, T item) {
        return new ImmutableList<T>(list2, item);
    }

    public static <T> ImmutableList<T> remove(ImmutableList<T> list2, T item) {
        if (list2 == null) {
            return null;
        }
        return super.remove(item);
    }

    private ImmutableList<T> remove(T target) {
        if (this.item == target) {
            return this.next;
        }
        ImmutableList<T> new_next = ImmutableList.remove(this.next, target);
        if (new_next == this.next) {
            return this;
        }
        return new ImmutableList<T>(new_next, this.item);
    }

    @Override
    public Iterator<T> iterator() {
        return new ImmutableListIterator(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImmutableListIterator<T>
    implements Iterator<T> {
        private ImmutableList<T> list;

        public ImmutableListIterator(ImmutableList<T> list2) {
            this.list = list2;
        }

        @Override
        public boolean hasNext() {
            return this.list != null;
        }

        @Override
        public T next() {
            if (this.list != null) {
                Object obj = ((ImmutableList)this.list).item;
                this.list = ((ImmutableList)this.list).next;
                return (T)obj;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

