/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tecEditWizard;

import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.tecEditWizard.Active;
import com.sun.electric.tool.user.tecEditWizard.Antenna;
import com.sun.electric.tool.user.tecEditWizard.Contact;
import com.sun.electric.tool.user.tecEditWizard.GDS;
import com.sun.electric.tool.user.tecEditWizard.Gate;
import com.sun.electric.tool.user.tecEditWizard.General;
import com.sun.electric.tool.user.tecEditWizard.Metal;
import com.sun.electric.tool.user.tecEditWizard.Poly;
import com.sun.electric.tool.user.tecEditWizard.TechEditWizardData;
import com.sun.electric.tool.user.tecEditWizard.TechEditWizardPanel;
import com.sun.electric.tool.user.tecEditWizard.Via;
import com.sun.electric.tool.user.tecEditWizard.WellImplant;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class TechEditWizard
extends EDialog {
    private JSplitPane splitPane;
    private JTree optionTree;
    private TechEditWizardPanel currentOptionPanel;
    private DefaultMutableTreeNode currentDMTN;
    private static TechEditWizardData data = new TechEditWizardData();
    private static String currentTabName = "General";

    public static void techEditWizardCommand() {
        TechEditWizard dialog = new TechEditWizard(TopLevel.getCurrentJFrame());
        dialog.setVisible(true);
    }

    public TechEditWizard(Frame parent) {
        super(parent, true);
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Technology Creation Wizard");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                TechEditWizard.this.closeDialog(evt);
            }
        });
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("Technology Parameters");
        DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
        this.optionTree = new JTree(treeModel);
        TreeHandler handler = new TreeHandler(this);
        this.optionTree.addMouseListener(handler);
        this.optionTree.addTreeExpansionListener(handler);
        this.addTreeNode(rootNode, "General");
        this.addTreeNode(rootNode, "Active");
        this.addTreeNode(rootNode, "Poly");
        this.addTreeNode(rootNode, "Gate");
        this.addTreeNode(rootNode, "Contact");
        this.addTreeNode(rootNode, "Well/Implant");
        this.addTreeNode(rootNode, "Metal");
        this.addTreeNode(rootNode, "Via");
        this.addTreeNode(rootNode, "Antenna");
        this.addTreeNode(rootNode, "GDS");
        TreePath topPath = this.optionTree.getPathForRow(0);
        this.optionTree.expandPath(topPath);
        topPath = this.optionTree.getPathForRow(1);
        this.optionTree.expandPath(topPath);
        this.openSelectedPath(rootNode);
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new GridBagLayout());
        JScrollPane scrolledTree = new JScrollPane(this.optionTree);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        leftPanel.add((Component)scrolledTree, gbc);
        JButton importBut = new JButton("Load Parameters");
        importBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TechEditWizard.this.importActionPerformed();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(4, 4, 4, 4);
        leftPanel.add((Component)importBut, gbc);
        JButton exportBut = new JButton("Save Parameters");
        exportBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TechEditWizard.this.exportActionPerformed();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(4, 4, 4, 4);
        leftPanel.add((Component)exportBut, gbc);
        JButton makeTech = new JButton("Write XML");
        makeTech.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TechEditWizard.this.makeTechnologyActionPerformed();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets = new Insets(4, 4, 4, 4);
        leftPanel.add((Component)makeTech, gbc);
        JButton okBut = new JButton("Done");
        okBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TechEditWizard.this.okActionPerformed();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.insets = new Insets(4, 4, 4, 4);
        leftPanel.add((Component)okBut, gbc);
        this.getRootPane().setDefaultButton(okBut);
        this.splitPane = new JSplitPane(1);
        this.loadOptionPanel();
        TechEditWizard.recursivelyHighlight(this.optionTree, rootNode, this.currentDMTN, this.optionTree.getPathForRow(0));
        this.splitPane.setLeftComponent(leftPanel);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)this.splitPane, gbc);
        this.pack();
        this.finishInitialization();
    }

    private void addTreeNode(DefaultMutableTreeNode rootNode, String name) {
        DefaultMutableTreeNode dmtn = new DefaultMutableTreeNode(name);
        rootNode.add(dmtn);
        if (name.equals(currentTabName)) {
            this.currentDMTN = dmtn;
        }
    }

    public TechEditWizardData getTechEditData() {
        return data;
    }

    private boolean openSelectedPath(DefaultMutableTreeNode rootNode) {
        for (int i = 0; i < rootNode.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)rootNode.getChildAt(i);
            Object o = node.getUserObject();
            if (o.toString().equals(currentTabName)) {
                this.optionTree.scrollPathToVisible(new TreePath(node.getPath()));
                return true;
            }
            if (!this.openSelectedPath(node)) continue;
            return true;
        }
        return false;
    }

    private void okActionPerformed() {
        if (this.currentOptionPanel != null) {
            this.currentOptionPanel.term();
            this.currentOptionPanel = null;
        }
        this.closeDialog(null);
    }

    private void importActionPerformed() {
        data.importData();
        if (this.currentOptionPanel != null) {
            this.currentOptionPanel.init();
        }
    }

    private void exportActionPerformed() {
        if (this.currentOptionPanel != null) {
            this.currentOptionPanel.term();
        }
        data.exportData();
    }

    private void makeTechnologyActionPerformed() {
        if (this.currentOptionPanel != null) {
            this.currentOptionPanel.term();
        }
        data.writeXML();
    }

    private void loadOptionPanel() {
        TechEditWizardPanel ti = this.createOptionPanel(this.isModal());
        if (ti == null) {
            return;
        }
        if (this.currentOptionPanel != null) {
            this.currentOptionPanel.term();
        }
        this.currentOptionPanel = ti;
        ti.init();
        this.splitPane.setRightComponent(ti.getComponent());
    }

    private TechEditWizardPanel createOptionPanel(boolean modal) {
        if (currentTabName.equals("Active")) {
            return new Active(this, modal);
        }
        if (currentTabName.equals("General")) {
            return new General(this, modal);
        }
        if (currentTabName.equals("Gate")) {
            return new Gate(this, modal);
        }
        if (currentTabName.equals("Poly")) {
            return new Poly(this, modal);
        }
        if (currentTabName.equals("Contact")) {
            return new Contact(this, modal);
        }
        if (currentTabName.equals("Well/Implant")) {
            return new WellImplant(this, modal);
        }
        if (currentTabName.equals("Metal")) {
            return new Metal(this, modal);
        }
        if (currentTabName.equals("Via")) {
            return new Via(this, modal);
        }
        if (currentTabName.equals("Antenna")) {
            return new Antenna(this, modal);
        }
        if (currentTabName.equals("GDS")) {
            return new GDS(this, modal);
        }
        return null;
    }

    protected void escapePressed() {
        this.okActionPerformed();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class TreeHandler
    implements MouseListener,
    TreeExpansionListener {
        private TechEditWizard dialog;

        TreeHandler(TechEditWizard dialog) {
            this.dialog = dialog;
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            TreePath currentPath = this.dialog.optionTree.getPathForLocation(e.getX(), e.getY());
            if (currentPath == null) {
                return;
            }
            this.dialog.optionTree.setSelectionPath(currentPath);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)currentPath.getLastPathComponent();
            currentTabName = (String)node.getUserObject();
            this.dialog.optionTree.expandPath(currentPath);
            if (!currentTabName.endsWith(" ")) {
                this.dialog.loadOptionPanel();
            }
            this.dialog.pack();
        }

        public void treeCollapsed(TreeExpansionEvent e) {
            this.dialog.pack();
        }

        public void treeExpanded(TreeExpansionEvent e) {
            TreePath tp = e.getPath();
            if (tp.getPathCount() == 2) {
                TreePath topPath = this.dialog.optionTree.getPathForRow(0);
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)topPath.getLastPathComponent();
                int numChildren = node.getChildCount();
                for (int i = 0; i < numChildren; ++i) {
                    DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
                    TreePath descentPath = topPath.pathByAddingChild(child);
                    if (descentPath.getLastPathComponent().equals(tp.getLastPathComponent())) continue;
                    this.dialog.optionTree.collapsePath(descentPath);
                }
            }
            this.dialog.pack();
        }
    }
}

