/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.Agilent6031A;
import com.sun.electric.tool.simulation.test.Infrastructure;
import com.sun.electric.tool.simulation.test.PowerChannel;

public class Agilent6031AChannel
extends PowerChannel {
    private final Agilent6031A supply;

    public Agilent6031AChannel(String channelName, String supplyName) {
        this.name = channelName + " (" + supplyName + ")";
        this.supply = new Agilent6031A(supplyName);
        Agilent6031AChannel.logInit("Initialized Agilent6031AChannel " + this.name);
    }

    public String getSupplyName() {
        return this.supply.getName();
    }

    public String getState() {
        return this.supply.getState();
    }

    public float readVoltage() {
        this.logOther("Reading voltage on " + this.getName());
        return this.supply.readVoltage();
    }

    public void setVoltageNoWait(float volts) {
        this.logSet("Agilent6031AChannel setting voltage on " + this.getName() + " to " + volts + " V");
        this.supply.setVoltage(volts);
    }

    public void waitForVoltage(float setVolts) {
        if (this.supply.isDisabled()) {
            return;
        }
        super.waitForVoltage(setVolts);
    }

    public float getVoltageSetpoint() {
        this.logOther("Reading voltage setpoint on " + this.getName());
        return this.supply.getVoltageSetpoint();
    }

    public float getVoltageResolution() {
        this.logOther("Getting voltage resolution on " + this.getName());
        return Agilent6031A.getVoltageResolution();
    }

    public float readCurrent() {
        this.logOther("Reading current on " + this.getName());
        return this.supply.readCurrent();
    }

    public void setCurrent(float amps) {
        this.logSet("Setting current limit on " + this.getName() + " to " + amps);
        this.supply.setCurrent(amps);
    }

    public float getCurrentSetpoint() {
        this.logOther("Reading current setpoint on " + this.getName());
        return this.supply.getCurrentSetpoint();
    }

    public int getFoldback() {
        return this.supply.getFoldback();
    }

    public void setFoldback(int mode) {
        this.supply.setFoldback(mode);
    }

    public float getOverVoltageProtection() {
        return this.supply.getOverVoltageProtection();
    }

    public static void main(String[] args) {
        Infrastructure.gpibControllers = new int[]{1};
        Agilent6031AChannel channel = new Agilent6031AChannel("aAgilent6031A", "power");
        System.out.println(channel.getState());
        System.out.println("res " + channel.getVoltageResolution() + "\n");
    }
}

