/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalAStar2.goal;

import com.sun.electric.tool.routing.experimentalAStar2.algorithm.AStarGoalBase;
import com.sun.electric.tool.routing.experimentalAStar2.algorithm.AStarNode;
import com.sun.electric.tool.routing.experimentalAStar2.algorithm.AStarOpenListBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleGoalEightNeighbours
implements AStarGoalBase<AStarNode> {
    private AStarOpenListBase<AStarNode> openList;
    private AStarNode goalNode;
    private int maxRevolutions = 0;

    @Override
    public void setGoalNode(AStarNode goal) {
        this.goalNode = goal;
    }

    @Override
    public int distanceToGoal(int startX, int startY, int startZ) {
        return this.distance(startX, startY, startZ, this.goalNode.getX(), this.goalNode.getY(), this.goalNode.getZ());
    }

    @Override
    public int getNodeCost(AStarNode node, int endX, int endY, int endZ) {
        return this.distance(node.getX(), node.getY(), node.getZ(), endX, endY, endZ);
    }

    @Override
    public boolean isPathFinished(AStarNode currentNode) {
        return this.goalNode.equals(currentNode);
    }

    @Override
    public void setNodeStorage(AStarOpenListBase<AStarNode> openList) {
        this.openList = openList;
    }

    @Override
    public void setMaximumRevolutions(int maximum) {
        this.maxRevolutions = maximum;
    }

    @Override
    public boolean shouldGiveUp(int currentRevolutions) {
        if (this.maxRevolutions > 0 && currentRevolutions >= this.maxRevolutions) {
            return true;
        }
        return this.openList.isOpenListEmpty();
    }

    private int distance(int startX, int startY, int startZ, int endX, int endY, int endZ) {
        int deltaX = startX - endX;
        int deltaY = startY - endY;
        return (int)(10.0 * Math.sqrt(Math.pow(deltaX, 2.0) + Math.pow(deltaY, 2.0)));
    }
}

