/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement;

import com.sun.electric.util.math.Orientation;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PlacementFrame {
    protected int numOfThreads;
    protected int runtime;
    private ArrayList<PlacementParameter> allParameters = new ArrayList();

    protected abstract void runPlacement(List<PlacementNode> var1, List<PlacementNetwork> var2, String var3);

    public abstract String getAlgorithmName();

    public final List<PlacementParameter> getParameters() {
        return this.allParameters;
    }

    public void setParamterValues(int threads, int runtime) {
        this.numOfThreads = threads;
        this.runtime = runtime;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PlacementNetwork {
        private List<PlacementPort> portsOnNet;

        public PlacementNetwork(List<PlacementPort> ports) {
            this.portsOnNet = ports;
        }

        public List<PlacementPort> getPortsOnNet() {
            return this.portsOnNet;
        }
    }

    public static class PlacementPort {
        private double offX;
        private double offY;
        private double rotatedOffX;
        private double rotatedOffY;
        private PlacementNode plNode;
        private PlacementNetwork plNet;

        public PlacementPort(double x, double y) {
            this.offX = x;
            this.offY = y;
        }

        public void setPlacementNode(PlacementNode pn) {
            this.plNode = pn;
        }

        public PlacementNode getPlacementNode() {
            return this.plNode;
        }

        public void setPlacementNetwork(PlacementNetwork pn) {
            this.plNet = pn;
        }

        public PlacementNetwork getPlacementNetwork() {
            return this.plNet;
        }

        public double getOffX() {
            return this.offX;
        }

        public double getOffY() {
            return this.offY;
        }

        public double getRotatedOffX() {
            return this.rotatedOffX;
        }

        public double getRotatedOffY() {
            return this.rotatedOffY;
        }

        public void computeRotatedOffset() {
            Orientation orient = this.plNode.getPlacementOrientation();
            if (orient == Orientation.IDENT) {
                this.rotatedOffX = this.offX;
                this.rotatedOffY = this.offY;
                return;
            }
            AffineTransform trans = orient.pureRotate();
            Point2D.Double offset = new Point2D.Double(this.offX, this.offY);
            trans.transform(offset, offset);
            this.rotatedOffX = ((Point2D)offset).getX();
            this.rotatedOffY = ((Point2D)offset).getY();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class PlacementNode {
        private double xPos;
        private double yPos;
        private Orientation orient;
        private Object userObject;

        public Object getUserObject() {
            return this.userObject;
        }

        public void setUserObject(Object obj) {
            this.userObject = obj;
        }

        public abstract List<PlacementPort> getPorts();

        public abstract double getWidth();

        public abstract double getHeight();

        public void setPlacement(double x, double y) {
            this.xPos = x;
            this.yPos = y;
        }

        public void setOrientation(Orientation o) {
            this.orient = o;
            for (PlacementPort plPort : this.getPorts()) {
                plPort.computeRotatedOffset();
            }
        }

        public double getPlacementX() {
            return this.xPos;
        }

        public double getPlacementY() {
            return this.yPos;
        }

        public Orientation getPlacementOrientation() {
            return this.orient;
        }

        public abstract String getTypeName();
    }

    public class PlacementParameter {
        public static final int TYPEINTEGER = 1;
        public static final int TYPESTRING = 2;
        public static final int TYPEDOUBLE = 3;
        final String key;
        private final String title;
        final Object factoryValue;
        private Object cachedValue;
        private final int type;

        public PlacementParameter(String name, String title, int factory) {
            this.key = PlacementFrame.this.getAlgorithmName() + "-" + name;
            this.title = title;
            this.cachedValue = this.factoryValue = Integer.valueOf(factory);
            this.type = 1;
            PlacementFrame.this.allParameters.add(this);
        }

        public PlacementParameter(String name, String title, String factory) {
            this.key = PlacementFrame.this.getAlgorithmName() + "-" + name;
            this.title = title;
            this.cachedValue = this.factoryValue = String.valueOf(factory);
            this.type = 2;
            PlacementFrame.this.allParameters.add(this);
        }

        public PlacementParameter(String name, String title, double factory) {
            this.key = PlacementFrame.this.getAlgorithmName() + "-" + name;
            this.title = title;
            this.cachedValue = this.factoryValue = Double.valueOf(factory);
            this.type = 3;
            PlacementFrame.this.allParameters.add(this);
        }

        public PlacementFrame getOwner() {
            return PlacementFrame.this;
        }

        public String getName() {
            return this.title;
        }

        public int getType() {
            return this.type;
        }

        public int getIntValue() {
            return (Integer)this.cachedValue;
        }

        public String getStringValue() {
            return (String)this.cachedValue;
        }

        public double getDoubleValue() {
            return (Double)this.cachedValue;
        }

        void setValue(Object value2) {
            assert (value2.getClass() == this.factoryValue.getClass());
            if (value2.equals(this.factoryValue)) {
                value2 = this.factoryValue;
            }
            this.cachedValue = value2;
        }
    }
}

