/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellTree;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.ImmutableNetLayout;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.text.ImmutableArrayList;
import com.sun.electric.database.text.Name;
import java.util.Arrays;

public class EquivPorts {
    private final CellId cellId;
    final int numExports;
    private final ImmutableArrayList<ImmutableExport> exports;
    final int[] equivPortsN;
    final int[] equivPortsP;
    final int[] equivPortsA;

    EquivPorts(CellTree cellTree) {
        this.cellId = cellTree.top.cellRevision.d.cellId;
        this.exports = cellTree.top.cellRevision.exports;
        this.numExports = this.exports.size();
        ImmutableNetLayout netCell = new ImmutableNetLayout(cellTree);
        this.equivPortsN = netCell.equivPortsN;
        this.equivPortsP = netCell.equivPortsP;
        this.equivPortsA = netCell.equivPortsA;
    }

    public CellId getCellId() {
        return this.cellId;
    }

    public int getNumExports() {
        return this.numExports;
    }

    public Name getExportName(int exportIndex) {
        return ((ImmutableExport)this.exports.get((int)exportIndex)).name;
    }

    public int[] getEquivPortsN() {
        return this.equivPortsN;
    }

    public int[] getEquivPortsP() {
        return this.equivPortsP;
    }

    public int[] getEquivPortsA() {
        return this.equivPortsA;
    }

    public boolean equalsPorts(EquivPorts that) {
        if (this.exports != that.exports) {
            if (this.exports.size() != that.exports.size()) {
                return false;
            }
            for (int exportIndex = 0; exportIndex < this.exports.size(); ++exportIndex) {
                ImmutableExport e1 = (ImmutableExport)this.exports.get(exportIndex);
                ImmutableExport e2 = (ImmutableExport)that.exports.get(exportIndex);
                if (e1.exportId == e2.exportId && e1.name == e2.name) continue;
                return false;
            }
        }
        return Arrays.equals(this.equivPortsN, that.equivPortsN) && Arrays.equals(this.equivPortsP, that.equivPortsP) && Arrays.equals(this.equivPortsA, that.equivPortsA);
    }
}

