/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.DRCRules;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.MoCMOS;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.user.dialogs.DesignRulesPanel;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.VectorDrawing;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class DesignRulesTab
extends PreferencePanel {
    DesignRulesPanel rulesPanel;
    private DRCRules drRules;
    private boolean designRulesFactoryReset = false;
    private int foundry;
    private JLabel defaultFoundryLabel;
    private JComboBox defaultFoundryPulldown;
    private JPanel designRules;
    private JLabel drResolutionLabel;
    private JTextField drResolutionValue;
    private JLabel drTechName;
    private JButton factoryReset;
    private JLabel jLabel6;

    public DesignRulesTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.rulesPanel = new DesignRulesPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 1;
        this.designRules.add((Component)this.rulesPanel, gridBagConstraints);
        this.factoryReset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DesignRulesTab.this.factoryResetDRCActionPerformed(evt);
            }
        });
    }

    public JPanel getPanel() {
        return this.designRules;
    }

    public String getName() {
        return "Design Rules";
    }

    public void init() {
        DRCRules rules = DRC.getRules(this.curTech);
        if (rules == null) {
            this.drTechName.setText("Technology " + this.curTech.getTechName() + " HAS NO DESIGN RULES");
            this.factoryReset.setEnabled(false);
            return;
        }
        this.drRules = rules;
        this.foundry = this.curTech.getFoundry();
        this.rulesPanel.init(this.curTech, this.foundry, this.drRules);
        String text = "Design Rules for Technology '" + this.curTech.getTechName() + "'";
        this.drTechName.setText(text);
        String selectedFoundry = this.curTech.getSelectedFoundry();
        Iterator it = this.curTech.getFactories();
        while (it.hasNext()) {
            Technology.Foundry factory = (Technology.Foundry)it.next();
            this.defaultFoundryPulldown.addItem(factory.name);
            if (!selectedFoundry.equals(factory.name)) continue;
            this.foundry = factory.techMode;
        }
        this.defaultFoundryPulldown.setEnabled(this.foundry != -1);
        this.defaultFoundryPulldown.setSelectedItem(selectedFoundry);
        this.drResolutionValue.setText(TextUtils.formatDouble(this.curTech.getResolution()));
    }

    private void factoryResetDRCActionPerformed(ActionEvent evt) {
        int response = JOptionPane.showConfirmDialog(TopLevel.getCurrentJFrame(), "Are you sure you want to do a factory reset of these design rules?");
        if (response != 0) {
            return;
        }
        this.designRulesFactoryReset = true;
    }

    public void term() {
        double currentResolution;
        String foundryName = (String)this.defaultFoundryPulldown.getSelectedItem();
        if (foundryName == null) {
            return;
        }
        int val = -1;
        if (!foundryName.equals(this.curTech.getSelectedFoundry())) {
            if (this.curTech == MoCMOS.tech) {
                String[] messages = new String[]{"Primitives in database might be resized according to values provided by " + foundryName + ".", "If you do not resize now, arc widths might not be optimal for " + foundryName + ".", "If you cancel the operation, the foundry will not be changed.", "Do you want to resize the database?"};
                Object[] options = new Object[]{"Yes", "No", "Cancel"};
                val = JOptionPane.showOptionDialog(TopLevel.getCurrentJFrame(), messages, "Resize Primitive Nodes and Arcs", -1, 2, null, options, options[0]);
            }
            if (val != 2) {
                this.curTech.setSelectedFoundry(foundryName);
                Iterator lIt = Library.getLibraries();
                while (lIt.hasNext()) {
                    Library lib = (Library)lIt.next();
                    Iterator cIt = lib.getCells();
                    while (cIt.hasNext()) {
                        Cell cell = (Cell)cIt.next();
                        if (cell.getTechnology() != this.curTech) continue;
                        VectorDrawing.cellChanged(cell);
                    }
                }
            }
        }
        if ((currentResolution = TextUtils.atof(this.drResolutionValue.getText())) != this.curTech.getResolution()) {
            this.curTech.setResolution(currentResolution);
        }
        if (this.designRulesFactoryReset) {
            DRC.resetDRCDates();
            this.drRules = this.curTech.getFactoryDesignRules();
        }
        DRC.setRules(this.curTech, this.drRules);
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd != null) {
            wnd.repaintContents(null, false);
        }
    }

    private void initComponents() {
        this.designRules = new JPanel();
        this.defaultFoundryLabel = new JLabel();
        this.defaultFoundryPulldown = new JComboBox();
        this.drResolutionLabel = new JLabel();
        this.drResolutionValue = new JTextField();
        this.jLabel6 = new JLabel();
        this.factoryReset = new JButton();
        this.drTechName = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Tool Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                DesignRulesTab.this.closeDialog(evt);
            }
        });
        this.designRules.setLayout(new GridBagLayout());
        this.designRules.setBorder(new TitledBorder(""));
        this.defaultFoundryLabel.setText("Foundry:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.designRules.add((Component)this.defaultFoundryLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.designRules.add((Component)this.defaultFoundryPulldown, gridBagConstraints);
        this.drResolutionLabel.setText("Min. resolution:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.designRules.add((Component)this.drResolutionLabel, gridBagConstraints);
        this.drResolutionValue.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.designRules.add((Component)this.drResolutionValue, gridBagConstraints);
        this.jLabel6.setText("(use 0 to ignore resolution check)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.designRules.add((Component)this.jLabel6, gridBagConstraints);
        this.factoryReset.setText("Factory Reset");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.designRules.add((Component)this.factoryReset, gridBagConstraints);
        this.drTechName.setText("jLabel1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        this.designRules.add((Component)this.drTechName, gridBagConstraints);
        this.getContentPane().add((Component)this.designRules, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

