/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.menus;

import com.sun.electric.tool.user.KeyBindingManager;
import com.sun.electric.tool.user.ui.KeyBindings;
import com.sun.electric.tool.user.ui.KeyStrokePair;
import com.sun.electric.tool.user.ui.MessagesWindow;
import com.sun.electric.tool.user.ui.ToolBarButton;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;

public class MenuBar
extends JMenuBar {
    private MenuBarGroup menuBarGroup;
    private ArrayList hiddenMenus = new ArrayList();
    boolean ignoreKeyBindings;
    boolean ignoreTextEditKeys;
    static /* synthetic */ Class class$com$sun$electric$tool$user$menus$MenuBar$MenuBarGroup;

    public MenuBar() {
        this("");
    }

    public MenuBar(String name) {
        this.menuBarGroup = MenuBarGroup.newInstance(name);
        this.ignoreKeyBindings = false;
        this.ignoreTextEditKeys = false;
    }

    public JMenu add(JMenu c) {
        super.add(c);
        this.menuAdded(c);
        return c;
    }

    public JMenu addHidden(JMenu c) {
        this.hiddenMenus.add(c);
        this.menuAdded(c);
        return c;
    }

    private void menuAdded(JMenu c) {
        ((Menu)c).setParentMenu(this);
        for (int i = 0; i < c.getItemCount(); ++i) {
            JMenuItem m = c.getItem(i);
            if (m == null) continue;
            if (m instanceof JMenu) {
                this.menuAdded((JMenu)m);
                continue;
            }
            if (!(m instanceof MenuItem)) continue;
            this.itemAdded((MenuItem)m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void itemAdded(JMenuItem item) {
        if (!(item instanceof MenuItemInterface)) {
            System.out.println("Can't add Menu Item " + item.getText() + " to Menu, it is not a MenuItemInterface");
            return;
        }
        MenuBarGroup menuBarGroup = this.menuBarGroup;
        synchronized (menuBarGroup) {
            String key = ((MenuItemInterface)((Object)item)).getDescription();
            KeyStroke accelerator = item.getAccelerator();
            ArrayList<JMenuItem> list = (ArrayList<JMenuItem>)this.menuBarGroup.menuItems.get(key);
            if (list == null) {
                list = new ArrayList<JMenuItem>();
                this.menuBarGroup.menuItems.put(key, list);
                this.addDefaultKeyBinding(item, accelerator, null);
                this.menuBarGroup.keyBindingManager.addActionListener(((MenuItemInterface)((Object)item)).getDescription(), new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        JMenuItem m = (JMenuItem)e.getSource();
                        m.doClick();
                    }
                });
                this.menuBarGroup.keyBindingManager.setEventSource(((MenuItemInterface)((Object)item)).getDescription(), item);
            }
            list.add(item);
        }
        item.addActionListener(this.menuBarGroup);
        item.addActionListener(ToolBarButton.updater);
        this.updateAccelerator(((MenuItemInterface)((Object)item)).getDescription());
    }

    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (this.ignoreKeyBindings) {
            return false;
        }
        if (this.ignoreTextEditKeys && !e.isControlDown() && !e.isMetaDown() && !e.isAltDown()) {
            return false;
        }
        boolean retValue = false;
        if (!retValue) {
            retValue = this.menuBarGroup.keyBindingManager.processKeyEvent(e);
        }
        return retValue;
    }

    public KeyBindings getKeyBindings(JMenuItem item) {
        return this.menuBarGroup.keyBindingManager.getKeyBindings(((MenuItemInterface)((Object)item)).getDescription());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDefaultKeyBinding(JMenuItem item, KeyStroke stroke, KeyStroke prefixStroke) {
        MenuBarGroup menuBarGroup = this.menuBarGroup;
        synchronized (menuBarGroup) {
            List list = (List)this.menuBarGroup.menuItems.get(((MenuItemInterface)((Object)item)).getDescription());
            if (list != null && list.size() > 1) {
                return;
            }
        }
        this.menuBarGroup.keyBindingManager.addDefaultKeyBinding(((MenuItemInterface)((Object)item)).getDescription(), KeyStrokePair.getKeyStrokePair(prefixStroke, stroke));
        this.updateAccelerator(((MenuItemInterface)((Object)item)).getDescription());
    }

    public void addUserKeyBinding(JMenuItem item, KeyStroke stroke, KeyStroke prefixStroke) {
        this.menuBarGroup.keyBindingManager.addUserKeyBinding(((MenuItemInterface)((Object)item)).getDescription(), KeyStrokePair.getKeyStrokePair(prefixStroke, stroke));
        this.updateAccelerator(((MenuItemInterface)((Object)item)).getDescription());
    }

    public void resetKeyBindings(JMenuItem item) {
        this.menuBarGroup.keyBindingManager.resetKeyBindings(((MenuItemInterface)((Object)item)).getDescription());
        this.updateAccelerator(((MenuItemInterface)((Object)item)).getDescription());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetAllKeyBindings() {
        MenuBarGroup menuBarGroup = this.menuBarGroup;
        synchronized (menuBarGroup) {
            Collection c = this.menuBarGroup.menuItems.values();
            Iterator it = c.iterator();
            while (it.hasNext()) {
                List list = (List)it.next();
                JMenuItem m = (JMenuItem)list.get(0);
                this.resetKeyBindings(m);
            }
        }
    }

    public void removeKeyBinding(String actionDesc, KeyStrokePair pair) {
        this.menuBarGroup.keyBindingManager.removeKeyBinding(actionDesc, pair);
        this.updateAccelerator(actionDesc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAccelerator(String actionDesc) {
        KeyBindings bindings = this.menuBarGroup.keyBindingManager.getKeyBindings(actionDesc);
        KeyStroke accelerator = null;
        if (bindings != null) {
            Iterator it = bindings.getUsingDefaultKeys() ? bindings.getDefaultKeyStrokePairs() : bindings.getKeyStrokePairs();
            while (it.hasNext()) {
                KeyStrokePair pair = (KeyStrokePair)it.next();
                if (pair.getPrefixStroke() != null) continue;
                accelerator = pair.getStroke();
                break;
            }
        }
        MenuBarGroup menuBarGroup = this.menuBarGroup;
        synchronized (menuBarGroup) {
            ArrayList list = (ArrayList)this.menuBarGroup.menuItems.get(actionDesc);
            if (list != null) {
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    JMenuItem m = (JMenuItem)it.next();
                    m.setAccelerator(accelerator);
                }
            }
        }
    }

    public void deleteEmptyBindings() {
        this.menuBarGroup.keyBindingManager.deleteEmptyBindings();
    }

    public void finished() {
        for (int i = 0; i < this.getMenuCount(); ++i) {
            JMenu menu = this.getMenu(i);
            if (menu == null) continue;
            this.disposeofMenu(menu);
        }
    }

    private void disposeofMenu(JMenu menu) {
        for (int j = 0; j < menu.getItemCount(); ++j) {
            JMenuItem item = menu.getItem(j);
            if (item == null) continue;
            if (item instanceof JMenu) {
                this.disposeofMenu((JMenu)item);
                continue;
            }
            this.disposeofMenuItem(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeofMenuItem(JMenuItem item) {
        ActionListener[] listeners = item.getActionListeners();
        for (int k = 0; k < listeners.length; ++k) {
            ActionListener listener = listeners[k];
            item.removeActionListener(listener);
        }
        MenuBarGroup menuBarGroup = this.menuBarGroup;
        synchronized (menuBarGroup) {
            ArrayList list = (ArrayList)this.menuBarGroup.menuItems.get(((MenuItemInterface)((Object)item)).getDescription());
            if (list == null) {
                return;
            }
            list.remove(item);
        }
    }

    public void setIgnoreKeyBindings(boolean b) {
        this.ignoreKeyBindings = b;
    }

    public boolean getIgnoreKeyBindings() {
        return this.ignoreKeyBindings;
    }

    public void setIgnoreTextEditKeys(boolean b) {
        this.ignoreTextEditKeys = b;
    }

    public boolean getIgnoreTextEditKeys() {
        return this.ignoreTextEditKeys;
    }

    private static String getDescription(JMenuItem item) {
        Stack<JComponent> parents = new Stack<JComponent>();
        JComponent parent = ((MenuItemInterface)((Object)item)).getParentMenu();
        while (parent != null && parent instanceof JMenuItem) {
            parents.push(parent);
            parent = ((MenuItemInterface)((Object)parent)).getParentMenu();
        }
        StringBuffer buf = new StringBuffer();
        while (!parents.isEmpty()) {
            buf.append(((JMenuItem)parents.pop()).getText() + " | ");
        }
        buf.append(item.getText());
        if (parent == null || !(parent instanceof JMenuBar)) {
            System.out.println("  PROGRAMMER ERROR: Menu " + buf.toString() + " not in JMenuBar.");
        }
        return buf.toString();
    }

    public static class Menu
    extends JMenu
    implements MenuItemInterface {
        private JComponent parentMenu = null;

        public Menu(String s) {
            super(s);
        }

        public Menu(String text, char mnemonic) {
            super(text);
            this.setMnemonic(mnemonic);
        }

        public void setParentMenu(JComponent menu) {
            this.parentMenu = menu;
        }

        public JComponent getParentMenu() {
            return this.parentMenu;
        }

        public String getDescription() {
            return MenuBar.getDescription(this);
        }

        public JMenuItem add(JMenuItem menuItem) {
            super.add(menuItem);
            if (menuItem instanceof MenuItemInterface) {
                ((MenuItemInterface)((Object)menuItem)).setParentMenu(this);
            }
            return menuItem;
        }

        public MenuItem addMenuItem(String s, KeyStroke accelerator, ActionListener action) {
            MenuItem item = new MenuItem(s);
            this.addItem(item, accelerator, action);
            return item;
        }

        public MenuItem addMenuItem(String s, KeyStroke accelerator, int mnemonicIndex, ActionListener action) {
            char c = s.charAt(mnemonicIndex);
            MenuItem item = new MenuItem(s);
            item.setMnemonic(c);
            item.setDisplayedMnemonicIndex(mnemonicIndex);
            this.addItem(item, accelerator, action);
            return item;
        }

        public JMenuItem addCheckBox(String s, boolean state, KeyStroke accelerator, ActionListener action) {
            CheckBoxMenuItem item = new CheckBoxMenuItem(s, state);
            this.addItem(item, accelerator, action);
            return item;
        }

        public JMenuItem addRadioButton(String s, boolean selected, ButtonGroup group, KeyStroke accelerator, ActionListener action) {
            RadioButtonMenuItem item = new RadioButtonMenuItem(s, selected);
            if (group != null) {
                group.add(item);
            }
            this.addItem(item, accelerator, action);
            return item;
        }

        private void addItem(JMenuItem item, KeyStroke accelerator, ActionListener action) {
            this.add(item);
            ((MenuItemInterface)((Object)item)).setParentMenu(this);
            item.setAccelerator(accelerator);
            item.addActionListener(action);
            JComponent parent = this.parentMenu;
            while (parent != null) {
                if (parent instanceof MenuBar) {
                    ((MenuBar)parent).itemAdded(item);
                    break;
                }
                parent = ((Menu)parent).getParentMenu();
            }
        }
    }

    public static class CheckBoxMenuItem
    extends JCheckBoxMenuItem
    implements MenuItemInterface {
        private JComponent parentMenu = null;

        public CheckBoxMenuItem(String text, boolean state) {
            super(text, state);
        }

        public void setParentMenu(JComponent menu) {
            this.parentMenu = menu;
        }

        public JComponent getParentMenu() {
            return this.parentMenu;
        }

        public String getDescription() {
            return MenuBar.getDescription(this);
        }
    }

    public static class RadioButtonMenuItem
    extends JRadioButtonMenuItem
    implements MenuItemInterface {
        private JComponent parentMenu = null;

        public RadioButtonMenuItem(String text, boolean selected) {
            super(text, selected);
        }

        public void setParentMenu(JComponent menu) {
            this.parentMenu = menu;
        }

        public JComponent getParentMenu() {
            return this.parentMenu;
        }

        public String getDescription() {
            return MenuBar.getDescription(this);
        }
    }

    public static class MenuItem
    extends JMenuItem
    implements MenuItemInterface {
        private JComponent parentMenu = null;

        public MenuItem(String s) {
            super(s);
        }

        public MenuItem(String text, int mnemonic) {
            super(text, mnemonic);
        }

        public void setParentMenu(JComponent menu) {
            this.parentMenu = menu;
        }

        public JComponent getParentMenu() {
            return this.parentMenu;
        }

        public String getDescription() {
            return MenuBar.getDescription(this);
        }
    }

    public static interface MenuItemInterface {
        public void setParentMenu(JComponent var1);

        public JComponent getParentMenu();

        public String getDescription();
    }

    public static class MenuBarGroup
    implements ActionListener {
        private static HashMap menuBarGroups = new HashMap();
        private String name;
        private Preferences prefs;
        private HashMap menuItems;
        public KeyBindingManager keyBindingManager;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static MenuBarGroup newInstance(String name) {
            HashMap hashMap = menuBarGroups;
            synchronized (hashMap) {
                if (menuBarGroups.containsKey(name)) {
                    return (MenuBarGroup)menuBarGroups.get(name);
                }
                return new MenuBarGroup(name);
            }
        }

        private MenuBarGroup(String name) {
            this.name = name;
            this.prefs = Preferences.userNodeForPackage(class$com$sun$electric$tool$user$menus$MenuBar$MenuBarGroup == null ? (class$com$sun$electric$tool$user$menus$MenuBar$MenuBarGroup = MenuBar.class$("com.sun.electric.tool.user.menus.MenuBar$MenuBarGroup")) : class$com$sun$electric$tool$user$menus$MenuBar$MenuBarGroup);
            this.menuItems = new HashMap(40);
            this.keyBindingManager = new KeyBindingManager(this.name + "MenuKeyBinding-", this.prefs);
            menuBarGroups.put(name, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ActionListener getUpdaterFor(String name) {
            HashMap hashMap = menuBarGroups;
            synchronized (hashMap) {
                return (ActionListener)menuBarGroups.get(name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            MessagesWindow.userCommandIssued();
            AbstractButton source = (AbstractButton)e.getSource();
            String name = source instanceof ToolBarButton ? ((ToolBarButton)source).getName() : source.getText();
            MenuBarGroup menuBarGroup = this;
            synchronized (menuBarGroup) {
                ArrayList list = (ArrayList)this.menuItems.get(name);
                if (list == null) {
                    return;
                }
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    AbstractButton b = (AbstractButton)it.next();
                    if (b == source) continue;
                    b.setSelected(source.isSelected());
                }
            }
        }
    }
}

