/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.lib.LibFile;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.io.output.Spice;
import com.sun.electric.tool.simulation.Simulation;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class SpiceTab
extends PreferencePanel {
    private JList spiceLayerList;
    private JList spiceCellList;
    private DefaultListModel spiceLayerListModel;
    private DefaultListModel spiceCellListModel;
    private int spiceEngineInitial;
    private String spiceLevelInitial;
    private String spiceOutputFormatInitial;
    private String spicePartsLibraryInitial;
    private boolean spiceUseParasiticsInitial;
    private boolean spiceUseNodeNamesInitial;
    private boolean spiceForceGlobalPwrGndInitial;
    private boolean spiceUseCellParametersInitial;
    private boolean spiceWriteTransSizesInLambdaInitial;
    private double spiceTechMinResistanceInitial;
    private double spiceTechMinCapacitanceInitial;
    private String spiceHeaderCardInitial;
    private String spiceTrailerCardInitial;
    private HashMap spiceLayerResistanceOptions;
    private HashMap spiceLayerCapacitanceOptions;
    private HashMap spiceLayerEdgeCapacitanceOptions;
    private HashMap spiceCellModelOptions;
    private boolean spiceUseRunDirInitial;
    private String spiceRunDirInitial;
    private boolean overwriteOutputFileInitial;
    private boolean spiceRunProbeInitial;
    private String spiceRunProgramInitial;
    private String spiceRunProgramArgsInitial;
    private String spiceRunPopupInitial;
    private boolean spiceModelFileChanging = false;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JCheckBox overwriteOutputFile;
    private JPanel spice;
    private JPanel spice1;
    private JPanel spice2;
    private JPanel spice3;
    private JPanel spice4;
    private JPanel spice5;
    private JPanel spice6;
    private JButton spiceBrowseHeaderFile;
    private JButton spiceBrowseTrailerFile;
    private JTextField spiceCapacitance;
    private JScrollPane spiceCell;
    private JRadioButton spiceDeriveModelFromCircuit;
    private JTextField spiceEdgeCapacitance;
    private JComboBox spiceEnginePopup;
    private JCheckBox spiceForceGlobalPwrGnd;
    private ButtonGroup spiceHeader;
    private JTextField spiceHeaderCardExtension;
    private JTextField spiceHeaderCardFile;
    private JRadioButton spiceHeaderCardsFromFile;
    private JRadioButton spiceHeaderCardsWithExtension;
    private JScrollPane spiceLayer;
    private JComboBox spiceLevelPopup;
    private JTextField spiceMinCapacitance;
    private JTextField spiceMinResistance;
    private ButtonGroup spiceModel;
    private JTextField spiceModelCell;
    private JButton spiceModelFileBrowse;
    private JRadioButton spiceNoHeaderCards;
    private JRadioButton spiceNoTrailerCards;
    private JComboBox spiceOutputFormatPopup;
    private JComboBox spicePrimitivesetPopup;
    private JTextField spiceResistance;
    private JButton spiceRunHelp;
    private JComboBox spiceRunPopup;
    private JCheckBox spiceRunProbe;
    private JTextField spiceRunProgram;
    private JTextField spiceRunProgramArgs;
    private JLabel spiceTechnology;
    private ButtonGroup spiceTrailer;
    private JTextField spiceTrailerCardExtension;
    private JTextField spiceTrailerCardFile;
    private JRadioButton spiceTrailerCardsFromFile;
    private JRadioButton spiceTrailerCardsWithExtension;
    private JCheckBox spiceUseCellParameters;
    private JRadioButton spiceUseModelFromFile;
    private JCheckBox spiceUseNodeNames;
    private JCheckBox spiceUseParasitics;
    private JCheckBox spiceWriteTransSizesInLambda;
    private JTextField useDir;
    private JCheckBox useDirCheckBox;
    static /* synthetic */ Class class$java$lang$String;

    public SpiceTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.spice;
    }

    public String getName() {
        return "Spice";
    }

    public void init() {
        this.spiceEngineInitial = Simulation.getSpiceEngine();
        this.spiceEnginePopup.addItem("Spice 2");
        this.spiceEnginePopup.addItem("Spice 3");
        this.spiceEnginePopup.addItem("HSpice");
        this.spiceEnginePopup.addItem("PSpice");
        this.spiceEnginePopup.addItem("Gnucap");
        this.spiceEnginePopup.addItem("SmartSpice");
        this.spiceEnginePopup.setSelectedIndex(this.spiceEngineInitial);
        this.spiceLevelInitial = Simulation.getSpiceLevel();
        this.spiceLevelPopup.addItem("1");
        this.spiceLevelPopup.addItem("2");
        this.spiceLevelPopup.addItem("3");
        this.spiceLevelPopup.setSelectedItem(this.spiceLevelInitial);
        this.spiceOutputFormatInitial = Simulation.getSpiceOutputFormat();
        this.spiceOutputFormatPopup.addItem("Standard");
        this.spiceOutputFormatPopup.addItem("Raw");
        this.spiceOutputFormatPopup.addItem("Raw/Smart");
        this.spiceOutputFormatPopup.setSelectedItem(this.spiceOutputFormatInitial);
        this.spiceUseParasiticsInitial = Simulation.isSpiceUseParasitics();
        this.spiceUseParasitics.setSelected(this.spiceUseParasiticsInitial);
        this.spiceUseNodeNamesInitial = Simulation.isSpiceUseNodeNames();
        this.spiceUseNodeNames.setSelected(this.spiceUseNodeNamesInitial);
        this.spiceForceGlobalPwrGndInitial = Simulation.isSpiceForceGlobalPwrGnd();
        this.spiceForceGlobalPwrGnd.setSelected(this.spiceForceGlobalPwrGndInitial);
        this.spiceUseCellParametersInitial = Simulation.isSpiceUseCellParameters();
        this.spiceUseCellParameters.setSelected(this.spiceUseCellParametersInitial);
        this.spiceWriteTransSizesInLambdaInitial = Simulation.isSpiceWriteTransSizeInLambda();
        this.spiceWriteTransSizesInLambda.setSelected(this.spiceWriteTransSizesInLambdaInitial);
        this.spiceRunDirInitial = Simulation.getSpiceRunDir();
        this.useDir.setText(this.spiceRunDirInitial);
        this.spiceUseRunDirInitial = Simulation.getSpiceUseRunDir();
        this.useDirCheckBox.setSelected(this.spiceUseRunDirInitial);
        this.overwriteOutputFileInitial = Simulation.getSpiceOutputOverwrite();
        this.overwriteOutputFile.setSelected(this.overwriteOutputFileInitial);
        this.spiceRunProbeInitial = Simulation.getSpiceRunProbe();
        this.spiceRunProbe.setSelected(this.spiceRunProbeInitial);
        this.spiceRunProgramInitial = Simulation.getSpiceRunProgram();
        this.spiceRunProgram.setText(this.spiceRunProgramInitial);
        this.spiceRunProgramArgsInitial = Simulation.getSpiceRunProgramArgs();
        this.spiceRunProgramArgs.setText(this.spiceRunProgramArgsInitial);
        this.spicePartsLibraryInitial = Simulation.getSpicePartsLibrary();
        String[] libFiles = LibFile.getSpicePartsLibraries();
        for (int i = 0; i < libFiles.length; ++i) {
            this.spicePrimitivesetPopup.addItem(libFiles[i]);
        }
        this.spicePrimitivesetPopup.setSelectedItem(this.spicePartsLibraryInitial);
        String[] runChoices = Simulation.getSpiceRunChoiceValues();
        for (int i = 0; i < runChoices.length; ++i) {
            this.spiceRunPopup.addItem(runChoices[i]);
        }
        this.spiceRunPopupInitial = Simulation.getSpiceRunChoice();
        this.spiceRunPopup.setSelectedItem(this.spiceRunPopupInitial);
        if (this.spiceRunPopup.getSelectedIndex() == 0) {
            this.setSpiceRunOptionsEnabled(false);
        } else {
            this.setSpiceRunOptionsEnabled(true);
        }
        this.spiceTechnology.setText("For technology " + this.curTech.getTechName());
        this.spiceLayerResistanceOptions = new HashMap();
        this.spiceLayerCapacitanceOptions = new HashMap();
        this.spiceLayerEdgeCapacitanceOptions = new HashMap();
        Iterator it = this.curTech.getLayers();
        while (it.hasNext()) {
            Layer layer = (Layer)it.next();
            this.spiceLayerResistanceOptions.put(layer, Pref.makeDoublePref(null, null, layer.getResistance()));
            this.spiceLayerCapacitanceOptions.put(layer, Pref.makeDoublePref(null, null, layer.getCapacitance()));
            this.spiceLayerEdgeCapacitanceOptions.put(layer, Pref.makeDoublePref(null, null, layer.getEdgeCapacitance()));
        }
        this.spiceLayerListModel = new DefaultListModel();
        this.spiceLayerList = new JList(this.spiceLayerListModel);
        this.spiceLayerList.setSelectionMode(0);
        this.spiceLayer.setViewportView(this.spiceLayerList);
        this.spiceLayerList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                SpiceTab.this.spiceLayerListClick();
            }
        });
        this.showLayersInTechnology(this.spiceLayerListModel);
        this.spiceLayerList.setSelectedIndex(0);
        this.spiceLayerListClick();
        this.spiceResistance.getDocument().addDocumentListener(new LayerDocumentListener(this.spiceLayerResistanceOptions, this.spiceLayerList, this.curTech));
        this.spiceCapacitance.getDocument().addDocumentListener(new LayerDocumentListener(this.spiceLayerCapacitanceOptions, this.spiceLayerList, this.curTech));
        this.spiceEdgeCapacitance.getDocument().addDocumentListener(new LayerDocumentListener(this.spiceLayerEdgeCapacitanceOptions, this.spiceLayerList, this.curTech));
        this.spiceTechMinResistanceInitial = this.curTech.getMinResistance();
        this.spiceMinResistance.setText(Double.toString(this.spiceTechMinResistanceInitial));
        this.spiceTechMinCapacitanceInitial = this.curTech.getMinCapacitance();
        this.spiceMinCapacitance.setText(Double.toString(this.spiceTechMinCapacitanceInitial));
        this.spiceHeaderCardInitial = Simulation.getSpiceHeaderCardInfo();
        if (this.spiceHeaderCardInitial.length() == 0) {
            this.spiceNoHeaderCards.setSelected(true);
        } else if (this.spiceHeaderCardInitial.startsWith("Extension ")) {
            this.spiceHeaderCardsWithExtension.setSelected(true);
            this.spiceHeaderCardExtension.setText(this.spiceHeaderCardInitial.substring("Extension ".length()));
        } else {
            this.spiceHeaderCardsFromFile.setSelected(true);
            this.spiceHeaderCardFile.setText(this.spiceHeaderCardInitial);
        }
        this.spiceTrailerCardInitial = Simulation.getSpiceTrailerCardInfo();
        if (this.spiceTrailerCardInitial.length() == 0) {
            this.spiceNoTrailerCards.setSelected(true);
        } else if (this.spiceTrailerCardInitial.startsWith("Extension ")) {
            this.spiceTrailerCardsWithExtension.setSelected(true);
            this.spiceTrailerCardExtension.setText(this.spiceTrailerCardInitial.substring("Extension ".length()));
        } else {
            this.spiceTrailerCardsFromFile.setSelected(true);
            this.spiceTrailerCardFile.setText(this.spiceTrailerCardInitial);
        }
        this.spiceBrowseHeaderFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpiceTab.this.spiceBrowseHeaderFileActionPerformed();
            }
        });
        this.spiceBrowseTrailerFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpiceTab.this.spiceBrowseTrailerFileActionPerformed();
            }
        });
        this.spiceCellModelOptions = new HashMap();
        this.spiceCellListModel = new DefaultListModel();
        this.spiceCellList = new JList(this.spiceCellListModel);
        this.spiceCellList.setSelectionMode(0);
        this.spiceCell.setViewportView(this.spiceCellList);
        it = this.curLib.getCells();
        while (it.hasNext()) {
            Cell cell = (Cell)it.next();
            this.spiceCellListModel.addElement(cell.noLibDescribe());
            String modelFile = "";
            Variable var = cell.getVar(Spice.SPICE_MODEL_FILE_KEY, class$java$lang$String == null ? SpiceTab.class$("java.lang.String") : class$java$lang$String);
            if (var != null) {
                modelFile = (String)var.getObject();
            }
            this.spiceCellModelOptions.put(cell, Pref.makeStringPref(null, null, modelFile));
        }
        this.spiceCellList.setSelectedIndex(0);
        this.spiceCellList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                SpiceTab.this.spiceCellListClick();
            }
        });
        this.spiceModelFileBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpiceTab.this.spiceModelFileBrowseActionPerformed();
            }
        });
        this.spiceDeriveModelFromCircuit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpiceTab.this.spiceCellModelButtonClick();
            }
        });
        this.spiceUseModelFromFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpiceTab.this.spiceCellModelButtonClick();
            }
        });
        this.spiceModelCell.getDocument().addDocumentListener(new SpiceModelDocumentListener(this));
        this.spiceCellListClick();
    }

    private void showLayersInTechnology(DefaultListModel model) {
        model.clear();
        Iterator it = this.curTech.getLayers();
        while (it.hasNext()) {
            Layer layer = (Layer)it.next();
            model.addElement(layer.getName());
        }
    }

    private void spiceCellModelButtonClick() {
        if (this.spiceDeriveModelFromCircuit.isSelected()) {
            this.spiceModelCell.setText("");
        }
    }

    private void spiceCellListClick() {
        if (this.spiceCellListModel.size() == 0) {
            return;
        }
        String cellName = (String)this.spiceCellList.getSelectedValue();
        Cell cell = this.curLib.findNodeProto(cellName);
        if (cell != null) {
            Pref pref = (Pref)this.spiceCellModelOptions.get(cell);
            String modelFile = pref.getString();
            this.spiceModelFileChanging = true;
            this.spiceModelCell.setText(modelFile);
            if (modelFile.length() == 0) {
                this.spiceDeriveModelFromCircuit.setSelected(true);
            } else {
                this.spiceUseModelFromFile.setSelected(true);
            }
            this.spiceModelFileChanging = false;
        }
    }

    private void spiceModelFileBrowseActionPerformed() {
        String fileName = OpenFile.chooseInputFile(OpenFile.Type.ANY, null);
        if (fileName == null) {
            return;
        }
        this.spiceUseModelFromFile.setSelected(true);
        this.spiceModelCell.setText(fileName);
    }

    private void spiceModelFileChanged() {
        if (this.spiceModelFileChanging) {
            return;
        }
        String cellName = (String)this.spiceCellList.getSelectedValue();
        Cell cell = this.curLib.findNodeProto(cellName);
        if (cell != null) {
            Pref pref = (Pref)this.spiceCellModelOptions.get(cell);
            String typedString = this.spiceModelCell.getText();
            if (this.spiceDeriveModelFromCircuit.isSelected()) {
                typedString = "";
            }
            pref.setString(typedString);
        }
    }

    private void spiceBrowseTrailerFileActionPerformed() {
        String fileName = OpenFile.chooseInputFile(OpenFile.Type.ANY, null);
        if (fileName == null) {
            return;
        }
        this.spiceTrailerCardFile.setText(fileName);
        this.spiceTrailerCardsFromFile.setSelected(true);
    }

    private void spiceBrowseHeaderFileActionPerformed() {
        String fileName = OpenFile.chooseInputFile(OpenFile.Type.ANY, null);
        if (fileName == null) {
            return;
        }
        this.spiceHeaderCardFile.setText(fileName);
        this.spiceHeaderCardsFromFile.setSelected(true);
    }

    public void term() {
        double doubleNow;
        boolean booleanNow;
        String stringNow;
        int intNow = this.spiceEnginePopup.getSelectedIndex();
        if (this.spiceEngineInitial != intNow) {
            Simulation.setSpiceEngine(intNow);
        }
        if (!this.spiceLevelInitial.equals(stringNow = (String)this.spiceLevelPopup.getSelectedItem())) {
            Simulation.setSpiceLevel(stringNow);
        }
        if (!this.spiceOutputFormatInitial.equals(stringNow = (String)this.spiceOutputFormatPopup.getSelectedItem())) {
            Simulation.setSpiceOutputFormat(stringNow);
        }
        if (!this.spicePartsLibraryInitial.equals(stringNow = (String)this.spicePrimitivesetPopup.getSelectedItem())) {
            Simulation.setSpicePartsLibrary(stringNow);
        }
        if (this.spiceUseNodeNamesInitial != (booleanNow = this.spiceUseNodeNames.isSelected())) {
            Simulation.setSpiceUseNodeNames(booleanNow);
        }
        if (this.spiceForceGlobalPwrGndInitial != (booleanNow = this.spiceForceGlobalPwrGnd.isSelected())) {
            Simulation.setSpiceForceGlobalPwrGnd(booleanNow);
        }
        if (this.spiceUseCellParametersInitial != (booleanNow = this.spiceUseCellParameters.isSelected())) {
            Simulation.setSpiceUseCellParameters(booleanNow);
        }
        if (this.spiceWriteTransSizesInLambdaInitial != (booleanNow = this.spiceWriteTransSizesInLambda.isSelected())) {
            Simulation.setSpiceWriteTransSizeInLambda(booleanNow);
        }
        if (this.spiceUseParasiticsInitial != (booleanNow = this.spiceUseParasitics.isSelected())) {
            Simulation.setSpiceUseParasitics(booleanNow);
        }
        if (!this.spiceRunPopupInitial.equals(stringNow = (String)this.spiceRunPopup.getSelectedItem())) {
            Simulation.setSpiceRunChoice(stringNow);
        }
        if (!this.spiceRunDirInitial.equals(stringNow = this.useDir.getText())) {
            Simulation.setSpiceRunDir(stringNow);
        }
        if (this.spiceUseRunDirInitial != (booleanNow = this.useDirCheckBox.isSelected())) {
            Simulation.setSpiceUseRunDir(booleanNow);
        }
        if (this.overwriteOutputFileInitial != (booleanNow = this.overwriteOutputFile.isSelected())) {
            Simulation.setSpiceOutputOverwrite(booleanNow);
        }
        if (this.spiceRunProbeInitial != (booleanNow = this.spiceRunProbe.isSelected())) {
            Simulation.setSpiceRunProbe(booleanNow);
        }
        if (!this.spiceRunProgramInitial.equals(stringNow = this.spiceRunProgram.getText())) {
            Simulation.setSpiceRunProgram(stringNow);
        }
        if (!this.spiceRunProgramArgsInitial.equals(stringNow = this.spiceRunProgramArgs.getText())) {
            Simulation.setSpiceRunProgramArgs(stringNow);
        }
        if (this.spiceTechMinResistanceInitial != (doubleNow = TextUtils.atof(this.spiceMinResistance.getText()))) {
            this.curTech.setMinResistance(doubleNow);
        }
        if (this.spiceTechMinCapacitanceInitial != (doubleNow = TextUtils.atof(this.spiceMinCapacitance.getText()))) {
            this.curTech.setMinCapacitance(doubleNow);
        }
        Iterator it = this.curTech.getLayers();
        while (it.hasNext()) {
            Pref edgeCapacitancePref;
            Pref capacitancePref;
            Layer layer = (Layer)it.next();
            Pref resistancePref = (Pref)this.spiceLayerResistanceOptions.get(layer);
            if (resistancePref != null && resistancePref.getDoubleFactoryValue() != resistancePref.getDouble()) {
                layer.setResistance(resistancePref.getDouble());
            }
            if ((capacitancePref = (Pref)this.spiceLayerCapacitanceOptions.get(layer)) != null && capacitancePref.getDoubleFactoryValue() != capacitancePref.getDouble()) {
                layer.setCapacitance(capacitancePref.getDouble());
            }
            if ((edgeCapacitancePref = (Pref)this.spiceLayerEdgeCapacitanceOptions.get(layer)) == null || edgeCapacitancePref.getDoubleFactoryValue() == edgeCapacitancePref.getDouble()) continue;
            layer.setEdgeCapacitance(edgeCapacitancePref.getDouble());
        }
        String header = "";
        if (this.spiceHeaderCardsWithExtension.isSelected()) {
            header = "Extension " + this.spiceHeaderCardExtension.getText();
        } else if (this.spiceHeaderCardsFromFile.isSelected()) {
            header = this.spiceHeaderCardFile.getText();
        }
        if (!this.spiceHeaderCardInitial.equals(header)) {
            Simulation.setSpiceHeaderCardInfo(header);
        }
        String trailer = "";
        if (this.spiceTrailerCardsWithExtension.isSelected()) {
            trailer = "Extension " + this.spiceTrailerCardExtension.getText();
        } else if (this.spiceTrailerCardsFromFile.isSelected()) {
            trailer = this.spiceTrailerCardFile.getText();
        }
        if (!this.spiceTrailerCardInitial.equals(trailer)) {
            Simulation.setSpiceTrailerCardInfo(trailer);
        }
        Iterator it2 = this.curLib.getCells();
        while (it2.hasNext()) {
            Cell cell = (Cell)it2.next();
            Pref pref = (Pref)this.spiceCellModelOptions.get(cell);
            if (pref == null || pref.getStringFactoryValue().equals(pref.getString())) continue;
            String fileName = pref.getString().trim();
            if (fileName.length() == 0) {
                cell.delVar(Spice.SPICE_MODEL_FILE_KEY);
                continue;
            }
            cell.newVar(Spice.SPICE_MODEL_FILE_KEY, (Object)fileName);
        }
    }

    private void spiceLayerListClick() {
        String layerName = (String)this.spiceLayerList.getSelectedValue();
        Layer layer = this.curTech.findLayer(layerName);
        if (layer != null) {
            Pref resistancePref = (Pref)this.spiceLayerResistanceOptions.get(layer);
            this.spiceResistance.setText(Double.toString(resistancePref.getDouble()));
            Pref capacitancePref = (Pref)this.spiceLayerCapacitanceOptions.get(layer);
            this.spiceCapacitance.setText(Double.toString(capacitancePref.getDouble()));
            Pref edgeCapacitancePref = (Pref)this.spiceLayerEdgeCapacitanceOptions.get(layer);
            this.spiceEdgeCapacitance.setText(Double.toString(edgeCapacitancePref.getDouble()));
        }
    }

    private void setSpiceRunOptionsEnabled(boolean enabled) {
        this.useDirCheckBox.setEnabled(enabled);
        this.overwriteOutputFile.setEnabled(enabled);
        this.spiceRunProgram.setEnabled(enabled);
        this.spiceRunProgramArgs.setEnabled(enabled);
        this.spiceRunHelp.setEnabled(enabled);
        this.spiceRunProbe.setEnabled(enabled);
        if (enabled) {
            this.spiceRunProgram.setBackground(Color.white);
            if (!this.useDirCheckBox.isSelected()) {
                this.useDir.setEnabled(false);
                this.useDir.setBackground(this.spice2.getBackground());
            } else {
                this.useDir.setEnabled(true);
                this.useDir.setBackground(Color.white);
            }
        } else {
            this.spiceRunProgram.setBackground(this.spice2.getBackground());
            this.useDir.setBackground(this.spice2.getBackground());
            this.useDir.setEnabled(false);
        }
    }

    private void initComponents() {
        this.spiceHeader = new ButtonGroup();
        this.spiceTrailer = new ButtonGroup();
        this.spiceModel = new ButtonGroup();
        this.spice = new JPanel();
        this.spice1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.spiceRunPopup = new JComboBox();
        this.spiceEnginePopup = new JComboBox();
        this.spiceLevelPopup = new JComboBox();
        this.spiceOutputFormatPopup = new JComboBox();
        this.spiceUseParasitics = new JCheckBox();
        this.spiceUseNodeNames = new JCheckBox();
        this.spiceForceGlobalPwrGnd = new JCheckBox();
        this.spiceUseCellParameters = new JCheckBox();
        this.spiceWriteTransSizesInLambda = new JCheckBox();
        this.spice2 = new JPanel();
        this.spiceRunProgram = new JTextField();
        this.jLabel17 = new JLabel();
        this.useDirCheckBox = new JCheckBox();
        this.useDir = new JTextField();
        this.overwriteOutputFile = new JCheckBox();
        this.spiceRunHelp = new JButton();
        this.jLabel3 = new JLabel();
        this.spiceRunProgramArgs = new JTextField();
        this.spiceRunProbe = new JCheckBox();
        this.spice3 = new JPanel();
        this.jLabel13 = new JLabel();
        this.spicePrimitivesetPopup = new JComboBox();
        this.jSeparator1 = new JSeparator();
        this.spice4 = new JPanel();
        this.spiceLayer = new JScrollPane();
        this.jLabel7 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.spiceTechnology = new JLabel();
        this.spiceResistance = new JTextField();
        this.spiceCapacitance = new JTextField();
        this.spiceEdgeCapacitance = new JTextField();
        this.jLabel18 = new JLabel();
        this.spiceMinResistance = new JTextField();
        this.jLabel19 = new JLabel();
        this.spiceMinCapacitance = new JTextField();
        this.jSeparator2 = new JSeparator();
        this.spice5 = new JPanel();
        this.spiceHeaderCardExtension = new JTextField();
        this.spiceNoHeaderCards = new JRadioButton();
        this.spiceHeaderCardsWithExtension = new JRadioButton();
        this.spiceHeaderCardsFromFile = new JRadioButton();
        this.spiceNoTrailerCards = new JRadioButton();
        this.spiceTrailerCardsWithExtension = new JRadioButton();
        this.spiceTrailerCardsFromFile = new JRadioButton();
        this.spiceHeaderCardFile = new JTextField();
        this.spiceBrowseHeaderFile = new JButton();
        this.spiceTrailerCardExtension = new JTextField();
        this.spiceTrailerCardFile = new JTextField();
        this.spiceBrowseTrailerFile = new JButton();
        this.jSeparator4 = new JSeparator();
        this.jSeparator3 = new JSeparator();
        this.spice6 = new JPanel();
        this.spiceCell = new JScrollPane();
        this.jLabel8 = new JLabel();
        this.spiceDeriveModelFromCircuit = new JRadioButton();
        this.spiceUseModelFromFile = new JRadioButton();
        this.spiceModelFileBrowse = new JButton();
        this.spiceModelCell = new JTextField();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Spice Preferences");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                SpiceTab.this.closeDialog(evt);
            }
        });
        this.spice.setLayout(new GridBagLayout());
        this.spice.setToolTipText("Options for Spice deck generation");
        this.spice1.setLayout(new GridBagLayout());
        this.jLabel1.setText("Spice Engine:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.5;
        this.spice1.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel9.setText("Spice Level:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.spice1.add((Component)this.jLabel9, gridBagConstraints);
        this.jLabel10.setText("Output format:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.spice1.add((Component)this.jLabel10, gridBagConstraints);
        this.spiceRunPopup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpiceTab.this.spiceRunPopupActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.spice1.add((Component)this.spiceRunPopup, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.spice1.add((Component)this.spiceEnginePopup, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.spice1.add((Component)this.spiceLevelPopup, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.spice1.add((Component)this.spiceOutputFormatPopup, gridBagConstraints);
        this.spiceUseParasitics.setText("Use Parasitics");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.spice1.add((Component)this.spiceUseParasitics, gridBagConstraints);
        this.spiceUseNodeNames.setText("Use Node Names");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.spice1.add((Component)this.spiceUseNodeNames, gridBagConstraints);
        this.spiceForceGlobalPwrGnd.setText("Force Global VDD/GND");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.spice1.add((Component)this.spiceForceGlobalPwrGnd, gridBagConstraints);
        this.spiceUseCellParameters.setText("Use Cell Parameters");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.spice1.add((Component)this.spiceUseCellParameters, gridBagConstraints);
        this.spiceWriteTransSizesInLambda.setText("Write Trans Sizes in Units");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.spice1.add((Component)this.spiceWriteTransSizesInLambda, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.spice.add((Component)this.spice1, gridBagConstraints);
        this.spice2.setLayout(new GridBagLayout());
        this.spice2.setBorder(new EtchedBorder());
        this.spiceRunProgram.setColumns(8);
        this.spiceRunProgram.setMinimumSize(new Dimension(100, 20));
        this.spiceRunProgram.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.spice2.add((Component)this.spiceRunProgram, gridBagConstraints);
        this.jLabel17.setText("Run Program:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.spice2.add((Component)this.jLabel17, gridBagConstraints);
        this.useDirCheckBox.setText("Use Dir:");
        this.useDirCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpiceTab.this.useDirCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.spice2.add((Component)this.useDirCheckBox, gridBagConstraints);
        this.useDir.setColumns(8);
        this.useDir.setText("jTextField1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.spice2.add((Component)this.useDir, gridBagConstraints);
        this.overwriteOutputFile.setText("Overwrite existing output file (no prompts)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.spice2.add((Component)this.overwriteOutputFile, gridBagConstraints);
        this.spiceRunHelp.setText("help");
        this.spiceRunHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpiceTab.this.spiceRunHelpActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.spice2.add((Component)this.spiceRunHelp, gridBagConstraints);
        this.jLabel3.setText("with args:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.spice2.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.spice2.add((Component)this.spiceRunProgramArgs, gridBagConstraints);
        this.spiceRunProbe.setText("Run probe");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        this.spice2.add((Component)this.spiceRunProbe, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.spice.add((Component)this.spice2, gridBagConstraints);
        this.spice3.setLayout(new GridBagLayout());
        this.jLabel13.setText("Spice primitive set:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.5;
        this.spice3.add((Component)this.jLabel13, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.spice3.add((Component)this.spicePrimitivesetPopup, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.spice.add((Component)this.spice3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.spice.add((Component)this.jSeparator1, gridBagConstraints);
        this.spice4.setLayout(new GridBagLayout());
        this.spiceLayer.setMinimumSize(new Dimension(200, 50));
        this.spiceLayer.setPreferredSize(new Dimension(200, 50));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.spice4.add((Component)this.spiceLayer, gridBagConstraints);
        this.jLabel7.setText("Layer:");
        this.jLabel7.setVerticalAlignment(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 11;
        this.spice4.add((Component)this.jLabel7, gridBagConstraints);
        this.jLabel2.setText("Edge Cap:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        this.spice4.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel11.setText("Resistance:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.spice4.add((Component)this.jLabel11, gridBagConstraints);
        this.jLabel12.setText("Capacitance:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.spice4.add((Component)this.jLabel12, gridBagConstraints);
        this.spiceTechnology.setText("Technology: xxx");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.spice4.add((Component)this.spiceTechnology, gridBagConstraints);
        this.spiceResistance.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.spice4.add((Component)this.spiceResistance, gridBagConstraints);
        this.spiceCapacitance.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.spice4.add((Component)this.spiceCapacitance, gridBagConstraints);
        this.spiceEdgeCapacitance.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.spice4.add((Component)this.spiceEdgeCapacitance, gridBagConstraints);
        this.jLabel18.setText("Min. Resistance:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.spice4.add((Component)this.jLabel18, gridBagConstraints);
        this.spiceMinResistance.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.spice4.add((Component)this.spiceMinResistance, gridBagConstraints);
        this.jLabel19.setText("Min. Capacitance:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        this.spice4.add((Component)this.jLabel19, gridBagConstraints);
        this.spiceMinCapacitance.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.spice4.add((Component)this.spiceMinCapacitance, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        this.spice.add((Component)this.spice4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.spice.add((Component)this.jSeparator2, gridBagConstraints);
        this.spice5.setLayout(new GridBagLayout());
        this.spiceHeaderCardExtension.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.spice5.add((Component)this.spiceHeaderCardExtension, gridBagConstraints);
        this.spiceNoHeaderCards.setText("No Header Cards");
        this.spiceHeader.add(this.spiceNoHeaderCards);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.spice5.add((Component)this.spiceNoHeaderCards, gridBagConstraints);
        this.spiceHeaderCardsWithExtension.setText("Use Header Cards with extension:");
        this.spiceHeader.add(this.spiceHeaderCardsWithExtension);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.spice5.add((Component)this.spiceHeaderCardsWithExtension, gridBagConstraints);
        this.spiceHeaderCardsFromFile.setText("Use Header Cards from File:");
        this.spiceHeader.add(this.spiceHeaderCardsFromFile);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.spice5.add((Component)this.spiceHeaderCardsFromFile, gridBagConstraints);
        this.spiceNoTrailerCards.setText("No Trailer Cards");
        this.spiceTrailer.add(this.spiceNoTrailerCards);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        this.spice5.add((Component)this.spiceNoTrailerCards, gridBagConstraints);
        this.spiceTrailerCardsWithExtension.setText("Use Trailer Cards with extension:");
        this.spiceTrailer.add(this.spiceTrailerCardsWithExtension);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.spice5.add((Component)this.spiceTrailerCardsWithExtension, gridBagConstraints);
        this.spiceTrailerCardsFromFile.setText("Use Trailer Cards from File:");
        this.spiceTrailer.add(this.spiceTrailerCardsFromFile);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        this.spice5.add((Component)this.spiceTrailerCardsFromFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.spice5.add((Component)this.spiceHeaderCardFile, gridBagConstraints);
        this.spiceBrowseHeaderFile.setText("Browse");
        this.spiceBrowseHeaderFile.setMinimumSize(new Dimension(78, 20));
        this.spiceBrowseHeaderFile.setPreferredSize(new Dimension(78, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.spice5.add((Component)this.spiceBrowseHeaderFile, gridBagConstraints);
        this.spiceTrailerCardExtension.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.spice5.add((Component)this.spiceTrailerCardExtension, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.spice5.add((Component)this.spiceTrailerCardFile, gridBagConstraints);
        this.spiceBrowseTrailerFile.setText("Browse");
        this.spiceBrowseTrailerFile.setMinimumSize(new Dimension(78, 20));
        this.spiceBrowseTrailerFile.setPreferredSize(new Dimension(78, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.spice5.add((Component)this.spiceBrowseTrailerFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        this.spice5.add((Component)this.jSeparator4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.spice.add((Component)this.spice5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.spice.add((Component)this.jSeparator3, gridBagConstraints);
        this.spice6.setLayout(new GridBagLayout());
        this.spiceCell.setMinimumSize(new Dimension(200, 100));
        this.spiceCell.setPreferredSize(new Dimension(200, 100));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.spice6.add((Component)this.spiceCell, gridBagConstraints);
        this.jLabel8.setText("For Cell");
        this.jLabel8.setVerticalAlignment(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.spice6.add((Component)this.jLabel8, gridBagConstraints);
        this.spiceDeriveModelFromCircuit.setText("Derive Model from Circuitry");
        this.spiceModel.add(this.spiceDeriveModelFromCircuit);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.spice6.add((Component)this.spiceDeriveModelFromCircuit, gridBagConstraints);
        this.spiceUseModelFromFile.setText("Use Model from File:");
        this.spiceModel.add(this.spiceUseModelFromFile);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.spice6.add((Component)this.spiceUseModelFromFile, gridBagConstraints);
        this.spiceModelFileBrowse.setText("Browse");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.spice6.add((Component)this.spiceModelFileBrowse, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.spice6.add((Component)this.spiceModelCell, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        this.spice.add((Component)this.spice6, gridBagConstraints);
        this.getContentPane().add((Component)this.spice, new GridBagConstraints());
        this.pack();
    }

    private void spiceRunPopupActionPerformed(ActionEvent evt) {
        if (this.spiceRunPopup.getSelectedIndex() == 0) {
            this.setSpiceRunOptionsEnabled(false);
        } else {
            this.setSpiceRunOptionsEnabled(true);
        }
    }

    private void spiceRunHelpActionPerformed(ActionEvent evt) {
        String[] message = new String[]{"IMPORTANT: This executes a single program with the given args.  It does NOT run a command-line command.", "For example, 'echo blah > file' will NOT work. Encapsulate it in a script if you want to do such things.", "-----------------", "The following variables are available to use in the program name and arguments:", "   ${WORKING_DIR}:  The current working directory", "   ${USE_DIR}:  The Use Dir field, if specified (otherwise defaults to WORKING_DIR)", "   ${FILENAME}:  The output file name (with extension)", "   ${FILENAME_NO_EXT}:  The output file name (without extension)", "Example: Program: \"hspice\".  Args: \"${FILENAME}\""};
        JOptionPane.showMessageDialog(this, message, "Spice Run Help", 1);
    }

    private void useDirCheckBoxActionPerformed(ActionEvent evt) {
        boolean b = this.useDirCheckBox.isSelected();
        this.useDir.setEnabled(b);
        if (b) {
            this.useDir.setBackground(Color.white);
        } else {
            this.useDir.setBackground(this.spice2.getBackground());
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class LayerDocumentListener
    implements DocumentListener {
        HashMap optionMap;
        JList list;
        Technology tech;

        LayerDocumentListener(HashMap optionMap, JList list, Technology tech) {
            this.optionMap = optionMap;
            this.list = list;
            this.tech = tech;
        }

        private void change(DocumentEvent e) {
            String text;
            String layerName = (String)this.list.getSelectedValue();
            Layer layer = this.tech.findLayer(layerName);
            if (layer == null) {
                return;
            }
            Document doc = e.getDocument();
            int len = doc.getLength();
            try {
                text = doc.getText(0, len);
            }
            catch (BadLocationException ex) {
                return;
            }
            Pref pref = (Pref)this.optionMap.get(layer);
            double v = TextUtils.atof(text);
            pref.setDouble(v);
        }

        public void changedUpdate(DocumentEvent e) {
            this.change(e);
        }

        public void insertUpdate(DocumentEvent e) {
            this.change(e);
        }

        public void removeUpdate(DocumentEvent e) {
            this.change(e);
        }
    }

    private static class SpiceModelDocumentListener
    implements DocumentListener {
        SpiceTab dialog;

        SpiceModelDocumentListener(SpiceTab dialog) {
            this.dialog = dialog;
        }

        public void changedUpdate(DocumentEvent e) {
            this.dialog.spiceModelFileChanged();
        }

        public void insertUpdate(DocumentEvent e) {
            this.dialog.spiceModelFileChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            this.dialog.spiceModelFileChanged();
        }
    }
}

