/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.EditWindow;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class LayerVisibility
extends EDialog {
    private Box layerBox;
    private List layerList;
    private HashMap visibility;
    private boolean initialTextOnNode;
    private boolean initialTextOnArc;
    private boolean initialTextOnPort;
    private boolean initialTextOnExport;
    private boolean initialTextOnAnnotation;
    private boolean initialTextOnInstance;
    private boolean initialTextOnCell;
    private JButton allInvisible;
    private JButton allVisible;
    private JCheckBox annotationText;
    private JButton apply;
    private JCheckBox arcText;
    private JButton cancel;
    private JCheckBox cellText;
    private JCheckBox exportText;
    private JCheckBox instanceNames;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JScrollPane layerPane;
    private JCheckBox nodeText;
    private JButton ok;
    private JCheckBox portText;
    private JComboBox technology;

    public LayerVisibility(Frame parent, boolean modal) {
        super(parent, modal);
        Technology tech;
        this.initComponents();
        this.initialTextOnNode = User.isTextVisibilityOnNode();
        this.nodeText.setSelected(this.initialTextOnNode);
        this.initialTextOnArc = User.isTextVisibilityOnArc();
        this.arcText.setSelected(this.initialTextOnArc);
        this.initialTextOnPort = User.isTextVisibilityOnPort();
        this.portText.setSelected(this.initialTextOnPort);
        this.initialTextOnExport = User.isTextVisibilityOnExport();
        this.exportText.setSelected(this.initialTextOnExport);
        this.initialTextOnAnnotation = User.isTextVisibilityOnAnnotation();
        this.annotationText.setSelected(this.initialTextOnAnnotation);
        this.initialTextOnInstance = User.isTextVisibilityOnInstance();
        this.instanceNames.setSelected(this.initialTextOnInstance);
        this.initialTextOnCell = User.isTextVisibilityOnCell();
        this.cellText.setSelected(this.initialTextOnCell);
        this.visibility = new HashMap();
        Iterator it = Technology.getTechnologiesSortedByName().iterator();
        while (it.hasNext()) {
            tech = (Technology)it.next();
            Iterator lIt = tech.getLayers();
            while (lIt.hasNext()) {
                Layer layer = (Layer)lIt.next();
                this.visibility.put(layer, new Boolean(layer.isVisible()));
            }
        }
        it = Technology.getTechnologiesSortedByName().iterator();
        while (it.hasNext()) {
            tech = (Technology)it.next();
            this.technology.addItem(tech.getTechName());
        }
        this.technology.setSelectedItem(Technology.getCurrent().getTechName());
    }

    protected void escapePressed() {
        this.cancelActionPerformed(null);
    }

    private void termDialog() {
        boolean currentTextOnCell;
        boolean currentTextOnInstance;
        boolean currentTextOnAnnotation;
        boolean currentTextOnExport;
        boolean currentTextOnPort;
        boolean currentTextOnArc;
        Iterator it = Technology.getTechnologiesSortedByName().iterator();
        while (it.hasNext()) {
            Technology tech = (Technology)it.next();
            Iterator lIt = tech.getLayers();
            while (lIt.hasNext()) {
                Layer layer = (Layer)lIt.next();
                Boolean layerVis = (Boolean)this.visibility.get(layer);
                layer.setVisible(layerVis);
            }
        }
        boolean currentTextOnNode = this.nodeText.isSelected();
        if (currentTextOnNode != this.initialTextOnNode) {
            this.initialTextOnNode = currentTextOnNode;
            User.setTextVisibilityOnNode(this.initialTextOnNode);
        }
        if ((currentTextOnArc = this.arcText.isSelected()) != this.initialTextOnArc) {
            this.initialTextOnArc = currentTextOnArc;
            User.setTextVisibilityOnArc(this.initialTextOnArc);
        }
        if ((currentTextOnPort = this.portText.isSelected()) != this.initialTextOnPort) {
            this.initialTextOnPort = currentTextOnPort;
            User.setTextVisibilityOnPort(this.initialTextOnPort);
        }
        if ((currentTextOnExport = this.exportText.isSelected()) != this.initialTextOnExport) {
            this.initialTextOnExport = currentTextOnExport;
            User.setTextVisibilityOnExport(this.initialTextOnExport);
        }
        if ((currentTextOnAnnotation = this.annotationText.isSelected()) != this.initialTextOnAnnotation) {
            this.initialTextOnAnnotation = currentTextOnAnnotation;
            User.setTextVisibilityOnAnnotation(this.initialTextOnAnnotation);
        }
        if ((currentTextOnInstance = this.instanceNames.isSelected()) != this.initialTextOnInstance) {
            this.initialTextOnInstance = currentTextOnInstance;
            User.setTextVisibilityOnInstance(this.initialTextOnInstance);
        }
        if ((currentTextOnCell = this.cellText.isSelected()) != this.initialTextOnCell) {
            this.initialTextOnCell = currentTextOnCell;
            User.setTextVisibilityOnCell(this.initialTextOnCell);
        }
        EditWindow.repaintAllContents();
    }

    private void showLayersForTechnology() {
        String techName = (String)this.technology.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        this.layerBox = Box.createVerticalBox();
        this.layerPane.setViewportView(this.layerBox);
        this.layerList = new ArrayList();
        Iterator it = tech.getLayers();
        while (it.hasNext()) {
            Layer layer = (Layer)it.next();
            this.layerList.add(layer);
            Boolean layerVisible = (Boolean)this.visibility.get(layer);
            String layerName = layer.getName();
            if ((layer.getFunctionExtras() & 0x1000) != 0) {
                layerName = layerName + " (for pins)";
            }
            JCheckBox cb = new JCheckBox(layerName);
            cb.setSelected(layerVisible);
            cb.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent evt) {
                    LayerVisibility.this.changedVisibilityBox(evt);
                }
            });
            this.layerBox.add(cb);
        }
    }

    private void changedVisibilityBox(MouseEvent evt) {
        String techName = (String)this.technology.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        JCheckBox cb = (JCheckBox)evt.getSource();
        String name = cb.getText();
        int spacePos = name.indexOf(32);
        if (spacePos >= 0) {
            name = name.substring(0, spacePos);
        }
        Layer layer = tech.findLayer(name);
        this.visibility.put(layer, new Boolean(cb.isSelected()));
    }

    private void setAllVisibility(boolean on) {
        String techName = (String)this.technology.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        Iterator it = tech.getLayers();
        while (it.hasNext()) {
            Layer layer = (Layer)it.next();
            this.visibility.put(layer, new Boolean(on));
        }
        this.showLayersForTechnology();
    }

    private void initComponents() {
        this.apply = new JButton();
        this.ok = new JButton();
        this.layerPane = new JScrollPane();
        this.technology = new JComboBox();
        this.jLabel1 = new JLabel();
        this.nodeText = new JCheckBox();
        this.arcText = new JCheckBox();
        this.portText = new JCheckBox();
        this.exportText = new JCheckBox();
        this.annotationText = new JCheckBox();
        this.instanceNames = new JCheckBox();
        this.cellText = new JCheckBox();
        this.allVisible = new JButton();
        this.allInvisible = new JButton();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.cancel = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Layer Visibility");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                LayerVisibility.this.closeDialog(evt);
            }
        });
        this.apply.setText("Apply");
        this.apply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerVisibility.this.apply(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.weightx = 0.5;
        this.getContentPane().add((Component)this.apply, gridBagConstraints);
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerVisibility.this.ok(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ok, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 8;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.layerPane, gridBagConstraints);
        this.technology.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerVisibility.this.technologyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.technology, gridBagConstraints);
        this.jLabel1.setText("Technology:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.nodeText.setText("Node text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 20, 4, 4);
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.nodeText, gridBagConstraints);
        this.arcText.setText("Arc text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 20, 4, 4);
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.arcText, gridBagConstraints);
        this.portText.setText("Port text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 20, 4, 4);
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.portText, gridBagConstraints);
        this.exportText.setText("Export text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 20, 4, 4);
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.exportText, gridBagConstraints);
        this.annotationText.setText("Annotation text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 20, 4, 4);
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.annotationText, gridBagConstraints);
        this.instanceNames.setText("Instance names");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 20, 4, 4);
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.instanceNames, gridBagConstraints);
        this.cellText.setText("Cell text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 20, 4, 4);
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.cellText, gridBagConstraints);
        this.allVisible.setText("All Visible");
        this.allVisible.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerVisibility.this.allVisibleActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.weightx = 0.5;
        this.getContentPane().add((Component)this.allVisible, gridBagConstraints);
        this.allInvisible.setText("All Invisible");
        this.allInvisible.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerVisibility.this.allInvisibleActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.weightx = 0.5;
        this.getContentPane().add((Component)this.allInvisible, gridBagConstraints);
        this.jLabel2.setText("Click to change visibility.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText("Marked layers are visibile.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setText("Text visibility options:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jLabel4, gridBagConstraints);
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerVisibility.this.cancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.cancel, gridBagConstraints);
        this.pack();
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void allVisibleActionPerformed(ActionEvent evt) {
        this.setAllVisibility(true);
    }

    private void allInvisibleActionPerformed(ActionEvent evt) {
        this.setAllVisibility(false);
    }

    private void technologyActionPerformed(ActionEvent evt) {
        this.showLayersForTechnology();
    }

    private void apply(ActionEvent evt) {
        this.termDialog();
    }

    private void ok(ActionEvent evt) {
        this.termDialog();
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

