/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.TextWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class FindText
extends EDialog {
    private static String lastFindTextMessage = null;
    private static String lastReplaceTextMessage = null;
    private static boolean iniCaseSensitive = false;
    private static boolean iniFindReverse = false;
    private String lastSearch = null;
    private JButton done;
    private JCheckBox caseSensitive;
    private JButton find;
    private JCheckBox findReverse;
    private JTextField findString;
    private JButton goToLine;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JTextField lineNumber;
    private JButton replace;
    private JButton replaceAll;
    private JButton replaceAndFind;
    private JTextField replaceString;

    public static void findTextDialog() {
        FindText dialog = new FindText((Frame)TopLevel.getCurrentJFrame(), false);
        dialog.setVisible(true);
    }

    private FindText(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        if (lastFindTextMessage != null) {
            this.findString.setText(lastFindTextMessage);
        }
        if (lastReplaceTextMessage != null) {
            this.replaceString.setText(lastReplaceTextMessage);
        }
        this.caseSensitive.setSelected(iniCaseSensitive);
        this.findReverse.setSelected(iniFindReverse);
        this.getRootPane().setDefaultButton(this.find);
    }

    protected void escapePressed() {
        this.doneActionPerformed(null);
    }

    private void initComponents() {
        this.jLabel4 = new JLabel();
        this.done = new JButton();
        this.findString = new JTextField();
        this.jLabel1 = new JLabel();
        this.replaceString = new JTextField();
        this.caseSensitive = new JCheckBox();
        this.findReverse = new JCheckBox();
        this.replace = new JButton();
        this.replaceAndFind = new JButton();
        this.replaceAll = new JButton();
        this.jLabel2 = new JLabel();
        this.lineNumber = new JTextField();
        this.find = new JButton();
        this.goToLine = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Search and Replace");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                FindText.this.closeDialog(evt);
            }
        });
        this.jLabel4.setText("Find:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel4, gridBagConstraints);
        this.done.setText("Done");
        this.done.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindText.this.doneActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.done, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.findString, gridBagConstraints);
        this.jLabel1.setText("Line Number:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.replaceString, gridBagConstraints);
        this.caseSensitive.setText("Case Sensitive");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.caseSensitive, gridBagConstraints);
        this.findReverse.setText("Find Reverse");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.findReverse, gridBagConstraints);
        this.replace.setText("Replace");
        this.replace.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindText.this.replaceActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.replace, gridBagConstraints);
        this.replaceAndFind.setText("Replace and Find");
        this.replaceAndFind.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindText.this.replaceAndFindActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.replaceAndFind, gridBagConstraints);
        this.replaceAll.setText("Replace All");
        this.replaceAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindText.this.replaceAllActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.replaceAll, gridBagConstraints);
        this.jLabel2.setText("Replace:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.lineNumber.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.lineNumber, gridBagConstraints);
        this.find.setText("Find");
        this.find.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindText.this.findActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.find, gridBagConstraints);
        this.goToLine.setText("Go To Line");
        this.goToLine.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindText.this.goToLineActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.goToLine, gridBagConstraints);
        this.pack();
    }

    private void goToLineActionPerformed(ActionEvent evt) {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        WindowContent content = wf.getContent();
        if (content instanceof TextWindow) {
            TextWindow tw = (TextWindow)content;
            int i = TextUtils.atoi(this.lineNumber.getText());
            tw.goToLineNumber(i);
            return;
        }
        System.out.println("Cannot access this window by line numbers");
    }

    private void replaceAllActionPerformed(ActionEvent evt) {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        String search = this.findString.getText();
        String replace = this.replaceString.getText();
        WindowContent content = wf.getContent();
        content.initTextSearch(search, this.caseSensitive.isSelected());
        content.replaceAllText(replace);
    }

    private void replaceAndFindActionPerformed(ActionEvent evt) {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        if (this.lastSearch == null) {
            return;
        }
        WindowContent content = wf.getContent();
        content.replaceText(this.replaceString.getText());
        if (!content.findNextText(this.findReverse.isSelected())) {
            this.lastSearch = null;
        }
    }

    private void replaceActionPerformed(ActionEvent evt) {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        if (this.lastSearch == null) {
            return;
        }
        WindowContent content = wf.getContent();
        content.replaceText(this.replaceString.getText());
    }

    private void findActionPerformed(ActionEvent evt) {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        String search = this.findString.getText();
        WindowContent content = wf.getContent();
        if (this.lastSearch != null && !this.lastSearch.equals(search)) {
            this.lastSearch = null;
        }
        if (this.lastSearch == null) {
            content.initTextSearch(search, this.caseSensitive.isSelected());
        }
        this.lastSearch = search;
        if (!content.findNextText(this.findReverse.isSelected())) {
            this.lastSearch = null;
        }
    }

    private void doneActionPerformed(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        lastFindTextMessage = this.findString.getText();
        lastReplaceTextMessage = this.replaceString.getText();
        iniCaseSensitive = this.caseSensitive.isSelected();
        iniFindReverse = this.findReverse.isSelected();
        this.setVisible(false);
        this.dispose();
    }
}

