/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.layout.DrcRings;
import com.sun.electric.tool.generator.layout.Gallery;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.gates.Inv;
import com.sun.electric.tool.generator.layout.gates.Inv2_star;
import com.sun.electric.tool.generator.layout.gates.Inv2i;
import com.sun.electric.tool.generator.layout.gates.Inv2iKn;
import com.sun.electric.tool.generator.layout.gates.Inv2iKp;
import com.sun.electric.tool.generator.layout.gates.InvCTLn;
import com.sun.electric.tool.generator.layout.gates.InvHT;
import com.sun.electric.tool.generator.layout.gates.InvLT;
import com.sun.electric.tool.generator.layout.gates.Inv_passgate;
import com.sun.electric.tool.generator.layout.gates.MullerC_sy;
import com.sun.electric.tool.generator.layout.gates.Nand2;
import com.sun.electric.tool.generator.layout.gates.Nand2HLT_sy;
import com.sun.electric.tool.generator.layout.gates.Nand2LT;
import com.sun.electric.tool.generator.layout.gates.Nand2LT_sy;
import com.sun.electric.tool.generator.layout.gates.Nand2PH;
import com.sun.electric.tool.generator.layout.gates.Nand2PHfk;
import com.sun.electric.tool.generator.layout.gates.Nand2_sy;
import com.sun.electric.tool.generator.layout.gates.Nand2en;
import com.sun.electric.tool.generator.layout.gates.Nand3;
import com.sun.electric.tool.generator.layout.gates.Nand3LT;
import com.sun.electric.tool.generator.layout.gates.Nand3LT_sy3;
import com.sun.electric.tool.generator.layout.gates.Nand3LTen;
import com.sun.electric.tool.generator.layout.gates.Nand3MLT;
import com.sun.electric.tool.generator.layout.gates.Nand3en;
import com.sun.electric.tool.generator.layout.gates.Nms1;
import com.sun.electric.tool.generator.layout.gates.Nms2;
import com.sun.electric.tool.generator.layout.gates.Nms2_sy;
import com.sun.electric.tool.generator.layout.gates.Nms3_sy3;
import com.sun.electric.tool.generator.layout.gates.Nor2;
import com.sun.electric.tool.generator.layout.gates.Nor2kresetV;
import com.sun.electric.tool.generator.layout.gates.Pms1;
import com.sun.electric.tool.generator.layout.gates.Pms2;
import com.sun.electric.tool.generator.layout.gates.Pms2_sy;
import com.sun.electric.tool.user.User;
import java.util.Properties;

public class GateRegression
extends Job {
    private static final DrcRings.Filter FILTER = new DrcRings.Filter(){

        public boolean skip(NodeInst ni) {
            return ni.getProto().getName().indexOf("mosWellTie_") != -1;
        }
    };
    private static int gateNb;

    private static void error(boolean pred, String msg) {
        LayoutLib.error(pred, msg);
    }

    private static boolean osIsWindows() {
        Properties props = System.getProperties();
        String osName = ((String)props.get("os.name")).toLowerCase();
        return osName.indexOf("windows") != -1;
    }

    private static void tracePass(double x) {
        System.out.println("\nbegin pass x=" + x);
        gateNb = 0;
    }

    private static void traceGate() {
        System.out.print(" " + gateNb++);
        System.out.flush();
    }

    private static void aPass(double x, StdCellParams stdCell) {
        GateRegression.tracePass(x);
        MullerC_sy.makePart(x, stdCell);
        GateRegression.traceGate();
        Nms1.makePart(x, stdCell);
        GateRegression.traceGate();
        Nms2.makePart(x, stdCell);
        GateRegression.traceGate();
        Nms2_sy.makePart(x, stdCell);
        GateRegression.traceGate();
        Nms3_sy3.makePart(x, stdCell);
        GateRegression.traceGate();
        Pms1.makePart(x, stdCell);
        GateRegression.traceGate();
        Pms2.makePart(x, stdCell);
        GateRegression.traceGate();
        Pms2_sy.makePart(x, stdCell);
        GateRegression.traceGate();
        Inv_passgate.makePart(x, stdCell);
        GateRegression.traceGate();
        Inv.makePart(x, stdCell);
        GateRegression.traceGate();
        Inv2_star.makePart(x, "", stdCell);
        GateRegression.traceGate();
        InvCTLn.makePart(x, stdCell);
        GateRegression.traceGate();
        InvLT.makePart(x, stdCell);
        GateRegression.traceGate();
        InvHT.makePart(x, stdCell);
        GateRegression.traceGate();
        Inv2iKp.makePart(x, stdCell);
        GateRegression.traceGate();
        Inv2iKn.makePart(x, stdCell);
        GateRegression.traceGate();
        Inv2i.makePart(x, stdCell);
        GateRegression.traceGate();
        Nor2.makePart(x, stdCell);
        GateRegression.traceGate();
        Nor2kresetV.makePart(x, stdCell);
        GateRegression.traceGate();
        Nand2.makePart(x, stdCell);
        GateRegression.traceGate();
        Nand2en.makePart(x, stdCell);
        GateRegression.traceGate();
        Nand2PH.makePart(x, stdCell);
        GateRegression.traceGate();
        Nand2PHfk.makePart(x, stdCell);
        GateRegression.traceGate();
        Nand2LT.makePart(x, stdCell);
        GateRegression.traceGate();
        Nand2_sy.makePart(x, stdCell);
        GateRegression.traceGate();
        Nand2HLT_sy.makePart(x, stdCell);
        GateRegression.traceGate();
        Nand2LT_sy.makePart(x, stdCell);
        GateRegression.traceGate();
        Nand3.makePart(x, stdCell);
        GateRegression.traceGate();
        Nand3LT.makePart(x, stdCell);
        GateRegression.traceGate();
        Nand3MLT.makePart(x, stdCell);
        GateRegression.traceGate();
        Nand3LT_sy3.makePart(x, stdCell);
        GateRegression.traceGate();
        Nand3en.makePart(x, stdCell);
        GateRegression.traceGate();
        Nand3LTen.makePart(x, stdCell);
        GateRegression.traceGate();
    }

    private static void allSizes(StdCellParams stdCell) {
        double minSz = 0.1;
        double maxSz = 500.0;
        for (double d = minSz; d < maxSz; d *= 10.0) {
            for (double x = d; x < Math.min(d * 10.0, maxSz); x *= 1.01) {
                GateRegression.aPass(x, stdCell);
            }
        }
    }

    public boolean doIt() {
        System.out.println("begin execution of Gates");
        Library scratchLib = LayoutLib.openLibForWrite("scratch", "scratch");
        StdCellParams stdCell = new StdCellParams(scratchLib);
        stdCell.enableNCC("purpleFour");
        stdCell.setSizeQuantizationError(0.05);
        stdCell.setMaxMosWidth(1000.0);
        stdCell.setVddY(21.0);
        stdCell.setGndY(-21.0);
        stdCell.setNmosWellHeight(42.0);
        stdCell.setPmosWellHeight(42.0);
        GateRegression.allSizes(stdCell);
        Cell gallery = Gallery.makeGallery(scratchLib);
        DrcRings.addDrcRings(gallery, FILTER);
        LayoutLib.writeLibrary(scratchLib);
        System.out.println("done.");
        return true;
    }

    public GateRegression() {
        super("Run Gate regression", User.tool, Job.Type.CHANGE, null, null, Job.Priority.ANALYSIS);
        this.startJob();
    }
}

