/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.text;

import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.tool.user.User;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TextUtils {
    private static NumberFormat numberFormat = null;
    private static NumberFormat numberFormatSpecific = null;
    private static SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMMM dd, yyyy HH:mm:ss");

    public static double atof(String text) {
        return TextUtils.atof(text, null);
    }

    public static double atof(String text, Double defaultVal) {
        double v = 0.0;
        try {
            v = Double.parseDouble(text);
        }
        catch (NumberFormatException ex) {
            int start;
            for (start = 0; start < text.length() && text.charAt(start) == ' '; ++start) {
            }
            int end = start;
            if (end < text.length() && (text.charAt(end) == '-' || text.charAt(end) == '+')) {
                ++end;
            }
            while (end < text.length() && Character.isDigit(text.charAt(end))) {
                ++end;
            }
            if (end < text.length() && text.charAt(end) == '.') {
                ++end;
                while (end < text.length() && Character.isDigit(text.charAt(end))) {
                    ++end;
                }
            }
            if (end < text.length() && (text.charAt(end) == 'e' || text.charAt(end) == 'E')) {
                if (++end < text.length() && (text.charAt(end) == '-' || text.charAt(end) == '+')) {
                    ++end;
                }
                while (end < text.length() && Character.isDigit(text.charAt(end))) {
                    ++end;
                }
            }
            if (end <= start) {
                if (defaultVal != null) {
                    return defaultVal;
                }
                return 0.0;
            }
            v = Double.parseDouble(text.substring(start, end - start));
        }
        return v;
    }

    public static int atoi(String s) {
        return TextUtils.atoi(s, 0, 0);
    }

    public static int atoi(String s, int pos) {
        return TextUtils.atoi(s, pos, 0);
    }

    public static int atoi(String s, int pos, int base) {
        int num = 0;
        int sign = 1;
        int len = s.length();
        if (pos < len && s.charAt(pos) == '-') {
            ++pos;
            sign = -1;
        }
        if (base == 0) {
            base = 10;
            if (pos < len && s.charAt(pos) == '0') {
                base = 8;
                if (++pos < len && (s.charAt(pos) == 'x' || s.charAt(pos) == 'X')) {
                    ++pos;
                    base = 16;
                }
            }
        }
        while (pos < len) {
            char cat = s.charAt(pos);
            if (cat >= 'a' && cat <= 'f' || cat >= 'A' && cat <= 'F') {
                if (base != 16) break;
                num *= 16;
                num = cat >= 'a' && cat <= 'f' ? (num += cat - 97 + 10) : (num += cat - 65 + 10);
            } else {
                if (!Character.isDigit(cat) || cat >= '8' && base == 8) break;
                num = num * base + cat - 48;
            }
            ++pos;
        }
        return num * sign;
    }

    public static String formatDouble(double v) {
        if (numberFormat == null) {
            numberFormat = NumberFormat.getInstance();
        }
        String result = numberFormat.format(v);
        return result;
    }

    public static String formatDouble(double v, int numFractions) {
        if (numberFormatSpecific == null) {
            numberFormatSpecific = NumberFormat.getInstance();
        }
        numberFormatSpecific.setMaximumFractionDigits(numFractions);
        numberFormatSpecific.setMinimumFractionDigits(numFractions);
        return numberFormatSpecific.format(v);
    }

    public static String formatDate(Date date) {
        return simpleDateFormat.format(date);
    }

    public static String toBlankPaddedString(int value, int width) {
        String msg = Integer.toString(value);
        while (msg.length() < width) {
            msg = " " + msg;
        }
        return msg;
    }

    public static String toBlankPaddedString(double value, int width) {
        String msg = Double.toString(value);
        while (msg.length() < width) {
            msg = " " + msg;
        }
        return msg;
    }

    public static boolean isANumber(String pp) {
        int i = 0;
        int len = pp.length();
        if (i < len && (pp.charAt(i) == '+' || pp.charAt(i) == '-')) {
            ++i;
        }
        boolean xflag = false;
        if (i < len - 1 && pp.charAt(i) == '0' && (pp.charAt(i + 1) == 'x' || pp.charAt(i + 1) == 'X')) {
            i += 2;
            xflag = true;
        }
        boolean founddigits = false;
        if (xflag) {
            while (i < len && (Character.isDigit(pp.charAt(i)) || pp.charAt(i) == 'a' || pp.charAt(i) == 'A' || pp.charAt(i) == 'b' || pp.charAt(i) == 'B' || pp.charAt(i) == 'c' || pp.charAt(i) == 'C' || pp.charAt(i) == 'd' || pp.charAt(i) == 'D' || pp.charAt(i) == 'e' || pp.charAt(i) == 'E' || pp.charAt(i) == 'f' || pp.charAt(i) == 'F')) {
                ++i;
                founddigits = true;
            }
        } else {
            while (i < len && (Character.isDigit(pp.charAt(i)) || pp.charAt(i) == '.')) {
                if (pp.charAt(i) != '.') {
                    founddigits = true;
                }
                ++i;
            }
        }
        if (!founddigits) {
            return false;
        }
        if (i == len) {
            return true;
        }
        if (xflag) {
            return false;
        }
        if (pp.charAt(i) != 'e' && pp.charAt(i) != 'E') {
            return false;
        }
        if (++i == len) {
            return false;
        }
        if (pp.charAt(i) == '+' || pp.charAt(i) == '-') {
            ++i;
        }
        if (i == len) {
            return false;
        }
        while (i < len && Character.isDigit(pp.charAt(i))) {
            ++i;
        }
        return i == len;
    }

    public static String getElapsedTime(long milliseconds) {
        int minutes;
        int hours;
        int days;
        if (milliseconds < 60000L) {
            return (double)milliseconds / 1000.0 + " secs";
        }
        StringBuffer buf = new StringBuffer();
        int seconds = (int)milliseconds / 1000;
        if (seconds < 0) {
            seconds = 0;
        }
        if ((days = seconds / 86400) > 0) {
            buf.append(days + " days, ");
        }
        if ((hours = (seconds -= days * 86400) / 3600) > 0) {
            buf.append(hours + " hrs, ");
        }
        if ((minutes = (seconds -= hours * 3600) / 60) > 0) {
            buf.append(minutes + " mins, ");
        }
        buf.append((seconds -= minutes * 60) + " secs");
        return buf.toString();
    }

    public static int findStringInString(String string, String search, int startingPos, boolean caseSensitive, boolean reverse) {
        if (caseSensitive) {
            int i = 0;
            i = reverse ? string.lastIndexOf(search, startingPos) : string.indexOf(search, startingPos);
            return i;
        }
        if (startingPos > 0) {
            string = string.substring(startingPos);
        }
        String stringLC = string.toLowerCase();
        String searchLC = search.toLowerCase();
        int i = 0;
        i = reverse ? stringLC.lastIndexOf(searchLC) : stringLC.indexOf(searchLC);
        if (i >= 0) {
            i += startingPos;
        }
        return i;
    }

    public static String displayedUnits(double value, TextDescriptor.Unit unitType, UnitScale unitScale) {
        String postFix = "";
        if (unitScale == UnitScale.GIGA) {
            value /= 1.0E9;
            postFix = "g";
        } else if (unitScale == UnitScale.MEGA) {
            value /= 1000000.0;
            postFix = "meg";
        } else if (unitScale == UnitScale.KILO) {
            value /= 1000.0;
            postFix = "k";
        } else if (unitScale == UnitScale.MILLI) {
            value *= 1000.0;
            postFix = "m";
        } else if (unitScale == UnitScale.MICRO) {
            value *= 1000000.0;
            postFix = "u";
        } else if (unitScale == UnitScale.NANO) {
            value *= 1.0E9;
            postFix = "n";
        } else if (unitScale == UnitScale.PICO) {
            value *= (double)1.0E12f;
            postFix = "p";
        } else if (unitScale == UnitScale.FEMTO) {
            value *= (double)1.0E15f;
            postFix = "f";
        }
        return value + postFix;
    }

    public static String makeUnits(double value, TextDescriptor.Unit units) {
        if (units == TextDescriptor.Unit.RESISTANCE) {
            return TextUtils.displayedUnits(value, units, User.getResistanceUnits());
        }
        if (units == TextDescriptor.Unit.CAPACITANCE) {
            return TextUtils.displayedUnits(value, units, User.getCapacitanceUnits());
        }
        if (units == TextDescriptor.Unit.INDUCTANCE) {
            return TextUtils.displayedUnits(value, units, User.getInductanceUnits());
        }
        if (units == TextDescriptor.Unit.CURRENT) {
            return TextUtils.displayedUnits(value, units, User.getAmperageUnits());
        }
        if (units == TextDescriptor.Unit.VOLTAGE) {
            return TextUtils.displayedUnits(value, units, User.getVoltageUnits());
        }
        if (units == TextDescriptor.Unit.TIME) {
            return TextUtils.displayedUnits(value, units, User.getTimeUnits());
        }
        return TextUtils.formatDouble(value);
    }

    public static void printLongString(String str) {
        String prefix = "";
        while (str.length() > 80) {
            int i;
            for (i = 80; i > 0 && str.charAt(i) != ' ' && str.charAt(i) != ','; --i) {
            }
            if (i <= 0) {
                i = 80;
            }
            if (str.charAt(i) == ',') {
                ++i;
            }
            System.out.println(prefix + str.substring(0, i));
            if (str.charAt(i) == ' ') {
                ++i;
            }
            str = str.substring(i);
            prefix = "   ";
        }
        System.out.println(prefix + str);
    }

    public static int nameSameNumeric(String name1, String name2) {
        int len1 = name1.length();
        int len2 = name2.length();
        int extent = Math.min(len1, len2);
        for (int pos = 0; pos < extent; ++pos) {
            char ch1 = name1.charAt(pos);
            char ch2 = name2.charAt(pos);
            if (Character.isDigit(ch1) && Character.isDigit(ch2)) {
                char nextCh2;
                char nextCh1;
                int value2;
                int value1 = TextUtils.atoi(name1.substring(pos));
                if (value1 != (value2 = TextUtils.atoi(name2.substring(pos)))) {
                    return value1 - value2;
                }
                while (pos < extent - 1 && (nextCh1 = name1.charAt(pos + 1)) == (nextCh2 = name2.charAt(pos + 1)) && Character.isDigit(nextCh1)) {
                    ++pos;
                }
                continue;
            }
            if (ch1 == ch2) continue;
            return ch1 - ch2;
        }
        return len1 - len2;
    }

    public static URL makeURLToFile(String fileName) {
        File file = new File(fileName);
        try {
            return file.toURL();
        }
        catch (MalformedURLException e) {
            System.out.println("Cannot find file " + fileName);
            return null;
        }
    }

    public static String getFilePath(URL url) {
        if (url == null) {
            return "";
        }
        String filePath = url.getFile();
        int slashPos = filePath.lastIndexOf(47);
        if (slashPos < 0) {
            return "";
        }
        return filePath.substring(0, slashPos + 1);
    }

    public static String getFileNameWithoutExtension(URL url) {
        int dotPos;
        String fileName = url.getFile();
        int slashPos = fileName.lastIndexOf(47);
        if (slashPos >= 0) {
            fileName = fileName.substring(slashPos + 1);
        }
        if ((dotPos = fileName.lastIndexOf(46)) >= 0) {
            fileName = fileName.substring(0, dotPos);
        }
        return fileName;
    }

    public static String getExtension(URL url) {
        if (url == null) {
            return "";
        }
        String fileName = url.getFile();
        int dotPos = fileName.lastIndexOf(46);
        if (dotPos < 0) {
            return "";
        }
        return fileName.substring(dotPos + 1);
    }

    public static InputStream getURLStream(URL url) {
        return TextUtils.getURLStream(url, null);
    }

    public static InputStream getURLStream(URL url, StringBuffer errorMsg) {
        if (url != null) {
            try {
                return url.openStream();
            }
            catch (IOException e) {
                if (errorMsg != null) {
                    errorMsg.append("Error: cannot open " + e.getMessage() + "\n");
                }
                System.out.println("Error: cannot open " + e.getMessage());
            }
        }
        return null;
    }

    public static boolean URLExists(URL url) {
        return TextUtils.URLExists(url, null);
    }

    public static boolean URLExists(URL url, StringBuffer errorMsg) {
        if (url == null) {
            return false;
        }
        try {
            URLConnection con = url.openConnection();
            con.connect();
            if (con.getContentLength() < 0) {
                return false;
            }
        }
        catch (IOException e) {
            if (errorMsg != null) {
                errorMsg.append("Error: cannot open " + e.getMessage() + "\n");
            }
            return false;
        }
        return true;
    }

    public static class UnitScale {
        private final String name;
        private final int index;
        private static final int UNIT_BASE = -3;
        public static final UnitScale GIGA = new UnitScale("giga:  x 1000000000", -3);
        public static final UnitScale MEGA = new UnitScale("mega:  x 1000000", -2);
        public static final UnitScale KILO = new UnitScale("kilo:  x 1000", -1);
        public static final UnitScale NONE = new UnitScale("-:     x 1", 0);
        public static final UnitScale MILLI = new UnitScale("milli: / 1000", 1);
        public static final UnitScale MICRO = new UnitScale("micro: / 1000000", 2);
        public static final UnitScale NANO = new UnitScale("nano:  / 1000000000", 3);
        public static final UnitScale PICO = new UnitScale("pico:  / 1000000000000", 4);
        public static final UnitScale FEMTO = new UnitScale("femto: / 1000000000000000", 5);
        private static final UnitScale[] allUnits = new UnitScale[]{GIGA, MEGA, KILO, NONE, MILLI, MICRO, NANO, PICO, FEMTO};

        private UnitScale(String name, int index) {
            this.name = name;
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public static UnitScale findFromIndex(int index) {
            return allUnits[index - -3];
        }

        public String toString() {
            return this.name;
        }
    }
}

